/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.sessiongraph;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.NbBundle;
import org.tpo.graphvisualizations.sessiongraph.SessionGraphTopComponent;
import org.tpo.graphvisualizations.tools.SceneToPngExporter;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.actions.visualization.LayoutGraphSceneAction;
import org.tpo.visminerbase.visualization.AbstractVisMinerVisualization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionGraph
extends AbstractVisMinerVisualization {
    public static String SESSION_GRAPH_XML_NAME = "SessionGraph";
    SessionGraphTopComponent sessionGraphTopComponent;

    public void showVisualization() {
        this.sessionGraphTopComponent = SessionGraphTopComponent.findInstance();
        this.sessionGraphTopComponent.open();
        this.sessionGraphTopComponent.requestActive();
        this.registerVisualizationInProject();
    }

    public void closeVisualization() {
        this.sessionGraphTopComponent.close();
    }

    public String getVisualizationName() {
        return NbBundle.getMessage(SessionGraph.class, (String)"SessionGraph_Name");
    }

    public void makeActive() {
        if (this.sessionGraphTopComponent != null) {
            this.logInfo("Making top component active.");
            this.sessionGraphTopComponent.requestActive();
        }
    }

    public void repaint() {
        JComponent theView = VisMinerApplication.getInstance().getSessionGraphScene().getView();
        if (theView != null) {
            theView.repaint();
        }
    }

    public void saveToElement(Element anElement) {
        this.logInfo("Saving session graph visualization to element");
        Element theElement = new Element(SESSION_GRAPH_XML_NAME);
        anElement.addContent((Content)theElement);
    }

    public void exportToFile() {
        SceneToPngExporter.exportSceneToPng((Scene)VisMinerApplication.getInstance().getSessionGraphScene());
    }

    public List<Action> getAdditionalAction() {
        ArrayList<Action> theActionList = new ArrayList<Action>();
        theActionList.add((Action)new LayoutGraphSceneAction());
        return theActionList;
    }
}

