/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.tools;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.NbBundle;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.visminerbase.ui.VisMinerUI;

public class SceneToPngExporter {
    public static void exportSceneToPng(Scene aScene) {
        BufferedImage bi = new BufferedImage(aScene.getView().getSize().width, aScene.getView().getSize().height, 6);
        Graphics2D graphics = bi.createGraphics();
        aScene.paint(graphics);
        graphics.dispose();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(SceneToPngExporter.class, (String)"DialogTitle"));
        chooser.setDialogType(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".png");
            }

            public String getDescription() {
                return "Portable Network Graphics (.png)";
            }
        });
        if (chooser.showSaveDialog(null) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (!file.getName().toLowerCase().endsWith(".png")) {
            file = new File(file.getParentFile(), file.getName() + ".png");
        }
        if (file.exists()) {
            // empty if block
        }
        try {
            ImageIO.write((RenderedImage)bi, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
            ApplicationLogger.logWarning(SceneToPngExporter.class, (String)("Error exporting scene to PNG file: " + file.getAbsolutePath()));
            VisMinerUI.showErrorMessageDialog((String)NbBundle.getMessage(SceneToPngExporter.class, (String)"ErrorDialogTitle"), (String)NbBundle.getMessage(SceneToPngExporter.class, (String)"ErrorDialogText"));
        }
    }
}

