/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.kmeansalgorithm;

import java.util.Map;
import org.tpo.kmeansalgorithm.ClusterCenter;
import org.tpo.kmeansalgorithm.KMeansSettings;
import org.tpo.kmeansalgorithm.SeparatingAxis;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKMeansMeasure
extends VisMinerObject {
    private KMeansSettings kMeansSettings;
    private DataSet dataSet;

    public AbstractKMeansMeasure(KMeansSettings aKMeansSettings, DataSet aDataSet) {
        this.kMeansSettings = aKMeansSettings;
        this.dataSet = aDataSet;
    }

    public abstract void initFromKMeansSettings();

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public KMeansSettings getKMeansSettings() {
        return this.kMeansSettings;
    }

    public abstract double measureDistance(int var1, ClusterCenter var2);

    public ClusterCenter findNearestClusterCenter(int dataRecordIndex) {
        ClusterCenter theResult = null;
        double theNearestDistance = Double.MAX_VALUE;
        for (ClusterCenter eachClusterCenter : this.getKMeansSettings().getClusterCenters()) {
            double eachDistance = this.measureDistance(dataRecordIndex, eachClusterCenter);
            if (!(eachDistance < theNearestDistance) || !this.checkAccordingToClusterCenter(dataRecordIndex, eachClusterCenter)) continue;
            theNearestDistance = eachDistance;
            theResult = eachClusterCenter;
        }
        return theResult;
    }

    public boolean checkAccordingToClusterCenterAndSeparatingAxis(int aDataRecordIndex, ClusterCenter aClusterCenter, SeparatingAxis aSeparatingAxis) {
        DataDimension theXDataDimension = aSeparatingAxis.getXDataDimension();
        DataDimension theYDataDimension = aSeparatingAxis.getYDataDimension();
        if (aClusterCenter.getCoordinateForDimension(theXDataDimension) == null || aClusterCenter.getCoordinateForDimension(theYDataDimension) == null) {
            return true;
        }
        return aSeparatingAxis.arePointsOnTheSameSide(theXDataDimension.getNormalizedValue(aDataRecordIndex), theYDataDimension.getNormalizedValue(aDataRecordIndex), aClusterCenter.getCoordinateForDimension(theXDataDimension), aClusterCenter.getCoordinateForDimension(theYDataDimension));
    }

    public boolean checkAccordingToClusterCenter(int aDataRecordIndex, ClusterCenter aClusterCenter) {
        for (SeparatingAxis eacSeparatingAxis : this.getKMeansSettings().getSeparatingAxises()) {
            if (this.checkAccordingToClusterCenterAndSeparatingAxis(aDataRecordIndex, aClusterCenter, eacSeparatingAxis)) continue;
            return false;
        }
        return true;
    }

    public abstract void updateClusterCentersCoordinates(Map<Integer, ClusterCenter> var1, Map<ClusterCenter, Integer> var2);
}

