/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.kmeansalgorithm;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.tpo.kmeansalgorithm.KMeansSettings;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerbase.VisMinerApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterCenter
extends VisMinerObject {
    public static final String PROPERTY_IS_HOVERED = "isHoveredPropery";
    public static final String PROPERTY_IS_SELECTED = "isSelectedProperty";
    public static final String PROPERTY_COLOR_NAME = "clusterCenterColor";
    public static final String CLUSTER_NAME_ATTR_NAME = "ClusterName";
    public static final String CLUSTER_RED_ATTR_NAME = "Red";
    public static final String CLUSTER_GREEN_ATTR_NAME = "Green";
    public static final String CLUSTER_BLUE_ATTR_NAME = "Blue";
    private KMeansSettings kMeansSettings;
    private Map<DataDimension, Double> coordinates = new HashMap<DataDimension, Double>();
    private String clusterName;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private Color clusterCenterColor = Color.YELLOW;
    private boolean hovered = false;
    private boolean selected = false;

    public ClusterCenter(KMeansSettings aSettings) {
        this.kMeansSettings = aSettings;
    }

    public Double getCoordinateForDimension(DataDimension aDataDimension) {
        return this.coordinates.get(aDataDimension);
    }

    public void setCoordinateForDimension(DataDimension aDataDimension, Double aNormalizedValue) {
        this.logInfo("Setting coordinate: {0} for dimension name: {1}", new Object[]{aNormalizedValue, aDataDimension.getDimensionName()});
        this.coordinates.put(aDataDimension, aNormalizedValue);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public Map<DataDimension, Double> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(Map<DataDimension, Double> coordinates) {
        this.coordinates = coordinates;
    }

    public void addPropertyChangeListener(PropertyChangeListener aPropertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(aPropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener aPropertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(aPropertyChangeListener);
    }

    public void setHovered(boolean aHoveredFlag) {
        boolean theOldHovered = this.hovered;
        this.hovered = aHoveredFlag;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_IS_HOVERED, theOldHovered, aHoveredFlag);
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean aSelectedFlag) {
        this.selected = aSelectedFlag;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_IS_SELECTED, null, (Object)this.selected);
    }

    public KMeansSettings getKMeansSettings() {
        return this.kMeansSettings;
    }

    public void setClusterCenterColor(Color clusterCenterColor) {
        this.clusterCenterColor = clusterCenterColor;
        VisMinerApplication.getInstance().repaintAllVisualization();
    }

    public Color getClusterCenterColor() {
        return this.clusterCenterColor;
    }

    public void saveAttributesToElement(Element anElement) {
        if (this.getClusterName() != null) {
            anElement.setAttribute(CLUSTER_NAME_ATTR_NAME, this.getClusterName());
            if (this.getClusterCenterColor() != null) {
                anElement.setAttribute(CLUSTER_RED_ATTR_NAME, Integer.toString(this.getClusterCenterColor().getRed()));
                anElement.setAttribute(CLUSTER_GREEN_ATTR_NAME, Integer.toString(this.getClusterCenterColor().getGreen()));
                anElement.setAttribute(CLUSTER_BLUE_ATTR_NAME, Integer.toString(this.getClusterCenterColor().getBlue()));
            }
        }
    }

    public void loadAttributesFromElement(Element anElement) {
        this.setClusterName(anElement.getAttributeValue(CLUSTER_NAME_ATTR_NAME));
        String theRedString = anElement.getAttributeValue(CLUSTER_RED_ATTR_NAME);
        String theGreenString = anElement.getAttributeValue(CLUSTER_GREEN_ATTR_NAME);
        String theBlueString = anElement.getAttributeValue(CLUSTER_BLUE_ATTR_NAME);
        if (theRedString != null && theBlueString != null && theGreenString != null) {
            try {
                int theRed = new Integer(theRedString);
                int theGreen = new Integer(theGreenString);
                int theBlue = new Integer(theBlueString);
                this.setClusterCenterColor(new Color(theRed, theGreen, theBlue));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

