/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.kmeansalgorithm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.tpo.kmeansalgorithm.AbstractKMeansMeasure;
import org.tpo.kmeansalgorithm.ClusterCenter;
import org.tpo.kmeansalgorithm.KMeansSettings;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonDimensionsKMeansMeasure
extends AbstractKMeansMeasure {
    private List<DataDimension> commonDimensions;

    public CommonDimensionsKMeansMeasure(KMeansSettings aKMeansSettings, DataSet aDataSet) {
        super(aKMeansSettings, aDataSet);
    }

    @Override
    public double measureDistance(int dataRecordIndex, ClusterCenter aClusterCenter) {
        double theSqSum = 0.0;
        for (DataDimension eachDataDimension : this.commonDimensions) {
            Double theCoordDelta = eachDataDimension.getNormalizedValue(dataRecordIndex) - aClusterCenter.getCoordinateForDimension(eachDataDimension);
            theSqSum += theCoordDelta * theCoordDelta;
        }
        return Math.sqrt(theSqSum);
    }

    @Override
    public void initFromKMeansSettings() {
        this.logInfo("initFromKMeansSettings()");
        HashSet theCandidates = new HashSet(this.getDataSet().getDimensions());
        for (DataDimension eachDimension : this.getDataSet().getDimensions()) {
            for (ClusterCenter eachClusterCenter : this.getKMeansSettings().getClusterCenters()) {
                if (eachClusterCenter.getCoordinateForDimension(eachDimension) != null) continue;
                theCandidates.remove(eachDimension);
            }
        }
        this.logInfo("initFromKMeansSettings() - number of common dimension: {0}", new Object[]{theCandidates.size()});
        this.commonDimensions = new ArrayList<DataDimension>(theCandidates);
    }

    @Override
    public void updateClusterCentersCoordinates(Map<Integer, ClusterCenter> computedClusters, Map<ClusterCenter, Integer> clusterSizes) {
        int theDimCount = this.commonDimensions.size();
        List<ClusterCenter> clusterCenters = this.getKMeansSettings().getClusterCenters();
        int theCenterCount = clusterCenters.size();
        double[][] newCoords = new double[theDimCount][theCenterCount];
        for (int x = 0; x < theDimCount; ++x) {
            for (int y = 0; y < theCenterCount; ++y) {
                newCoords[x][y] = 0.0;
            }
        }
        for (Integer eachRecord : computedClusters.keySet()) {
            ClusterCenter theClusterCenter = computedClusters.get(eachRecord);
            if (theClusterCenter == null) continue;
            int centIndex = clusterCenters.indexOf((Object)theClusterCenter);
            for (int dimIndex = 0; dimIndex < theDimCount; ++dimIndex) {
                double theNormValue = this.commonDimensions.get(dimIndex).getNormalizedValue(eachRecord.intValue());
                double[] dArray = newCoords[dimIndex];
                int n = centIndex;
                dArray[n] = dArray[n] + theNormValue;
            }
        }
        for (int dimI = 0; dimI < theDimCount; ++dimI) {
            DataDimension eachDimension = this.commonDimensions.get(dimI);
            for (int centI = 0; centI < theCenterCount; ++centI) {
                ClusterCenter eachCenter = clusterCenters.get(centI);
                Integer eachClusterSize = clusterSizes.get((Object)eachCenter);
                if (eachClusterSize == null || eachClusterSize == 0) {
                    clusterSizes.get("clusterSize: " + eachClusterSize);
                    continue;
                }
                newCoords[dimI][centI] = newCoords[dimI][centI] / eachClusterSize.doubleValue();
                eachCenter.setCoordinateForDimension(eachDimension, newCoords[dimI][centI]);
            }
        }
    }
}

