/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.kmeansalgorithm;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.tpo.kmeansalgorithm.ClusterCenter;
import org.tpo.kmeansalgorithm.KMeansAlgorithm;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerapi.datastorage.data.DataValue;
import org.tpo.visminerapi.datastorage.session.SessionObject;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.datastorage.session.AbstractSessionObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputedCluster
extends AbstractSessionObject
implements DataSet {
    private KMeansAlgorithm kMeansAlgorithm;
    private ClusterCenter clusterCenter;
    private DataSet parentDataSet;
    public static final Color DEFAULT_POINT_NOT_IN_DATASET_COLOR = Color.lightGray;
    public static final Color DEFAULT_POINT_IN_DATASET_COLOR = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    private Map<DataDimension, Double> dimensionMiddleValueMap = new HashMap<DataDimension, Double>();
    private Double dispersion;

    public ComputedCluster(KMeansAlgorithm aKMeansAlgorithm, ClusterCenter aClusterCenter, DataSet aParentDataSet) {
        this.kMeansAlgorithm = aKMeansAlgorithm;
        this.clusterCenter = aClusterCenter;
        this.parentDataSet = aParentDataSet;
        this.setName(aClusterCenter.getClusterName());
    }

    private boolean isDataRecordInCluster(int aDataRecordIndex) {
        return ((Object)((Object)this.clusterCenter)).equals((Object)this.kMeansAlgorithm.getDataRecordClusterCenter(new Integer(aDataRecordIndex)));
    }

    public Color chooseDataRecordColor(int aDataRecordIndex) {
        if (this.isDataRecordInCluster(aDataRecordIndex)) {
            return this.clusterCenter.getClusterCenterColor();
        }
        return DEFAULT_POINT_NOT_IN_DATASET_COLOR;
    }

    public int getPhysicalRecordsCount() {
        return this.parentDataSet.getPhysicalRecordsCount();
    }

    public int getLogicalRecordsCount() {
        Integer theSize = this.kMeansAlgorithm.getClusterSize(this);
        if (theSize != null) {
            return theSize;
        }
        return 0;
    }

    public int getDimensionsCount() {
        return this.parentDataSet.getDimensionsCount();
    }

    public List<DataDimension<?>> getDimensions() {
        return this.parentDataSet.getDimensions();
    }

    public List<DataDimension<Double>> getDoubleDimensions() {
        return this.parentDataSet.getDoubleDimensions();
    }

    public List<DataValue> getDataValuesForDiemnsion(DataDimension aDimension) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isDataValueInDataSet(DataValue aDataValue) {
        return this.isDataValueInDataSet(aDataValue.getPhysicalDataIndex());
    }

    public boolean isDataValueInDataSet(int anIndex) {
        return this.isDataRecordInCluster(anIndex);
    }

    public DataSet getDataSet() {
        return this;
    }

    public DataDimension getDimensionForName(String aDimensionName) {
        return this.parentDataSet.getDimensionForName(aDimensionName);
    }

    public SessionObject.SessionObjectType getSessionObjecType() {
        return SessionObject.SessionObjectType.DATASET;
    }

    public List<Node.Property> getEditableProperties() {
        List theResult = super.getEditableProperties();
        try {
            PropertySupport.Reflection theClusterColorProperty = new PropertySupport.Reflection((Object)this.clusterCenter, Color.class, "clusterCenterColor");
            theClusterColorProperty.setName("clusterCenterColor");
            theClusterColorProperty.setDisplayName(NbBundle.getMessage(ClusterCenter.class, (String)"PROPERTY_Color"));
            theResult.add(theClusterColorProperty);
            PropertySupport.ReadOnly<Integer> theClusterSizeProperty = new PropertySupport.ReadOnly<Integer>("ClusterSize", Integer.class, NbBundle.getMessage(ComputedCluster.class, (String)"PROPERTY_ClusterSize"), NbBundle.getMessage(ComputedCluster.class, (String)"PROPERTY_ClusterSizeDesc")){

                public Integer getValue() throws IllegalAccessException, InvocationTargetException {
                    return new Integer(ComputedCluster.this.getLogicalRecordsCount());
                }
            };
            theResult.add(theClusterSizeProperty);
            PropertySupport.ReadOnly<String> theMiddleValue = new PropertySupport.ReadOnly<String>("MIddleValue", String.class, NbBundle.getMessage(ComputedCluster.class, (String)"PROPERTY_MiddleValue"), NbBundle.getMessage(ComputedCluster.class, (String)"PROPERTY_MiddleValueDesc")){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return ComputedCluster.this.getMiddleRecordString();
                }
            };
            theResult.add(theMiddleValue);
            PropertySupport.ReadOnly<String> theDispersion = new PropertySupport.ReadOnly<String>("Dispersion", String.class, NbBundle.getMessage(ComputedCluster.class, (String)"PROPERTY_Dispersion"), NbBundle.getMessage(ComputedCluster.class, (String)"PROPERTY_DispersionDesc")){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return ComputedCluster.this.getDispersionString();
                }
            };
            theResult.add(theDispersion);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return theResult;
    }

    public ClusterCenter getClusterCenter() {
        return this.clusterCenter;
    }

    public List<Action> getAdditionalAction() {
        return new ArrayList<Action>();
    }

    public String getMiddleRecordString() {
        StringBuffer theResultBuff = new StringBuffer();
        for (DataDimension eachDimension : VisMinerApplication.getInstance().getPhysicalDataSet().getDoubleDimensions()) {
            theResultBuff.append(eachDimension.getDimensionName());
            theResultBuff.append(": ");
            DecimalFormat formatter = new DecimalFormat("0.0000");
            Double theMiddleValue = this.getMiddleValueForDimension(eachDimension);
            double theValue = eachDimension.getMinimalValue() + theMiddleValue * (eachDimension.getMaximalValue() - eachDimension.getMinimalValue());
            theResultBuff.append(formatter.format(theValue));
            theResultBuff.append("\n");
        }
        return theResultBuff.toString();
    }

    public double getMiddleValueForDimension(DataDimension aDimension) {
        Double theResult = this.dimensionMiddleValueMap.get(aDimension);
        if (theResult == null) {
            HashMap<Double, Integer> valueCountMap = new HashMap<Double, Integer>();
            int countedValues = 0;
            for (int anIndex = 0; anIndex < this.getPhysicalRecordsCount(); ++anIndex) {
                if (!this.isDataRecordInCluster(anIndex)) continue;
                Double theValue = aDimension.getNormalizedValue(anIndex);
                Integer theCount = (Integer)valueCountMap.get(theValue);
                theCount = theCount == null ? new Integer(1) : new Integer(theCount + 1);
                valueCountMap.put(theValue, theCount);
                ++countedValues;
            }
            double theMiddleValue = 0.0;
            double theRecCount = this.getLogicalRecordsCount();
            for (Double eachValue : valueCountMap.keySet()) {
                theMiddleValue += eachValue * (((Integer)valueCountMap.get(eachValue)).doubleValue() / theRecCount);
            }
            theResult = new Double(theMiddleValue);
            this.dimensionMiddleValueMap.put(aDimension, theResult);
        }
        return theResult;
    }

    public String getDispersionString() {
        DecimalFormat formatter = new DecimalFormat("0.00000000");
        return formatter.format(this.getDispersion());
    }

    public Double getDispersion() {
        if (this.dispersion == null) {
            double theSum = 0.0;
            for (int anIndex = 0; anIndex < this.getPhysicalRecordsCount(); ++anIndex) {
                if (!this.isDataRecordInCluster(anIndex)) continue;
                double theDist = this.getDistanceFromMiddleValue(anIndex);
                theSum += theDist * theDist;
            }
            this.dispersion = new Double(theSum /= (double)this.getLogicalRecordsCount());
        }
        return this.dispersion;
    }

    public double getDistanceFromMiddleValue(int anRecordIndex) {
        double theDist = 0.0;
        for (DataDimension eachDimension : VisMinerApplication.getInstance().getPhysicalDataSet().getDoubleDimensions()) {
            theDist += (eachDimension.getNormalizedValue(anRecordIndex) - this.getMiddleValueForDimension(eachDimension)) * (eachDimension.getNormalizedValue(anRecordIndex) - this.getMiddleValueForDimension(eachDimension));
        }
        theDist = Math.sqrt(theDist);
        return theDist;
    }
}

