/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.kmeansalgorithm;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.Action;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.tpo.kmeansalgorithm.ClusterCenter;
import org.tpo.kmeansalgorithm.ComputedCluster;
import org.tpo.kmeansalgorithm.DeleteAlgorithmResultsAction;
import org.tpo.kmeansalgorithm.KMeansSettings;
import org.tpo.kmeansalgorithm.SeparatingAxis;
import org.tpo.visminerapi.algorithm.Algorithm;
import org.tpo.visminerapi.algorithm.AlgorithmSettings;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerapi.datastorage.data.DataValue;
import org.tpo.visminerapi.datastorage.data.Filter;
import org.tpo.visminerapi.datastorage.session.SessionObject;
import org.tpo.visminerapi.exceptions.SessionBuilderException;
import org.tpo.visminerapi.exceptions.VisMinerRuntimeException;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.datastorage.session.AbstractSessionObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansAlgorithm
extends AbstractSessionObject
implements Algorithm,
Runnable {
    public static final String KMEANS_ALGORITHM_XML_NAME = "KMeansAlgorithm";
    public static final String CLUSTER_CENTER_XML_NAME = "ClusterCenter";
    public static final String SEPARATING_AXIS_XML_NAME = "SeparatingAxis";
    public static final String COMPUTED_CLUSTER_XML_NAME = "ComputedCluster";
    public static final String DIMENSION_COORDINATE_XML_NAME = "DimensionCoordinate";
    public static final String DIMENSION_NAME_ATTR = "Name";
    public static final String DIMENSION_COORDINATE_ATTR = "Value";
    public static final String XDIMENSION_NAME_ATTR_NAME = "xDimensionName";
    public static final String XDIMENSION_START_COORD_NAME = "xStartCoord";
    public static final String XDIMENSION_END_COORD_NAME = "xEndCoord";
    public static final String YDIMENSION_NAME_ATTR_NAME = "yDimensionName";
    public static final String YDIMENSION_START_COORD_NAME = "yStartCoord";
    public static final String YDIMENSION_END_COORD_NAME = "yEndCoord";
    public static final String ALGORITHM_STATE_ATTR_NAME = "AlgorithmState";
    public static final String PROPERTY_KMEANS_SETTINGS = "propertyKMmeansSettings";
    public static final String PROPERTY_SETTINGS_STATE = "propertySettingsState";
    public static final Color DEFAULT_POINT_NOT_IN_DATASET_COLOR = Color.lightGray;
    private KMeansSettings kMeansSettings;
    private SettingsState settingsState;
    private Algorithm.AlgorithmState algorithmState;
    private boolean computing;
    private Map<Integer, ClusterCenter> computedAssignmentToCenter;
    private Map<ClusterCenter, ComputedCluster> computedClusters;
    private Map<ClusterCenter, Integer> clusterSizes = new HashMap<ClusterCenter, Integer>();

    public void resetToConfiguringState() {
        if (Algorithm.AlgorithmState.CONFIGURING.equals((Object)this.getAlgorithmState())) {
            return;
        }
        for (SessionObject eachSessionObject : this.getChildren()) {
            if (eachSessionObject.canPerformDelete()) continue;
            return;
        }
        ArrayList theChildren = new ArrayList(this.getChildren());
        for (SessionObject eachSessionObject : theChildren) {
            eachSessionObject.performDelete();
        }
        this.computedAssignmentToCenter = null;
        this.computedClusters = null;
        this.clusterSizes.clear();
        this.setAlgorithmState(Algorithm.AlgorithmState.CONFIGURING);
        VisMinerApplication.getInstance().repaintAllVisualization();
    }

    public KMeansAlgorithm(KMeansSettings aKMeansSettings) {
        this.kMeansSettings = aKMeansSettings;
        this.kMeansSettings.setKMeansAlgorithm(this);
        this.settingsState = SettingsState.ADDING_CENTERS;
        this.algorithmState = Algorithm.AlgorithmState.CONFIGURING;
        this.computing = false;
    }

    public AlgorithmSettings getAlgortihmSettings() {
        return this.kMeansSettings;
    }

    public KMeansSettings getKMeansSettings() {
        return this.kMeansSettings;
    }

    public void setAlgorithmSettings(AlgorithmSettings anAlgorithmSettings) {
        if (!(anAlgorithmSettings instanceof KMeansSettings)) {
            this.logError("Unsuported settings type. KMeansSettings object is required");
            throw new VisMinerRuntimeException("Unsuported settings type. KMeansSettings object is required");
        }
        this.kMeansSettings = (KMeansSettings)anAlgorithmSettings;
    }

    public String getAlgorithmName() {
        return NbBundle.getMessage(KMeansAlgorithm.class, (String)"KMeansAlgorithmName");
    }

    public boolean isDataValueInFilter(DataValue aDataValue) {
        return this.isDataValueInFilter(aDataValue.getPhysicalDataIndex());
    }

    public boolean isDataValueInFilter(int anIndex) {
        return true;
    }

    public Filter getFilter() {
        return this;
    }

    public void pointClikced(DataDimension aXDimension, double aXCoord, DataDimension aYDimension, double aYCoord) {
        if (this.getKMeansSettings().getSelectedClusterCenter() != null) {
            ClusterCenter theSelectedClusterCenter = this.getKMeansSettings().getSelectedClusterCenter();
            if (theSelectedClusterCenter.getCoordinateForDimension(aXDimension) != null && theSelectedClusterCenter.getCoordinateForDimension(aYDimension) != null) {
                this.getKMeansSettings().selectClusterCenter(null);
            } else {
                this.logInfo("Updating coordinates of selected cluster center.");
                theSelectedClusterCenter.setCoordinateForDimension(aXDimension, aXCoord);
                theSelectedClusterCenter.setCoordinateForDimension(aYDimension, aYCoord);
                this.propertyChangeSupport.firePropertyChange(PROPERTY_KMEANS_SETTINGS, null, (Object)this.getKMeansSettings());
            }
        } else {
            this.logInfo("Creating new cluster center.");
            this.addClusterCenter(aXDimension, aXCoord, aYDimension, aYCoord);
        }
    }

    public void addClusterCenter(DataDimension aXDim, double aXCoord, DataDimension aYDim, double aYCoord) {
        ClusterCenter theClusterCenter = new ClusterCenter(this.kMeansSettings);
        theClusterCenter.setCoordinateForDimension(aXDim, aXCoord);
        theClusterCenter.setCoordinateForDimension(aYDim, aYCoord);
        theClusterCenter.setClusterName(String.valueOf(this.getKMeansSettings().getClusterCenters().size() + 1));
        this.getKMeansSettings().addClusterCenter(theClusterCenter);
        theClusterCenter.setClusterCenterColor(KMeansAlgorithm.pickRandomColor());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KMEANS_SETTINGS, null, (Object)this.getKMeansSettings());
    }

    public void addSeparatingAxis(DataDimension aXDataDimension, DataDimension aYDataDimension, Line2D.Double aNormalizeLine) {
        SeparatingAxis theSeparatingAxis = new SeparatingAxis(this.kMeansSettings, aXDataDimension, aYDataDimension, aNormalizeLine);
        this.getKMeansSettings().addSeparatingAxis(theSeparatingAxis);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KMEANS_SETTINGS, null, (Object)this.getKMeansSettings());
    }

    public static Color pickRandomColor() {
        Random rand = new Random();
        return new Color(rand.nextInt(256), rand.nextInt(256), rand.nextInt(256));
    }

    public void setSettingsState(SettingsState aSettingsState) {
        SettingsState theOldSettingsState = this.settingsState;
        this.settingsState = aSettingsState;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SETTINGS_STATE, (Object)theOldSettingsState, (Object)aSettingsState);
    }

    public SettingsState getSettingsState() {
        return this.settingsState;
    }

    public Algorithm.AlgorithmState getAlgorithmState() {
        return this.algorithmState;
    }

    public void setAlgorithmState(Algorithm.AlgorithmState anAlgorithmState) {
        Algorithm.AlgorithmState theOldAlgorithmState = this.algorithmState;
        this.algorithmState = anAlgorithmState;
        this.propertyChangeSupport.firePropertyChange("propertyAlgoprithmState", theOldAlgorithmState, anAlgorithmState);
    }

    public void runAlgorithm() {
        this.logInfo("Running KMeans algorithm in separate thread");
        if (this.getKMeansSettings().getClusterCenters().size() == 0) {
            this.logInfo("No CLuster Centers specified.");
            return;
        }
        this.setComputing(true);
        this.setAlgorithmState(Algorithm.AlgorithmState.RUNNING);
        Thread theThread = new Thread(this);
        theThread.start();
    }

    @Override
    public void run() {
        this.computeAlgorithm(false);
    }

    public void computeAlgorithm(boolean aRecomputingFlag) {
        this.logInfo("computeAlgorithm()");
        this.getKMeansSettings().selectClusterCenter(null);
        this.getKMeansSettings().getKMeansMeasure().initFromKMeansSettings();
        for (int roundIndex = 0; roundIndex < this.getKMeansSettings().getMaximalRoundCount(); ++roundIndex) {
            this.updateClusterCenters();
            this.computeNextKMeansRound(roundIndex);
        }
        if (!aRecomputingFlag) {
            this.createComputedClusters();
        }
        this.setComputing(false);
        this.setAlgorithmState(Algorithm.AlgorithmState.FINISHED);
        VisMinerApplication.getInstance().repaintAllVisualization();
        this.logInfo("KMeans algorithm thread finished");
    }

    private void createComputedClusters() {
        this.computedClusters = new HashMap<ClusterCenter, ComputedCluster>();
        for (ClusterCenter eachClusterCenter : this.getKMeansSettings().getClusterCenters()) {
            this.logInfo("createComputedClusters() - creating ComputedCluster for ClusterCenter with name {0}", new Object[]{eachClusterCenter.getClusterName()});
            ComputedCluster theComputedCluster = new ComputedCluster(this, eachClusterCenter, this.getKMeansSettings().getDataSet());
            theComputedCluster.setParent((SessionObject)this);
            this.addChild((SessionObject)theComputedCluster);
            this.computedClusters.put(eachClusterCenter, theComputedCluster);
        }
    }

    public synchronized boolean isComputing() {
        return this.computing;
    }

    public synchronized void setComputing(boolean computing) {
        this.computing = computing;
    }

    private ClusterCenter pickRandomClusterCenter() {
        int clusterIndex = (int)Math.round((double)(this.getKMeansSettings().getClusterCenters().size() - 1) * Math.random());
        return this.getKMeansSettings().getClusterCenters().get(clusterIndex);
    }

    private void computeNextKMeansRound(int aRoundIndex) {
        this.logInfo("computeNextKMeansRound()");
        DataSet theDataSet = this.getKMeansSettings().getDataSet();
        HashMap<Integer, ClusterCenter> theNewClusters = new HashMap<Integer, ClusterCenter>();
        this.clusterSizes = new HashMap<ClusterCenter, Integer>();
        for (int recordIndex = 0; recordIndex < theDataSet.getPhysicalRecordsCount(); ++recordIndex) {
            if (!theDataSet.isDataValueInDataSet(recordIndex)) continue;
            ClusterCenter theNearestCluster = this.getKMeansSettings().getKMeansMeasure().findNearestClusterCenter(recordIndex);
            theNewClusters.put(new Integer(recordIndex), theNearestCluster);
            int currentCount = 0;
            if (this.clusterSizes.get((Object)theNearestCluster) != null) {
                currentCount = this.clusterSizes.get((Object)theNearestCluster);
            }
            this.clusterSizes.put(theNearestCluster, new Integer(currentCount + 1));
        }
        this.computedAssignmentToCenter = theNewClusters;
        this.logInfo("computeNextKMeansRound() - finished");
    }

    private void updateClusterCenters() {
        this.logInfo("updateClusterCenters()");
        if (this.clusterSizes != null && this.computedAssignmentToCenter != null) {
            this.getKMeansSettings().getKMeansMeasure().updateClusterCentersCoordinates(this.computedAssignmentToCenter, this.clusterSizes);
        } else {
            this.logInfo("updateClusterCenters() - clusterSise or computedClusters is null");
        }
        this.logInfo("updateClusterCenters() - finished");
    }

    public Color chooseDataRecordColor(int aDataRecordIndex) {
        if (this.computedAssignmentToCenter == null) {
            return this.getParent().chooseDataRecordColor(aDataRecordIndex);
        }
        ClusterCenter recordCluster = this.computedAssignmentToCenter.get(new Integer(aDataRecordIndex));
        if (recordCluster != null) {
            return recordCluster.getClusterCenterColor();
        }
        return DEFAULT_POINT_NOT_IN_DATASET_COLOR;
    }

    public ClusterCenter getDataRecordClusterCenter(Integer aDataRecordIndex) {
        return this.computedAssignmentToCenter.get(aDataRecordIndex);
    }

    public Element getSessionObjectXMLElement() {
        Element theElement = new Element(KMEANS_ALGORITHM_XML_NAME);
        this.saveAttributesToElement(theElement);
        if (this.computedClusters != null) {
            for (ClusterCenter eachCenter : this.computedClusters.keySet()) {
                ComputedCluster eachComputedCluster = this.computedClusters.get((Object)eachCenter);
                theElement.addContent((Content)this.createClusterCenterElement(eachCenter, eachComputedCluster));
            }
        }
        if (this.getKMeansSettings().getSeparatingAxises() != null) {
            for (SeparatingAxis eachAxis : this.getKMeansSettings().getSeparatingAxises()) {
                theElement.addContent((Content)this.createSeparatingAxisElement(eachAxis));
            }
        }
        return theElement;
    }

    private Element createSeparatingAxisElement(SeparatingAxis aSeparatingAxis) {
        Element theElement = new Element(SEPARATING_AXIS_XML_NAME);
        theElement.setAttribute(XDIMENSION_NAME_ATTR_NAME, aSeparatingAxis.getXDataDimension().getDimensionName());
        theElement.setAttribute(XDIMENSION_START_COORD_NAME, Double.toString(aSeparatingAxis.getNormalizedLine().getX1()));
        theElement.setAttribute(XDIMENSION_END_COORD_NAME, Double.toString(aSeparatingAxis.getNormalizedLine().getX2()));
        theElement.setAttribute(YDIMENSION_NAME_ATTR_NAME, aSeparatingAxis.getYDataDimension().getDimensionName());
        theElement.setAttribute(YDIMENSION_START_COORD_NAME, Double.toString(aSeparatingAxis.getNormalizedLine().getY1()));
        theElement.setAttribute(YDIMENSION_END_COORD_NAME, Double.toString(aSeparatingAxis.getNormalizedLine().getY2()));
        return theElement;
    }

    public void saveAttributesToElement(Element anElement) {
        super.saveAttributesToElement(anElement);
        anElement.setAttribute(ALGORITHM_STATE_ATTR_NAME, this.getAlgorithmState().toString());
    }

    public void loadAttributesFromElement(Element anElement) {
        super.loadAttributesFromElement(anElement);
        this.setAlgorithmState(Algorithm.AlgorithmState.valueOf((String)anElement.getAttributeValue(ALGORITHM_STATE_ATTR_NAME)));
    }

    private Element createClusterCenterElement(ClusterCenter aClusterCenter, ComputedCluster aComputedCluster) {
        Element theClusterCenterElement = new Element(CLUSTER_CENTER_XML_NAME);
        aClusterCenter.saveAttributesToElement(theClusterCenterElement);
        for (DataDimension eachDataDimension : aClusterCenter.getCoordinates().keySet()) {
            Double eachCoordinate = aClusterCenter.getCoordinateForDimension(eachDataDimension);
            Element theDimensionElement = new Element(DIMENSION_COORDINATE_XML_NAME);
            theDimensionElement.setAttribute(DIMENSION_NAME_ATTR, eachDataDimension.getDimensionName());
            theDimensionElement.setAttribute(DIMENSION_COORDINATE_ATTR, eachCoordinate.toString());
            theClusterCenterElement.addContent((Content)theDimensionElement);
        }
        Element theComputedClusterElement = aComputedCluster.getSessionObjectXMLElement();
        theComputedClusterElement.setName(COMPUTED_CLUSTER_XML_NAME);
        theClusterCenterElement.addContent((Content)theComputedClusterElement);
        return theClusterCenterElement;
    }

    public void initClusterCentersFromElements(List<Element> anElementList) throws SessionBuilderException {
        this.logInfo("Creating cluster centers from elements.");
        for (Element eachElement : anElementList) {
            ClusterCenter theClusterCenter = this.createClusterCenterFromElement(eachElement, this.getKMeansSettings());
            this.getKMeansSettings().addClusterCenter(theClusterCenter);
        }
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KMEANS_SETTINGS, null, (Object)this.getKMeansSettings());
    }

    public void initSeparatingAxisesFromElements(List<Element> anElementList) throws SessionBuilderException {
        this.logInfo("Creating separating axises from elements #{0}", new Object[]{anElementList.size()});
        for (Element eachElement : anElementList) {
            SeparatingAxis theSeparatingAxis = this.createSeparatingAxisFromElement(eachElement, this.getKMeansSettings());
            this.getKMeansSettings().addSeparatingAxis(theSeparatingAxis);
        }
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KMEANS_SETTINGS, null, (Object)this.getKMeansSettings());
    }

    private SeparatingAxis createSeparatingAxisFromElement(Element anElement, KMeansSettings kMeansSettings) {
        String xDimName = anElement.getAttributeValue(XDIMENSION_NAME_ATTR_NAME);
        String yDimName = anElement.getAttributeValue(YDIMENSION_NAME_ATTR_NAME);
        DataDimension theXDataDim = kMeansSettings.getDataSet().getDimensionForName(xDimName);
        DataDimension theYDataDim = kMeansSettings.getDataSet().getDimensionForName(yDimName);
        String theXStartCoordString = anElement.getAttributeValue(XDIMENSION_START_COORD_NAME);
        String theXEndCoordString = anElement.getAttributeValue(XDIMENSION_END_COORD_NAME);
        String theYStartCoordString = anElement.getAttributeValue(YDIMENSION_START_COORD_NAME);
        String theYEndCoordString = anElement.getAttributeValue(YDIMENSION_END_COORD_NAME);
        Double theXStartCoord = new Double(theXStartCoordString);
        Double theXEndCoord = new Double(theXEndCoordString);
        Double theYStartCoord = new Double(theYStartCoordString);
        Double theYEndCoord = new Double(theYEndCoordString);
        Line2D.Double theLine = new Line2D.Double(theXStartCoord, theYStartCoord, theXEndCoord, theYEndCoord);
        return new SeparatingAxis(kMeansSettings, theXDataDim, theYDataDim, theLine);
    }

    private ClusterCenter createClusterCenterFromElement(Element anElement, KMeansSettings aKMeansSettings) throws SessionBuilderException {
        ClusterCenter theClusterCenter = new ClusterCenter(aKMeansSettings);
        theClusterCenter.loadAttributesFromElement(anElement);
        List theDimCoordElemnts = anElement.getChildren(DIMENSION_COORDINATE_XML_NAME);
        for (Element eachElement : theDimCoordElemnts) {
            String theDimName = eachElement.getAttributeValue(DIMENSION_NAME_ATTR);
            String theCoordString = eachElement.getAttributeValue(DIMENSION_COORDINATE_ATTR);
            if (theDimName == null || theCoordString == null) {
                throw new SessionBuilderException("Missing dimension name or coordinate for a cluster center.");
            }
            Double theCoord = null;
            try {
                theCoord = new Double(theCoordString);
            }
            catch (Exception ex) {
                throw new SessionBuilderException("Unable to lood dimension coordinate for a cluster center.");
            }
            theClusterCenter.setCoordinateForDimension(VisMinerApplication.getInstance().getPhysicalDataSet().getDimensionForName(theDimName), theCoord);
        }
        return theClusterCenter;
    }

    public Map<ClusterCenter, ComputedCluster> getComputedClusters() {
        return this.computedClusters;
    }

    public ComputedCluster getComputedClusterForClusterName(String clusterName) {
        for (ClusterCenter eachClusterCenter : this.getComputedClusters().keySet()) {
            if (!clusterName.equals(eachClusterCenter.getClusterName())) continue;
            return this.getComputedClusters().get((Object)eachClusterCenter);
        }
        return null;
    }

    public SessionObject.SessionObjectType getSessionObjecType() {
        return SessionObject.SessionObjectType.FILTER;
    }

    public Integer getClusterSize(ClusterCenter aClusterCenter) {
        return this.clusterSizes.get((Object)aClusterCenter);
    }

    public Integer getClusterSize(ComputedCluster aComputedCluster) {
        return this.getClusterSize(aComputedCluster.getClusterCenter());
    }

    public List<Action> getAdditionalAction() {
        ArrayList<Action> theActions = new ArrayList<Action>();
        if (Algorithm.AlgorithmState.FINISHED.equals((Object)this.getAlgorithmState())) {
            theActions.add(new DeleteAlgorithmResultsAction(this));
        }
        return theActions;
    }

    public void recomputeData() {
        if (Algorithm.AlgorithmState.FINISHED.equals((Object)this.getAlgorithmState())) {
            this.computeAlgorithm(true);
        }
        super.recomputeData();
    }

    public List<Node.Property> getEditableProperties() {
        List theResult = super.getEditableProperties();
        PropertySupport.ReadOnly<String> theDimensionListProperty = new PropertySupport.ReadOnly<String>("DataSetInfo", String.class, NbBundle.getMessage(KMeansAlgorithm.class, (String)"PROPERTY_DimensionList"), NbBundle.getMessage(KMeansAlgorithm.class, (String)"PROPERTY_DimensionListDesc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return KMeansAlgorithm.this.getDimensionListInfo();
            }
        };
        theResult.add(theDimensionListProperty);
        return theResult;
    }

    public String getDimensionListInfo() {
        StringBuffer theResultBuff = new StringBuffer();
        for (DataDimension eachDimension : this.getClusterCentersCommonDimensinList()) {
            theResultBuff.append(eachDimension.getDimensionName());
            theResultBuff.append("\n");
        }
        return theResultBuff.toString();
    }

    public List<DataDimension> getClusterCentersCommonDimensinList() {
        HashSet theCandidates = new HashSet(this.getKMeansSettings().getDataSet().getDimensions());
        for (DataDimension eachDimension : this.getKMeansSettings().getDataSet().getDimensions()) {
            for (ClusterCenter eachClusterCenter : this.getKMeansSettings().getClusterCenters()) {
                if (eachClusterCenter.getCoordinateForDimension(eachDimension) != null) continue;
                theCandidates.remove(eachDimension);
            }
        }
        this.logInfo("initFromKMeansSettings() - number of common dimension: {0}", new Object[]{theCandidates.size()});
        return new ArrayList<DataDimension>(theCandidates);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SettingsState {
        ADDING_CENTERS,
        ADDING_LINES;

    }
}

