/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.kmeansalgorithm;

import java.util.List;
import org.jdom.Element;
import org.openide.util.NbBundle;
import org.tpo.kmeansalgorithm.CommonDimensionsKMeansMeasure;
import org.tpo.kmeansalgorithm.ComputedCluster;
import org.tpo.kmeansalgorithm.KMeansAlgorithm;
import org.tpo.kmeansalgorithm.KMeansSettings;
import org.tpo.visminerapi.algorithm.Algorithm;
import org.tpo.visminerapi.algorithm.AlgorithmFactory;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerapi.datastorage.session.SessionObject;
import org.tpo.visminerapi.datastorage.session.XMLSessionBuilder;
import org.tpo.visminerapi.exceptions.SessionBuilderException;
import org.tpo.visminerbase.VisMinerApplication;

public class KMeansFactory
extends VisMinerObject
implements AlgorithmFactory {
    public String getAlgorithmName() {
        return NbBundle.getMessage(KMeansFactory.class, (String)"KMeansFactoryName");
    }

    public String getAlgorithmDescription() {
        return NbBundle.getMessage(KMeansFactory.class, (String)"KMeansFactoryDescription");
    }

    public Algorithm createAlgorithm() {
        DataSet theCurretnDataSet = VisMinerApplication.getInstance().getSelectedDataSet();
        KMeansSettings theKMeansSettings = new KMeansSettings();
        theKMeansSettings.setKMeansMeasure(new CommonDimensionsKMeansMeasure(theKMeansSettings, VisMinerApplication.getInstance().getPhysicalDataSet()));
        theKMeansSettings.setDataSet(theCurretnDataSet);
        KMeansAlgorithm theKMeansAlgorithm = new KMeansAlgorithm(theKMeansSettings);
        theKMeansAlgorithm.setParent((SessionObject)theCurretnDataSet);
        theKMeansAlgorithm.setName(theKMeansAlgorithm.getAlgorithmName());
        theCurretnDataSet.addChild((SessionObject)theKMeansAlgorithm);
        return theKMeansAlgorithm;
    }

    public Algorithm createAlgorithmFromElement(SessionObject aParent, Element anElement, XMLSessionBuilder aSessionBuilder) throws SessionBuilderException {
        this.logInfo("createAlgorithmFromElement()");
        if (aParent instanceof DataSet) {
            DataSet aParentDataSet = (DataSet)aParent;
            KMeansSettings theKMeansSettings = new KMeansSettings();
            theKMeansSettings.setKMeansMeasure(new CommonDimensionsKMeansMeasure(theKMeansSettings, VisMinerApplication.getInstance().getPhysicalDataSet()));
            theKMeansSettings.setDataSet(aParentDataSet);
            KMeansAlgorithm theKMeansAlgorithm = new KMeansAlgorithm(theKMeansSettings);
            theKMeansAlgorithm.setParent((SessionObject)aParentDataSet);
            aParentDataSet.addChild((SessionObject)theKMeansAlgorithm);
            theKMeansAlgorithm.loadAttributesFromElement(anElement);
            this.logInfo("loadingKMeansCenters from element");
            theKMeansAlgorithm.initClusterCentersFromElements(anElement.getChildren("ClusterCenter"));
            theKMeansAlgorithm.initSeparatingAxisesFromElements(anElement.getChildren("SeparatingAxis"));
            if (Algorithm.AlgorithmState.FINISHED.equals((Object)theKMeansAlgorithm.getAlgorithmState())) {
                this.logInfo("Computing clusters for loaded algorithm");
                theKMeansAlgorithm.computeAlgorithm(false);
                List clusterCenterElements = anElement.getChildren("ClusterCenter");
                for (Element eachCenterElement : clusterCenterElements) {
                    String theClusterName = eachCenterElement.getAttributeValue("ClusterName");
                    Element theComputedClusterElement = eachCenterElement.getChild("ComputedCluster");
                    if (theComputedClusterElement == null) {
                        throw new SessionBuilderException("Element for computed cluster not found.");
                    }
                    ComputedCluster theComputedCluster = theKMeansAlgorithm.getComputedClusterForClusterName(theClusterName);
                    if (theComputedCluster != null) {
                        this.logInfo("Ataching child session objects for computed cluster");
                        aSessionBuilder.attachFilerObjectsFromElements((SessionObject)theComputedCluster, theComputedClusterElement.getChildren());
                        continue;
                    }
                    throw new SessionBuilderException("No computed cluster for cluster name: " + theClusterName);
                }
            }
            VisMinerApplication.getInstance().addAlgorithm((Algorithm)theKMeansAlgorithm);
            return theKMeansAlgorithm;
        }
        throw new SessionBuilderException("Parent session object for KMeansAlgorithm is not DataSet type.");
    }

    public boolean canCreateAlgortihmFromElement(Element anElement) {
        return "KMeansAlgorithm".equals(anElement.getName());
    }
}

