/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.kmeansalgorithm;

import java.awt.geom.Line2D;
import org.tpo.kmeansalgorithm.KMeansSettings;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.datastorage.data.DataDimension;

public class SeparatingAxis
extends VisMinerObject {
    Line2D.Double normalizedLine;
    DataDimension xDataDimension;
    DataDimension yDataDimension;
    KMeansSettings kMeansSettings;

    public SeparatingAxis(KMeansSettings aSettings, DataDimension aXDataDimension, DataDimension aYDataDimension, Line2D.Double aNormalizeLine) {
        this.kMeansSettings = aSettings;
        this.xDataDimension = aXDataDimension;
        this.yDataDimension = aYDataDimension;
        this.normalizedLine = aNormalizeLine;
    }

    public Line2D.Double getNormalizedLine() {
        return this.normalizedLine;
    }

    public DataDimension getXDataDimension() {
        return this.xDataDimension;
    }

    public DataDimension getYDataDimension() {
        return this.yDataDimension;
    }

    public double computeOrientedDistanceToPoint(double aXCoord, double anYCoord) {
        double theAX = this.normalizedLine.x1;
        double theAY = this.normalizedLine.y1;
        double theBX = this.normalizedLine.x2;
        double theBY = this.normalizedLine.y2;
        double theResult = (theBX - theAX) * (anYCoord - theAY) - (theBY - theAY) * (aXCoord - theAX);
        return theResult;
    }

    public boolean arePointsOnTheSameSide(double aX1Coord, double anY1Coord, double aX2Coord, double anY2Coord) {
        double dist1 = this.computeOrientedDistanceToPoint(aX1Coord, anY1Coord);
        double dist2 = this.computeOrientedDistanceToPoint(aX2Coord, anY2Coord);
        if (dist1 == 0.0) {
            dist1 = -1.0;
        }
        if (dist2 == 0.0) {
            dist2 = -1.0;
        }
        return Math.signum(dist1) == Math.signum(dist2);
    }

    public KMeansSettings getKMeansSettings() {
        return this.kMeansSettings;
    }
}

