/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.inmemorydatastorage.data;

import java.util.LinkedList;
import java.util.List;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataValue;
import org.tpo.visminerapi.exceptions.VisMinerRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryDoubleDimension
extends VisMinerObject
implements DataDimension<Double> {
    private List<DataValue<Double>> values = new LinkedList<DataValue<Double>>();
    private String dimensionName;
    private String dimensionDescription;
    private Double minimalValue = Double.MAX_VALUE;
    private Double maximalValue = Double.MIN_VALUE;
    private Double valueRange = 0.0;
    private Double[] normalizedValues;

    public Class getDimensionType() {
        return Double.class;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public void setDimensionName(String aName) {
        this.dimensionName = aName;
    }

    public String getDimensionDescription() {
        return this.dimensionDescription;
    }

    public void setDimensionDescription(String aDescription) {
        this.dimensionDescription = aDescription;
    }

    public List<DataValue<Double>> getValues() {
        return this.values;
    }

    public void insertValue(DataValue<Double> aValue) {
        this.updateMinMax((Double)aValue.getValue());
        this.values.add(aValue);
    }

    private void updateMinMax(Double aValue) {
        if (aValue != null) {
            if (aValue < this.minimalValue) {
                this.minimalValue = aValue;
            }
            if (aValue > this.maximalValue) {
                this.maximalValue = aValue;
            }
            this.valueRange = Math.abs(this.maximalValue - this.minimalValue);
        }
    }

    public DataValue<Double> getValue(int index) {
        if (index < this.values.size()) {
            return this.values.get(index);
        }
        this.logError("Value index out of bounds!");
        throw new VisMinerRuntimeException("Value index out of bounds.");
    }

    public DataDimension<Double> createPointerDataDimension() {
        InMemoryDoubleDimension result = new InMemoryDoubleDimension();
        result.setDimensionName(this.getDimensionName());
        result.setDimensionDescription(this.getDimensionDescription());
        for (DataValue<Double> eachValue : this.values) {
            DataValue pointerValue = eachValue.createPointerValue();
            result.insertValue((DataValue<Double>)pointerValue);
        }
        return result;
    }

    public String toString() {
        return this.getDimensionName();
    }

    public Double getNormalizedValue(int anIndex) {
        return this.normalizedValues[anIndex];
    }

    public void computeStatisticalInformations() {
        this.logInfo("Computing statistical informations for data dimension: {0}", new Object[]{this.getDimensionName()});
        this.computeNormalizedValues();
    }

    private void computeNormalizedValues() {
        this.logInfo("Computing normalized values for data dimension: {0}", new Object[]{this.getDimensionName()});
        this.normalizedValues = new Double[this.getValues().size()];
        for (int anIndex = 0; anIndex < this.getValues().size(); ++anIndex) {
            Double aValue = (Double)this.getValue(anIndex).getValue();
            if (aValue == null || this.valueRange == null) continue;
            this.normalizedValues[anIndex] = new Double(aValue / this.valueRange);
        }
    }

    public Double getMinimalValue() {
        return this.minimalValue;
    }

    public Double getMaximalValue() {
        return this.maximalValue;
    }
}

