/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.inmemorydatastorage.data;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.jdom.Element;
import org.tpo.inmemorydatastorage.data.AbstractInMemoryDataSet;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerapi.datastorage.data.DataValue;
import org.tpo.visminerapi.datastorage.data.Filter;
import org.tpo.visminerapi.datastorage.session.FilterSessionObject;
import org.tpo.visminerapi.datastorage.session.SessionObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryLogicalDataSet
extends AbstractInMemoryDataSet {
    private String dataSetDescription;
    private FilterSessionObject parentFilterObject;
    private Filter parentFilter;
    private DataSet parentDataSet;
    private Boolean[] dataSetCache;
    private Integer logicalRecordCount;
    private List<DataDimension<?>> dataDimensions = new ArrayList();

    public InMemoryLogicalDataSet(FilterSessionObject aFilterSessionObject, DataSet aParentDataSet) {
        this.parentFilterObject = aFilterSessionObject;
        this.parentFilter = aFilterSessionObject.getFilter();
        this.parentDataSet = aParentDataSet;
        this.initFromDataSetAndFilterObject(aFilterSessionObject, aParentDataSet);
    }

    private void initFromDataSetAndFilterObject(FilterSessionObject aFilterSessionObject, DataSet aDataSet) {
        this.clearCache();
        aFilterSessionObject.addChild((SessionObject)this);
        this.setParent((SessionObject)aFilterSessionObject);
    }

    public String getDataSetDescription() {
        return this.dataSetDescription;
    }

    public void setDataSetDescription(String aDescription) {
        this.dataSetDescription = aDescription;
    }

    public int getPhysicalRecordsCount() {
        return this.parentDataSet.getPhysicalRecordsCount();
    }

    public int getDimensionsCount() {
        return this.parentDataSet.getDimensionsCount();
    }

    public List<DataValue> getDataValuesForDiemnsion(DataDimension aDimension) {
        return this.parentDataSet.getDataValuesForDiemnsion(aDimension);
    }

    public List<DataDimension<?>> getDimensions() {
        return this.parentDataSet.getDimensions();
    }

    public List<DataDimension<Double>> getDoubleDimensions() {
        return this.parentDataSet.getDoubleDimensions();
    }

    public boolean isDataValueInDataSet(DataValue aDataValue) {
        if (this.dataSetCache[aDataValue.getPhysicalDataIndex()] == null) {
            this.dataSetCache[aDataValue.getPhysicalDataIndex()] = this.isRecordWithIndexInDataSet(aDataValue) ? new Boolean(true) : new Boolean(false);
        }
        return this.dataSetCache[aDataValue.getPhysicalDataIndex()];
    }

    private boolean isRecordWithIndexInDataSet(DataValue aDataValue) {
        return this.parentDataSet.isDataValueInDataSet(aDataValue) && this.parentFilter.isDataValueInFilter(aDataValue);
    }

    public boolean isDataValueInDataSet(int anIndex) {
        return this.parentDataSet.isDataValueInDataSet(anIndex) && this.parentFilter.isDataValueInFilter(anIndex);
    }

    private void clearCache() {
        this.dataSetCache = new Boolean[this.getPhysicalRecordsCount()];
        this.logicalRecordCount = null;
    }

    public int getLogicalRecordsCount() {
        if (this.logicalRecordCount != null) {
            return this.logicalRecordCount;
        }
        if (this.getDimensions().size() == 0) {
            this.logicalRecordCount = new Integer(0);
            return 0;
        }
        int theCount = 0;
        for (DataValue eachDataValue : this.getDimensions().get(0).getValues()) {
            if (!this.isDataValueInDataSet(eachDataValue)) continue;
            ++theCount;
        }
        this.logicalRecordCount = new Integer(theCount);
        return theCount;
    }

    public Element getSessionObjectXMLElement() {
        Element theElement = super.getSessionObjectXMLElement();
        theElement.setName("LogicalDataSet");
        this.saveNameToElement(theElement);
        this.saveDescriptionToElement(theElement);
        return theElement;
    }

    public DataDimension getDimensionForName(String aDimensionName) {
        return this.parentDataSet.getDimensionForName(aDimensionName);
    }

    public SessionObject.SessionObjectType getSessionObjecType() {
        return SessionObject.SessionObjectType.DATASET;
    }

    public List<Action> getAdditionalAction() {
        return new ArrayList<Action>();
    }
}

