/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.inmemorydatastorage.data;

import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.jdom.Element;
import org.netbeans.api.visual.vmd.VMDGraphScene;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.tpo.inmemorydatastorage.data.AbstractInMemoryDataSet;
import org.tpo.inmemorydatastorage.data.InMemoryDataValue;
import org.tpo.inmemorydatastorage.data.InMemoryDoubleDimension;
import org.tpo.inmemorydatastorage.data.InMemoryStringDimension;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.dataimporter.ImportResult;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataValue;
import org.tpo.visminerapi.datastorage.session.SessionObject;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.datastorage.session.SessionGraphScene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryPhysicalDataSet
extends AbstractInMemoryDataSet {
    private List<DataDimension<?>> dataDimensions;

    public InMemoryPhysicalDataSet(ImportResult aImportResult) {
        this.logInfo("Creating InMemoryPhysicalDataSet with name: " + aImportResult.getImportSourceDescription());
        this.setName(aImportResult.getImportSourceDescription());
        this.createDimensionsFromImportResult(aImportResult);
        VisMinerApplication.getInstance().getSessionGraphScene();
        this.setVdmPin(SessionGraphScene.createPin((VMDGraphScene)VisMinerApplication.getInstance().getSessionGraphScene(), (String)VisMinerApplication.getInstance().getProjectNodeId(), (String)this.getSessionObjectId(), null, (String)"", (String)""));
        this.updatePinAndNodeProperties();
    }

    private void createDimensionsFromImportResult(ImportResult aImportResult) {
        this.dataDimensions = new ArrayList();
        int theDimCount = aImportResult.importedDimensionsCount();
        for (int index = 0; index < theDimCount; ++index) {
            VisMinerObject theDimension;
            if (Double.class.equals((Object)aImportResult.importedDimensionClass(index))) {
                theDimension = new InMemoryDoubleDimension();
                this.dataDimensions.add((DataDimension<?>)theDimension);
                if (aImportResult.hasImportedDimensionNames()) {
                    theDimension.setDimensionName(aImportResult.importedDimensionName(index));
                } else {
                    theDimension.setDimensionName(NbBundle.getMessage(InMemoryPhysicalDataSet.class, (String)"DEFAULT_DIMENSION_NAME", (Object[])new Object[]{new Integer(index)}));
                }
                this.logInfo("createDimensionsFromImportResult() - Created Double data dimension with name: " + theDimension.getDimensionName());
                this.logInfo("createDimensionsFromImportResult() - Filling dimension with data.");
                this.fillDoubleDimensionWithDataFromImport((InMemoryDoubleDimension)theDimension, aImportResult);
                this.logInfo("createDimensionsFromImportResult() - Dimension filled.");
                continue;
            }
            theDimension = new InMemoryStringDimension();
            this.dataDimensions.add((DataDimension<?>)theDimension);
            if (aImportResult.hasImportedDimensionNames()) {
                theDimension.setDimensionName(aImportResult.importedDimensionName(index));
            } else {
                theDimension.setDimensionName(NbBundle.getMessage(InMemoryPhysicalDataSet.class, (String)"DEFAULT_DIMENSION_NAME", (Object[])new Object[]{new Integer(index)}));
            }
            this.logInfo("createDimensionsFromImportResult() - Created String data dimension with name: " + theDimension.getDimensionName());
            this.logInfo("createDimensionsFromImportResult() - Filling dimension with data.");
            this.fillStringDimensionWithDataFromImport((InMemoryStringDimension)theDimension, aImportResult);
            this.logInfo("createDimensionsFromImportResult() - Dimension filled.");
        }
        for (DataDimension<?> eachDimension : this.dataDimensions) {
            eachDimension.computeStatisticalInformations();
        }
    }

    private void fillDoubleDimensionWithDataFromImport(InMemoryDoubleDimension aDimension, ImportResult aImportResult) {
        int recordsCount = aImportResult.importedRecordsCount();
        int dimensionsCount = aImportResult.importedDimensionsCount();
        for (int recIndex = 0; recIndex < recordsCount; ++recIndex) {
            Double value = (Double)aImportResult.getImportedRecordValue(Double.class, this.getDimensionIndex(aDimension), recIndex);
            aDimension.insertValue(new InMemoryDataValue<Double>(value, recIndex));
        }
    }

    private void fillStringDimensionWithDataFromImport(InMemoryStringDimension aDimension, ImportResult aImportResult) {
        int recordsCount = aImportResult.importedRecordsCount();
        int dimensionsCount = aImportResult.importedDimensionsCount();
        for (int recIndex = 0; recIndex < recordsCount; ++recIndex) {
            String value = (String)aImportResult.getImportedRecordValue(String.class, this.getDimensionIndex(aDimension), recIndex);
            aDimension.insertValue(new InMemoryDataValue<String>(value, recIndex));
        }
    }

    public int getPhysicalRecordsCount() {
        if (this.getDimensionsCount() > 0) {
            return this.getDimensions().get(0).getValues().size();
        }
        return 0;
    }

    public int getDimensionsCount() {
        return this.getDimensions().size();
    }

    public List<DataDimension<?>> getDimensions() {
        return this.dataDimensions;
    }

    public List<DataValue> getDataValuesForDiemnsion(DataDimension aDimension) {
        return aDimension.getValues();
    }

    public int getDimensionIndex(DataDimension<?> aDataDimension) {
        return this.dataDimensions.indexOf(aDataDimension);
    }

    public List<DataDimension<Double>> getDoubleDimensions() {
        ArrayList<DataDimension<Double>> theResultList = new ArrayList<DataDimension<Double>>();
        for (DataDimension<?> eachDimension : this.getDimensions()) {
            if (!Double.class.equals((Object)eachDimension.getDimensionType())) continue;
            theResultList.add(eachDimension);
        }
        return theResultList;
    }

    public boolean isDataValueInDataSet(DataValue aDataValue) {
        return true;
    }

    public boolean isDataValueInDataSet(int anIndex) {
        return true;
    }

    public int getLogicalRecordsCount() {
        return this.getPhysicalRecordsCount();
    }

    public Element getSessionObjectXMLElement() {
        Element theElement = super.getSessionObjectXMLElement();
        theElement.setName("PhysicalDataSet");
        theElement.setAttribute("DataSetFile", VisMinerApplication.getInstance().getPhysicalDataSetFileName());
        return theElement;
    }

    public DataDimension getDimensionForName(String aDimensionName) {
        for (DataDimension<?> eachDimension : this.getDimensions()) {
            if (!eachDimension.getDimensionName().equals(aDimensionName)) continue;
            return eachDimension;
        }
        return null;
    }

    public SessionObject.SessionObjectType getSessionObjecType() {
        return SessionObject.SessionObjectType.DATASET;
    }

    public List<Action> getAdditionalAction() {
        return new ArrayList<Action>();
    }

    public List<Node.Property> getEditableProperties() {
        List theResult = super.getEditableProperties();
        PropertySupport.ReadOnly<String> theDataSetInfoProperty = new PropertySupport.ReadOnly<String>("DataSetInfo", String.class, NbBundle.getMessage(InMemoryPhysicalDataSet.class, (String)"PROPERTY_DataSetInfo"), NbBundle.getMessage(InMemoryPhysicalDataSet.class, (String)"PROPERTY_DataSetInfoDesc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return InMemoryPhysicalDataSet.this.getDataSetInfoString();
            }
        };
        theResult.add(theDataSetInfoProperty);
        return theResult;
    }

    public String getDataSetInfoString() {
        StringBuffer theResultBuff = new StringBuffer();
        DecimalFormat formatter = new DecimalFormat("0.0000");
        theResultBuff.append(NbBundle.getMessage(InMemoryPhysicalDataSet.class, (String)"DataRecordCount"));
        theResultBuff.append(": ");
        theResultBuff.append(this.getPhysicalRecordsCount());
        theResultBuff.append("\n");
        theResultBuff.append("------------------------------------------\n");
        theResultBuff.append(NbBundle.getMessage(InMemoryPhysicalDataSet.class, (String)"DimensionListDesc"));
        theResultBuff.append("------------------------------------------\n");
        for (DataDimension eachDimension : VisMinerApplication.getInstance().getPhysicalDataSet().getDoubleDimensions()) {
            theResultBuff.append(eachDimension.getDimensionName());
            theResultBuff.append(": ");
            theResultBuff.append(formatter.format(eachDimension.getMinimalValue()));
            theResultBuff.append(" - ");
            theResultBuff.append(formatter.format(eachDimension.getMaximalValue()));
            theResultBuff.append("\n");
        }
        return theResultBuff.toString();
    }
}

