/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.csvfiledataimporter;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openide.util.NbBundle;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.dataimporter.FileDataImporter;
import org.tpo.visminerapi.dataimporter.ImportResult;
import org.tpo.visminerapi.dataimporter.settings.AbstractImportSettings;
import org.tpo.visminerapi.dataimporter.settings.FileImportSettings;
import org.tpo.visminerapi.exceptions.VisMinerRuntimeException;
import org.tpo.visminerapi.exceptions.dataimporter.DataImportException;
import org.tpo.visminerapi.exceptions.dataimporter.ImportTerminatedByUserException;
import org.tpo.visminerapi.exceptions.dataimporter.IncompatibleImportSettingsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVFileDataImporter
extends VisMinerObject
implements FileDataImporter,
ImportResult {
    public static final int PREVIEW_MAX_ROW_COUNT = 8;
    private char valueSeparator = (char)44;
    private char textSeparator = (char)34;
    private boolean hasDimensionNames = true;
    private String[] dimensionNames;
    private List<String[]> readedData;
    private int recordsCount;
    private int dimensionCount;
    private FileImportSettings importSettings;

    public TableModel createPreviewTableModel(boolean aHeaderDescriptionFlag) throws FileNotFoundException, IOException {
        Object[] theHeaders = new String[]{};
        Object[][] theValues = new String[0][0];
        ArrayList<String[]> readedLines = new ArrayList<String[]>();
        int rowIndex = 0;
        CSVReader theCSVReader = new CSVReader((Reader)new FileReader(this.getImportSettings().getFileToImport()), this.valueSeparator, this.textSeparator);
        String[] nextLine = theCSVReader.readNext();
        if (nextLine == null) {
            return new DefaultTableModel(theValues, theHeaders);
        }
        if (aHeaderDescriptionFlag) {
            theHeaders = nextLine;
        } else {
            readedLines.add(nextLine);
            ++rowIndex;
        }
        while ((nextLine = theCSVReader.readNext()) != null && rowIndex < 8) {
            readedLines.add(nextLine);
            ++rowIndex;
        }
        theValues = new String[readedLines.size()][];
        rowIndex = 0;
        for (String[] eachLine : readedLines) {
            theValues[rowIndex] = eachLine;
            ++rowIndex;
        }
        return new DefaultTableModel(theValues, theHeaders);
    }

    private String removeTextSeparators(String aValue) {
        return aValue;
    }

    public String getImporterDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getImporterName() {
        return NbBundle.getMessage(CSVFileDataImporter.class, (String)"ImporterName");
    }

    public Boolean isApplicableToFile(File aFile) {
        if (aFile == null) {
            return false;
        }
        if (aFile.getName().toLowerCase().contains(".csv")) {
            return true;
        }
        return false;
    }

    public ImportResult importData() throws DataImportException {
        try {
            if (this.importSettings == null) {
                throw new DataImportException("No import settings are set.", null);
            }
            if (this.displayCSVFileImportSettingsDialog()) {
                this.logInfo("Creating CSV reader for data file.");
                CSVReader theCSVReader = new CSVReader((Reader)new FileReader(this.getImportSettings().getFileToImport()));
                this.logInfo("Loading data from CSV file.");
                List theReadedData = theCSVReader.readAll();
                this.logInfo("Number of readed rows: " + theReadedData.size());
                this.proccessReadedData(theReadedData);
                return this;
            }
            throw new ImportTerminatedByUserException("Data import was terminated by user.", null);
        }
        catch (FileNotFoundException ex) {
            throw new DataImportException("File not found.", (Exception)ex);
        }
        catch (IOException ex) {
            throw new DataImportException("IO exception", (Exception)ex);
        }
    }

    private void proccessReadedData(List<String[]> aReadedData) {
        if (aReadedData.size() == 0) {
            this.recordsCount = 0;
            this.dimensionCount = 0;
            return;
        }
        String[] theFirstRow = aReadedData.get(0);
        this.dimensionCount = theFirstRow.length;
        if (this.hasDimensionNames) {
            this.logInfo("proccessReadedData() - Imported data contains dimension names. Extracting name and removing first row of imported data.");
            this.dimensionNames = theFirstRow;
            aReadedData.remove(0);
        }
        this.readedData = aReadedData;
        this.recordsCount = this.readedData.size();
    }

    private boolean displayCSVFileImportSettingsDialog() {
        return true;
    }

    public FileImportSettings getImportSettings() {
        return this.importSettings;
    }

    public void setImportSettings(AbstractImportSettings aSettings) throws IncompatibleImportSettingsException {
        if (aSettings == null) {
            throw new IncompatibleImportSettingsException("Settings object is null.", null);
        }
        if (!(aSettings instanceof FileImportSettings)) {
            throw new IncompatibleImportSettingsException("Settings object is not instance of FileImpoerSettings.", null);
        }
        this.importSettings = (FileImportSettings)aSettings;
    }

    public int importedRecordsCount() {
        return this.recordsCount;
    }

    public int importedDimensionsCount() {
        return this.dimensionCount;
    }

    public Class importedDimensionClass(int aDimIndex) {
        if (this.readedData.size() == 0) {
            this.logError("importedDimensionClass() - Cannot obtain data dimension type. No data readed.");
            throw new VisMinerRuntimeException("Cannot obtain data dimension type. No data readed.");
        }
        String[] sampleRecord = this.readedData.get(0);
        if (aDimIndex > sampleRecord.length - 1) {
            this.logError("importedDimensionClass() - Dimension index out of bounds!");
            throw new VisMinerRuntimeException("Dimension index out of bounds.");
        }
        String sampleValue = sampleRecord[aDimIndex];
        this.logInfo("Guessing data type for dimension with index: " + aDimIndex + " sample value: " + sampleValue);
        try {
            Double.parseDouble(sampleValue);
            this.logInfo("Guessed Double.class type.");
            return Double.class;
        }
        catch (Exception ex) {
            this.logInfo("Guessed String.class type.");
            return String.class;
        }
    }

    public boolean hasImportedDimensionNames() {
        return this.hasDimensionNames;
    }

    public String importedDimensionName(int aDimIndex) {
        if (this.dimensionNames != null && aDimIndex < this.dimensionNames.length) {
            return this.dimensionNames[aDimIndex];
        }
        return null;
    }

    public String getImportSourceDescription() {
        return this.getImportSettings().getFileToImport().getName();
    }

    public <T> T getImportedRecordValue(Class<T> aClass, int aDimIndex, int aRecIndex) {
        if (aRecIndex >= this.readedData.size()) {
            this.logError("getImportedRecordValue() - Record index out of bounds!");
            throw new VisMinerRuntimeException("Record index out of bounds.");
        }
        String[] record = this.readedData.get(aRecIndex);
        if (aDimIndex >= record.length) {
            this.logError("importedDimensionClass() - Dimension index out of bounds!");
            throw new VisMinerRuntimeException("Dimension index out of bounds.");
        }
        String theValue = record[aDimIndex];
        Object result = null;
        if (theValue == null || theValue.trim().length() == 0) {
            return null;
        }
        if (Double.class.equals(aClass)) {
            result = new Double(theValue);
        }
        if (String.class.equals(aClass)) {
            result = theValue;
        }
        return (T)result;
    }

    public File getDataFile() {
        return this.getImportSettings().getFileToImport();
    }
}

