/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase;

import java.util.Collection;
import java.util.Date;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.visminerapi.visualization.Visualization;
import org.tpo.visminerbase.VisualizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepaintVisualizationThread
extends Thread {
    private Collection<Visualization> visualizations;
    private boolean running = false;
    private VisualizationManager visualizationManager;

    public RepaintVisualizationThread(Collection<Visualization> aVisualizations, VisualizationManager aVisualizationManager) {
        this.visualizations = aVisualizations;
        this.visualizationManager = aVisualizationManager;
    }

    @Override
    public void run() {
        Date theStartDate = new Date();
        ApplicationLogger.logInfo(RepaintVisualizationThread.class, (String)"Running...");
        try {
            this.setRunning(true);
            for (Visualization eachVisualization : this.visualizations) {
                eachVisualization.repaint();
            }
            this.setRunning(false);
        }
        catch (Exception ex) {
            ApplicationLogger.logWarning(RepaintVisualizationThread.class, (String)("Exception in thread run: " + ex));
            this.setRunning(false);
        }
        ApplicationLogger.logInfo(RepaintVisualizationThread.class, (String)"Finished! Total time: {0} (msec)", (Object[])new Object[]{new Date().getTime() - theStartDate.getTime()});
        this.visualizationManager.repaintThreadFinishedCallback();
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void setRunning(boolean running) {
        this.running = running;
    }
}

