/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.visminerapi.algorithm.Algorithm;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.dataimporter.FileDataImporter;
import org.tpo.visminerapi.dataimporter.ImportResult;
import org.tpo.visminerapi.dataimporter.settings.AbstractImportSettings;
import org.tpo.visminerapi.dataimporter.settings.FileImportSettings;
import org.tpo.visminerapi.datastorage.DataStorage;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerapi.datastorage.data.Filter;
import org.tpo.visminerapi.datastorage.session.FilterSessionObject;
import org.tpo.visminerapi.datastorage.session.SessionObject;
import org.tpo.visminerapi.exceptions.ProjectException;
import org.tpo.visminerapi.exceptions.SessionBuilderException;
import org.tpo.visminerapi.exceptions.VisMinerRuntimeException;
import org.tpo.visminerapi.exceptions.dataimporter.DataImportException;
import org.tpo.visminerapi.exceptions.dataimporter.ImportTerminatedByUserException;
import org.tpo.visminerapi.exceptions.dataimporter.IncompatibleImportSettingsException;
import org.tpo.visminerapi.exceptions.datastorage.AbstractDataStorageException;
import org.tpo.visminerapi.selection.DataSelection;
import org.tpo.visminerapi.visualization.Visualization;
import org.tpo.visminerbase.VisMinerObjectFactory;
import org.tpo.visminerbase.VisualizationManager;
import org.tpo.visminerbase.XMLSessionBuilderImpl;
import org.tpo.visminerbase.datastorage.session.SessionGraphScene;
import org.tpo.visminerbase.ui.VisMinerUI;
import org.tpo.visminerbase.ui.algorithmlist.AlgorithmListTopComponent;
import org.tpo.visminerbase.ui.objectexplorer.ObjectExplorerTopComponent;
import org.tpo.visminerbase.ui.visualizationlist.VisualizationListTopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisMinerApplication
extends VisMinerObject
implements LookupListener {
    public static final String PROPERTY_INITALIZED = "InitializedProperty";
    public static final String PROPERTY_PROJECT_DIRECTORY = "ProjectDirectoryProperty";
    public static final String PROPERTY_PROJECT_NAME = "projectName";
    public static final String PROPERTY_PROJECT_DESC = "projectDescription";
    public static final String PROPERTY_PHYSICAL_DATA = "physicalDataSet";
    public static final String PROPERTY_VISUALIZATION_LIST = "visualizationList";
    public static final String PROPERTY_ALGORITHM_LIST = "algorithmList";
    public static final String PROPERTY_CURRENT_SELECTION = "currentSelection";
    public static final String PROPERTY_CURRENT_SELECTION_OPERATOR = "currentSelectionOperator";
    public static final String PROPERTY_SELECTED_DATASET = "selectedDataSet";
    public static final String PROPERTY_SELECTED_FILTER = "selectedFilter";
    public static final String PROJECT_XML_ELEMENT_NAME = "VisMinerProject";
    public static final String PROJECT_NAME_ATTR_NAME = "ProjectName";
    public static final String PROJECT_DESC_ATTR_NAME = "ProjectDescription";
    public static final String PROJECT_FILE_NAME = "project.xml";
    private String projectName;
    private String projectDescription;
    private File projectDirectory;
    private DataStorage dataStorage;
    private DataSet physicalDataSet;
    private String physicalDataSetFileName;
    private List<Algorithm> algorithmList = new ArrayList<Algorithm>();
    private DataSelection currentDataSelection;
    private DataSelection.SelectionOperator currentSelectionOperator = DataSelection.SelectionOperator.ADD_RECORDS;
    private PropertyChangeSupport propertyChangeSupport;
    private VisualizationManager visualizationManager = VisualizationManager.getInstance();
    private boolean initialized = false;
    private final Lookup.Result<DataSet> dataSetLookupResult;
    private final Lookup.Result<Filter> filterLookupResult;
    private DataSet selectedDataSet;
    private Filter selectedFilter;
    private String projectNodeId;
    private VMDNodeWidget vmdProjectNode;
    private static VisMinerApplication visMinerApplication;
    private SessionGraphScene sessionGraphScene = new SessionGraphScene();
    private Map<String, String> dataStorageSettings;

    private VisMinerApplication() {
        this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        this.dataStorage = this.getDataStorage();
        if (this.dataStorage == null) {
            this.logError("VisMinerApplication() - No data storage found.");
            VisMinerUI.showNoDataStorageFoundMessage();
        }
        this.dataSetLookupResult = Utilities.actionsGlobalContext().lookup(new Lookup.Template(DataSet.class));
        this.dataSetLookupResult.addLookupListener((LookupListener)this);
        this.filterLookupResult = Utilities.actionsGlobalContext().lookup(new Lookup.Template(Filter.class));
        this.filterLookupResult.addLookupListener((LookupListener)this);
        VisMinerApplication visMinerApplication = this;
        this.projectNodeId = visMinerApplication.sessionGraphScene.getNextNodeId();
        this.vmdProjectNode = SessionGraphScene.createNode(this.sessionGraphScene, 0, 0, null, this.projectNodeId, "No project", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener aPropertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(aPropertyChangeListener);
    }

    public void closeProject() {
        this.logInfo("Closing project.");
        this.visualizationManager.closeAllVisualizations();
        this.visualizationManager.deleteAllVisualization();
        this.algorithmList.clear();
        this.sessionGraphScene = new SessionGraphScene();
        VisMinerApplication visMinerApplication = this;
        this.projectNodeId = visMinerApplication.sessionGraphScene.getNextNodeId();
        this.vmdProjectNode = SessionGraphScene.createNode(this.sessionGraphScene, 0, 0, null, this.projectNodeId, "No project", null, null);
        this.setInitialized(false);
        this.setPhysicalDataSet(null);
        this.setProjectDirectory(null);
        this.setProjectName(null);
        this.setCurrentDataSelection(null);
        this.setSelectedDataSet(null);
        this.setSelectedFilter(null);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_VISUALIZATION_LIST, null, this.getVisualaziationList());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_ALGORITHM_LIST, null, this.getAlgorithmList());
    }

    public void rebuildSessionWithImportResult(ImportResult theResult) {
        try {
            ApplicationLogger.logInfo(VisMinerApplication.class, (String)"Rebuilding session from project file");
            File theProjectDirecotry = this.getProjectDirectory();
            this.closeProject();
            this.initWithDirectory(theProjectDirecotry, false);
            XMLSessionBuilderImpl theSessionBuilder = new XMLSessionBuilderImpl();
            theSessionBuilder.rebuildSessionFromProjectFileUsingDataSetFile(theResult.getDataFile());
        }
        catch (ProjectException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            ApplicationLogger.logWarning(VisMinerApplication.class, (String)"Error in rebuilding session with import result.");
            VisMinerUI.showBuildingSessionErrorMessage();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener aPropertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(aPropertyChangeListener);
    }

    public void rebuildPhysicalDataFromElement(Element anElement, File aDataSetFile) throws SessionBuilderException {
        String theFileName;
        File theFileToImport = aDataSetFile;
        if (theFileToImport == null && (theFileName = anElement.getAttributeValue("DataSetFile")) != null) {
            theFileToImport = new File(this.getProjectDirectory(), theFileName);
        }
        if (theFileToImport == null) {
            throw new SessionBuilderException("No physical data file specified.");
        }
        if (!theFileToImport.exists()) {
            throw new SessionBuilderException("Physical data file was not found: " + theFileToImport);
        }
        ImportResult theImportResult = this.importDataFile(theFileToImport);
        if (theImportResult == null) {
            throw new SessionBuilderException("Error during physical data file import");
        }
        this.createPhysicalDataFromImportResult(theImportResult);
    }

    private DataStorage getDataStorage() {
        Collection<? extends DataStorage> theStorages = VisMinerObjectFactory.getAllDataStorages();
        if (theStorages.size() > 0) {
            return theStorages.iterator().next();
        }
        return null;
    }

    public static VisMinerApplication getInstance() {
        if (visMinerApplication == null) {
            visMinerApplication = new VisMinerApplication();
        }
        return visMinerApplication;
    }

    public ImportResult importDataFile(File aFile) {
        if (aFile != null) {
            try {
                File theDataFile = new File(this.getProjectDirectory() + File.separator + aFile.getName());
                if (!aFile.equals(theDataFile)) {
                    if (theDataFile.exists()) {
                        this.logWarning("Imported file already exists in project direcoty. Deleting it: {0}", new Object[]{theDataFile});
                        theDataFile.delete();
                    }
                    VisMinerApplication.copyFileToDir(aFile, theDataFile);
                }
                this.logInfo("File choosed for data import: " + theDataFile);
                if (theDataFile == null || !theDataFile.exists()) {
                    return null;
                }
                Collection<? extends FileDataImporter> importers = VisMinerObjectFactory.getAllFileDataImporters();
                this.logInfo("Found " + importers.size() + " file importers in lookup. Trying to find importer applicable to file.");
                for (FileDataImporter fileDataImporter : importers) {
                    if (fileDataImporter.isApplicableToFile(theDataFile).booleanValue()) {
                        this.logInfo("---> " + fileDataImporter.getClass().getName() + " is compatible, using this importer.");
                        return this.importFileUsingImporter(theDataFile, fileDataImporter);
                    }
                    this.logInfo("---> " + fileDataImporter.getClass().getName() + " is not compatible, looking for another one.");
                }
                VisMinerUI.showNoFileImporterFoundMessage();
                return null;
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.logError(ex.toString());
                VisMinerUI.showErrorMessageDialog(NbBundle.getMessage(VisMinerApplication.class, (String)"DataFileImportErrorTitle"), NbBundle.getMessage(VisMinerApplication.class, (String)"DataFileImportErrorText"));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.logError(ex.toString());
                VisMinerUI.showErrorMessageDialog(NbBundle.getMessage(VisMinerApplication.class, (String)"DataFileImportErrorTitle"), NbBundle.getMessage(VisMinerApplication.class, (String)"DataFileImportErrorText"));
            }
        }
        return null;
    }

    private ImportResult importFileUsingImporter(File aFile, FileDataImporter anImporter) {
        FileImportSettings theImportSettings = new FileImportSettings(aFile);
        try {
            anImporter.setImportSettings((AbstractImportSettings)theImportSettings);
            this.logInfo("Starting data file import.");
            ImportResult theResults = anImporter.importData();
            this.logInfo("Data file import was succesfull.");
            this.physicalDataSetFileName = aFile.getName();
            return theResults;
        }
        catch (ImportTerminatedByUserException anException) {
            this.logInfo("Data import was terminated by user.");
            return null;
        }
        catch (IncompatibleImportSettingsException anException) {
            this.logError("Incompatible import settings: " + (Object)((Object)anException));
            throw new VisMinerRuntimeException();
        }
        catch (DataImportException anException) {
            this.logWarning("Data import error: " + (Object)((Object)anException));
            VisMinerUI.showDataImportErrorMessage();
            return null;
        }
    }

    public void initWithDirectory(File aProjectDirectory, boolean aNewProjectFlag) throws ProjectException {
        if (aProjectDirectory == null || !aProjectDirectory.isDirectory() || !aProjectDirectory.exists()) {
            throw new ProjectException("Invalid project directory.");
        }
        if (aNewProjectFlag) {
            if (aProjectDirectory.listFiles().length > 0) {
                // empty if block
            }
        } else {
            File theProjectFile = new File(aProjectDirectory, PROJECT_FILE_NAME);
            if (!theProjectFile.exists()) {
                throw new ProjectException("Missing project file: " + theProjectFile.getPath());
            }
        }
        ApplicationLogger.logInfo(VisMinerApplication.class, (String)("Initializing project from directory directory: " + aProjectDirectory.getName()), null);
        this.setProjectName(aProjectDirectory.getName());
        this.setProjectDescription(aProjectDirectory.getPath());
        this.setProjectDirectory(aProjectDirectory);
    }

    public DataSet getPhysicalDataSet() {
        return this.physicalDataSet;
    }

    public Map<String, String> getDataStorageSettings() {
        return this.dataStorageSettings;
    }

    public void setDataStorageSettings(Map<String, String> dataStorageSettings) {
        this.dataStorageSettings = dataStorageSettings;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String aProjectDescription) {
        String theOldDesc = this.projectDescription;
        this.projectDescription = aProjectDescription;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_PROJECT_DESC, theOldDesc, this.projectDescription);
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setProjectDirectory(File aProjectDirectory) {
        File theOldDirectory = this.projectDirectory;
        this.projectDirectory = aProjectDirectory;
        this.checkInitialzied();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_PROJECT_DIRECTORY, theOldDirectory, aProjectDirectory);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String aProjectName) {
        String theOldName = this.projectName;
        this.projectName = aProjectName;
        this.vmdProjectNode.setNodeName(aProjectName);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_PROJECT_NAME, theOldName, this.projectName);
    }

    public void setPhysicalDataSet(DataSet aPhysicalDataSet) {
        DataSet theOldData = this.physicalDataSet;
        this.physicalDataSet = aPhysicalDataSet;
        this.checkInitialzied();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_PHYSICAL_DATA, theOldData, aPhysicalDataSet);
        this.setSelectedDataSet(aPhysicalDataSet);
    }

    public void createPhysicalDataFromImportResult(ImportResult aImportResult) {
        try {
            this.setPhysicalDataSet(this.dataStorage.createPhysicalDataFromImport(aImportResult));
        }
        catch (AbstractDataStorageException ex) {
            this.logError("Error in creating physical data." + (Object)((Object)ex));
            VisMinerUI.showCreatingPhysicalDataErrorMessage();
        }
    }

    public DataSet createLogicalDataSet(DataSet aParentDataSet, DataSelection aDataSelection) {
        this.logInfo("createLogicalDataSet() Creating logical DataSet.");
        aDataSelection.setParent((SessionObject)aParentDataSet);
        aParentDataSet.addChild((SessionObject)aDataSelection);
        return this.getDataStorage().createLogicalData(aParentDataSet, (FilterSessionObject)aDataSelection);
    }

    public void addVisualization(Visualization aVisualization) {
        this.logInfo("Adding visualization to project: " + aVisualization.getVisualizationName());
        this.visualizationManager.addVisualzation(aVisualization);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_VISUALIZATION_LIST, null, aVisualization);
        this.exapndAllVisualizationNodes();
    }

    public void removeVisualization(Visualization aVisualization) {
        this.logInfo("Removing visualization from project: " + aVisualization.getVisualizationName());
        if (this.visualizationManager.removeVisualization(aVisualization)) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_VISUALIZATION_LIST, null, aVisualization);
        }
    }

    public List<Visualization> getVisualaziationList() {
        return this.visualizationManager.getVisualizationList();
    }

    public void repaintAllVisualization() {
        this.logInfo("Repainting all visualizations.");
        this.visualizationManager.repaintAllVisualization();
    }

    public void setCurrentDataSelection(DataSelection aCurrentDataSelection) {
        this.logInfo("Setting current data selection: " + aCurrentDataSelection);
        DataSelection theOldSelection = this.currentDataSelection;
        this.currentDataSelection = aCurrentDataSelection;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_CURRENT_SELECTION, theOldSelection, this.currentDataSelection);
        this.repaintAllVisualization();
    }

    public DataSelection getCurrentDataSelection() {
        return this.currentDataSelection;
    }

    public DataSelection.SelectionOperator getCurrentSelectionOperator() {
        return this.currentSelectionOperator;
    }

    public void setCurrentSelectionOperator(DataSelection.SelectionOperator aCurrentSelectionOperator) {
        this.logInfo("Setting selection operator to value: {0}", new Object[]{aCurrentSelectionOperator});
        DataSelection.SelectionOperator theOldOperator = this.getCurrentSelectionOperator();
        this.currentSelectionOperator = aCurrentSelectionOperator;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_CURRENT_SELECTION_OPERATOR, theOldOperator, aCurrentSelectionOperator);
    }

    public boolean isProperlyInitialized() {
        return this.projectDirectory != null;
    }

    public void setInitialized(boolean aInitializedFlag) {
        boolean theOldValue = this.initialized;
        this.initialized = aInitializedFlag;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_INITALIZED, theOldValue, this.initialized);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void checkInitialzied() {
        if (this.projectDirectory != null && this.projectDirectory.exists() && this.physicalDataSet != null) {
            this.setInitialized(true);
        } else {
            this.setInitialized(false);
        }
    }

    public void resultChanged(LookupEvent evt) {
        if (this.dataSetLookupResult.equals(evt.getSource()) && this.dataSetLookupResult.allItems().size() > 0) {
            this.setSelectedDataSet((DataSet)((Lookup.Item)this.dataSetLookupResult.allItems().iterator().next()).getInstance());
            this.setSelectedFilter(null);
            this.setCurrentDataSelection(null);
        }
        if (this.filterLookupResult.equals(evt.getSource()) && this.filterLookupResult.allItems().size() > 0) {
            Filter theFilter = (Filter)((Lookup.Item)this.filterLookupResult.allItems().iterator().next()).getInstance();
            SessionObject theParentSessionObject = theFilter.getParent();
            this.setSelectedFilter(theFilter);
            if (theFilter instanceof DataSelection) {
                this.setCurrentDataSelection((DataSelection)theFilter);
            }
            if (theParentSessionObject != null && theParentSessionObject instanceof DataSet) {
                this.setSelectedDataSet((DataSet)theParentSessionObject);
            }
        }
    }

    public void setSelectedDataSet(DataSet aSelectedDataSet) {
        DataSet theOldSelectedDataSet = this.selectedDataSet;
        this.selectedDataSet = aSelectedDataSet;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SELECTED_DATASET, theOldSelectedDataSet, aSelectedDataSet);
        this.repaintAllVisualization();
    }

    public DataSet getSelectedDataSet() {
        return this.selectedDataSet;
    }

    public void setSelectedFilter(Filter aSelectedFilter) {
        Filter theOldSelectedFilter = this.selectedFilter;
        this.selectedFilter = aSelectedFilter;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SELECTED_FILTER, theOldSelectedFilter, aSelectedFilter);
        this.repaintAllVisualization();
    }

    public Filter getSelectedFilter() {
        return this.selectedFilter;
    }

    public List<Algorithm> getAlgorithmList() {
        return this.algorithmList;
    }

    public void addAlgorithm(Algorithm anAlgorithm) {
        this.logInfo("Adding algorithm to project: " + anAlgorithm.getAlgorithmName());
        this.algorithmList.add(anAlgorithm);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_ALGORITHM_LIST, null, this.algorithmList);
        this.expandAllAlgorithmNodes();
    }

    public void removeAlgorithm(Algorithm anAlgorithm) {
        this.logInfo("Removing algorithm from project: " + anAlgorithm.getAlgorithmName());
        if (this.algorithmList.remove(anAlgorithm)) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_VISUALIZATION_LIST, null, this.algorithmList);
        }
    }

    public void saveToProjectFile(boolean aShouldShowInfoMessage) {
        this.logInfo("saveToProjectFile()");
        try {
            Element theRootElement = new Element(PROJECT_XML_ELEMENT_NAME);
            Document theXMLDocument = new Document(theRootElement);
            this.saveProjectPropertiesToElement(theRootElement);
            theRootElement.addContent((Content)this.getPhysicalDataSet().getSessionObjectXMLElement());
            for (Visualization eachVisualization : this.getVisualaziationList()) {
                this.logInfo("Saving visualisation: " + eachVisualization.getVisualizationName());
                eachVisualization.saveToElement(theRootElement);
            }
            XMLOutputter theXMLOutputter = new XMLOutputter();
            theXMLOutputter.setFormat(Format.getPrettyFormat());
            String theOutputFilePath = this.getProjectFilePath();
            FileOutputStream theFileOutputStream = new FileOutputStream(theOutputFilePath);
            this.logInfo("Saving to file: " + theOutputFilePath);
            theXMLOutputter.output(theXMLDocument, (OutputStream)theFileOutputStream);
            try {
                theFileOutputStream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (aShouldShowInfoMessage) {
                VisMinerUI.showSaveSuccessfullMessage();
            }
        }
        catch (IOException ex) {
            this.logError(ex.toString());
            Exceptions.printStackTrace((Throwable)ex);
            VisMinerUI.showSaveFailedMessage();
        }
    }

    public void rebuildProjectPropertiesFromElement(Element anElement) {
        if (anElement.getAttributeValue(PROJECT_NAME_ATTR_NAME) != null) {
            this.setProjectName(anElement.getAttributeValue(PROJECT_NAME_ATTR_NAME));
        }
        if (anElement.getAttributeValue(PROJECT_DESC_ATTR_NAME) != null) {
            this.setProjectDescription(anElement.getAttributeValue(PROJECT_DESC_ATTR_NAME));
        }
    }

    private void saveProjectPropertiesToElement(Element anElement) {
        if (this.getProjectName() != null) {
            anElement.setAttribute(PROJECT_NAME_ATTR_NAME, this.getProjectName());
        }
        if (this.getProjectDescription() != null) {
            anElement.setAttribute(PROJECT_DESC_ATTR_NAME, this.getProjectDescription());
        }
    }

    public String getPhysicalDataSetFileName() {
        return this.physicalDataSetFileName;
    }

    public static void copyFileToDir(File aSourceFile, File aDestFile) throws FileNotFoundException, IOException {
        FileChannel srcChannel = new FileInputStream(aSourceFile).getChannel();
        FileChannel dstChannel = new FileOutputStream(aDestFile).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }

    public File getProjectFile() {
        return new File(this.getProjectFilePath());
    }

    public String getProjectFilePath() {
        return this.getProjectDirectory() + File.separator + PROJECT_FILE_NAME;
    }

    public SessionGraphScene getSessionGraphScene() {
        return this.sessionGraphScene;
    }

    public VMDNodeWidget getVmdProjectNode() {
        return this.vmdProjectNode;
    }

    public String getProjectNodeId() {
        return this.projectNodeId;
    }

    public void expandSessionNode(Node aNode) {
        BeanTreeView theBeanTreeView = ObjectExplorerTopComponent.findInstance().getBeanTreeView();
        theBeanTreeView.expandNode(aNode);
    }

    public void expandAllSessionNodes() {
        BeanTreeView theBeanTreeView = ObjectExplorerTopComponent.findInstance().getBeanTreeView();
        theBeanTreeView.expandAll();
    }

    public void exapndAllVisualizationNodes() {
        BeanTreeView theBeanTreeView = VisualizationListTopComponent.findInstance().getBeanTreeView();
        theBeanTreeView.expandAll();
    }

    public void expandAllAlgorithmNodes() {
        BeanTreeView theBeanTreeView = AlgorithmListTopComponent.findInstance().getBeanTreeView();
        theBeanTreeView.expandAll();
    }
}

