/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase;

import java.util.Collection;
import org.openide.util.Lookup;
import org.tpo.visminerapi.algorithm.AlgorithmFactory;
import org.tpo.visminerapi.dataimporter.DataImporter;
import org.tpo.visminerapi.dataimporter.FileDataImporter;
import org.tpo.visminerapi.datastorage.DataStorage;
import org.tpo.visminerapi.visualization.VisualizationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisMinerObjectFactory {
    private static VisMinerObjectFactory visMinerObjectFactory;
    private static Lookup.Result<DataImporter> dataImporters;
    private static Lookup.Result<FileDataImporter> fileDataImporters;
    private static Lookup.Result<DataStorage> dataStorages;
    private static Lookup.Result<VisualizationFactory> visualizationFactories;
    private static Lookup.Result<AlgorithmFactory> algorithmFactories;

    private VisMinerObjectFactory() {
    }

    public static VisMinerObjectFactory getInstance() {
        if (visMinerObjectFactory == null) {
            visMinerObjectFactory = new VisMinerObjectFactory();
        }
        return visMinerObjectFactory;
    }

    public static Collection<? extends DataImporter> getAllDataImporters() {
        return dataImporters.allInstances();
    }

    public static Collection<? extends FileDataImporter> getAllFileDataImporters() {
        return fileDataImporters.allInstances();
    }

    public static Collection<? extends DataStorage> getAllDataStorages() {
        return dataStorages.allInstances();
    }

    public static Collection<? extends VisualizationFactory> getAllVisualizationFactories() {
        return visualizationFactories.allInstances();
    }

    public static Collection<? extends AlgorithmFactory> getAllAlgorithmFactories() {
        return algorithmFactories.allInstances();
    }

    static {
        dataImporters = Lookup.getDefault().lookupResult(DataImporter.class);
        fileDataImporters = Lookup.getDefault().lookupResult(FileDataImporter.class);
        dataStorages = Lookup.getDefault().lookupResult(DataStorage.class);
        visualizationFactories = Lookup.getDefault().lookupResult(VisualizationFactory.class);
        algorithmFactories = Lookup.getDefault().lookupResult(AlgorithmFactory.class);
    }
}

