/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase;

import java.util.ArrayList;
import java.util.List;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.visualization.Visualization;
import org.tpo.visminerbase.RepaintVisualizationThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizationManager
extends VisMinerObject {
    private RepaintVisualizationThread repaintThread;
    private static VisualizationManager visualizationManager = new VisualizationManager();
    private boolean repeatRepaint = false;
    private List<Visualization> visualizationList = new ArrayList<Visualization>();

    public static VisualizationManager getInstance() {
        return visualizationManager;
    }

    public void repaintThreadFinishedCallback() {
        this.setRepaintThread(null);
        if (this.isRepeatRepaint()) {
            this.setRepeatRepaint(false);
            this.logInfo("Repeating repainting visualization");
            this.repaintAllVisualization();
        }
    }

    public synchronized void setRepaintThread(RepaintVisualizationThread repaintThread) {
        this.repaintThread = repaintThread;
    }

    public synchronized RepaintVisualizationThread getRepaintThread() {
        return this.repaintThread;
    }

    public synchronized void repaintAllVisualization() {
        this.logInfo("Repaint all visualization");
        if (this.getRepaintThread() != null) {
            this.logInfo("Setting repeat repaint to true");
            this.setRepeatRepaint(true);
        } else {
            this.logInfo("Starting new repaint thread");
            this.setRepaintThread(new RepaintVisualizationThread(new ArrayList<Visualization>(this.visualizationList), this));
            this.getRepaintThread().start();
        }
    }

    public synchronized void setRepeatRepaint(boolean repeatRepaint) {
        this.repeatRepaint = repeatRepaint;
    }

    public synchronized boolean isRepeatRepaint() {
        return this.repeatRepaint;
    }

    public synchronized void addVisualzation(Visualization aVisualization) {
        this.visualizationList.add(aVisualization);
    }

    public synchronized boolean removeVisualization(Visualization aVisualization) {
        return this.visualizationList.remove(aVisualization);
    }

    public synchronized List<Visualization> getVisualizationList() {
        return this.visualizationList;
    }

    void closeAllVisualizations() {
        ArrayList<Visualization> theVisualizations = new ArrayList<Visualization>(this.visualizationList);
        this.visualizationList = new ArrayList<Visualization>();
        for (Visualization eachVisalization : theVisualizations) {
            eachVisalization.closeVisualization();
        }
    }

    void deleteAllVisualization() {
        this.visualizationList.clear();
    }
}

