/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;
import org.tpo.visminerapi.algorithm.AlgorithmFactory;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.datastorage.session.SessionObject;
import org.tpo.visminerapi.datastorage.session.XMLSessionBuilder;
import org.tpo.visminerapi.exceptions.SessionBuilderException;
import org.tpo.visminerapi.visualization.Visualization;
import org.tpo.visminerapi.visualization.VisualizationFactory;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.VisMinerObjectFactory;
import org.tpo.visminerbase.selection.RectangularDataSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSessionBuilderImpl
extends VisMinerObject
implements XMLSessionBuilder {
    Document projectDocument;
    ProgressHandle theProgressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(XMLSessionBuilderImpl.class, (String)"ProgressMessage"));

    public void rebuildSessionFromProjectFile() throws SessionBuilderException {
        this.rebuildSessionFromProjectFileUsingDataSetFile(null);
    }

    public void rebuildSessionFromProjectFileUsingDataSetFile(File aDataSetFile) throws SessionBuilderException {
        this.theProgressHandle.setInitialDelay(0);
        this.theProgressHandle.start();
        try {
            this.projectDocument = this.buildProjectDocument();
            Element theProjectElement = this.projectDocument.getRootElement();
            this.logInfo("Rebuilding project from XML root element.");
            if (theProjectElement == null || !"VisMinerProject".equals(theProjectElement.getName())) {
                throw new SessionBuilderException("Root element of project file is missing or incompatible.");
            }
            VisMinerApplication.getInstance().rebuildProjectPropertiesFromElement(theProjectElement);
            this.logInfo("Rebuilding physical data set from XML element");
            List thePhysicalDataSetElements = theProjectElement.getChildren("PhysicalDataSet");
            if (thePhysicalDataSetElements == null || thePhysicalDataSetElements.size() != 1) {
                throw new SessionBuilderException("Number of physical data elements in project file is not valid.");
            }
            Element thePhysicalDataElement = (Element)thePhysicalDataSetElements.get(0);
            VisMinerApplication.getInstance().rebuildPhysicalDataFromElement(thePhysicalDataElement, aDataSetFile);
            List thePhysicalDataChildren = thePhysicalDataElement.getChildren();
            for (Object eachElement : thePhysicalDataChildren) {
                this.attachFilterObjectFromElement((SessionObject)VisMinerApplication.getInstance().getPhysicalDataSet(), (Element)eachElement);
            }
            for (Object eachProjectChildElement : theProjectElement.getChildren()) {
                this.buildVisualiaztionFromElement(eachProjectChildElement);
            }
            VisMinerApplication.getInstance().getSessionGraphScene().layoutScene();
            VisMinerApplication.getInstance().expandAllSessionNodes();
        }
        catch (JDOMException ex) {
            throw new SessionBuilderException("Malformed project xml file", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SessionBuilderException("IO error", (Exception)ex);
        }
        finally {
            this.theProgressHandle.finish();
        }
    }

    private Document buildProjectDocument() throws JDOMException, IOException {
        SAXBuilder parser = new SAXBuilder();
        return parser.build(this.getProjectFile());
    }

    private void buildVisualiaztionFromElement(Object anElement) throws SessionBuilderException {
        for (VisualizationFactory visualizationFactory : VisMinerObjectFactory.getAllVisualizationFactories()) {
            if (!visualizationFactory.canCreateAlgortihmFromElement((Element)anElement)) continue;
            Visualization theVisualization = visualizationFactory.createVisualizationFromElement((Element)anElement, (XMLSessionBuilder)this);
            theVisualization.showVisualization();
        }
    }

    private File getProjectFile() {
        return VisMinerApplication.getInstance().getProjectFile();
    }

    public void attachFilterObjectFromElement(SessionObject aParent, Element anElement) throws SessionBuilderException {
        Collection<? extends AlgorithmFactory> theAlgFactories = VisMinerObjectFactory.getAllAlgorithmFactories();
        if (RectangularDataSelection.RECTANGULAR_SELECTION_XML_NAME.equals(anElement.getName())) {
            RectangularDataSelection theRectangularDataSelection = new RectangularDataSelection(aParent, anElement, this);
        } else {
            for (AlgorithmFactory algorithmFactory : theAlgFactories) {
                if (!algorithmFactory.canCreateAlgortihmFromElement(anElement)) continue;
                this.logInfo("Creating algorithm from element using factory for: {0}", new Object[]{algorithmFactory.getAlgorithmName()});
                algorithmFactory.createAlgorithmFromElement(aParent, anElement, (XMLSessionBuilder)this);
                return;
            }
        }
    }

    public void attachFilerObjectsFromElements(SessionObject aParent, List<Element> anElementList) throws SessionBuilderException {
        for (Element eachElement : anElementList) {
            this.attachFilterObjectFromElement(aParent, eachElement);
        }
    }
}

