/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.actions.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.tpo.visminerapi.exceptions.ProjectException;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.ui.VisMinerUI;

public final class NewProjectAction
extends CallableSystemAction
implements PropertyChangeListener {
    public NewProjectAction() {
        VisMinerApplication.getInstance().addPropertyChangeListener(this);
        this.updateStateAccordingToApplication();
    }

    public void performAction() {
        try {
            File theProjectDirectory = VisMinerUI.selectDirectoryForProject();
            if (theProjectDirectory != null) {
                VisMinerApplication.getInstance().initWithDirectory(theProjectDirectory, true);
            }
        }
        catch (ProjectException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getName() {
        return NbBundle.getMessage(NewProjectAction.class, (String)"CTL_NewProjectAction");
    }

    protected String iconResource() {
        return "org/tpo/visminerbase/ui/icons/bookadd.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private void updateStateAccordingToApplication() {
        if (VisMinerApplication.getInstance().getProjectDirectory() != null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("ProjectDirectoryProperty".equals(evt.getPropertyName())) {
            this.updateStateAccordingToApplication();
        }
    }
}

