/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.actions.project;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.visminerapi.exceptions.ProjectException;
import org.tpo.visminerapi.exceptions.SessionBuilderException;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.XMLSessionBuilderImpl;
import org.tpo.visminerbase.ui.VisMinerUI;

public class OpenExistingProjectAction
extends AbstractAction
implements PropertyChangeListener {
    public OpenExistingProjectAction() {
        this.putValue("Name", NbBundle.getMessage(OpenExistingProjectAction.class, (String)"CTL_OpenExistingProjectAction"));
        VisMinerApplication.getInstance().addPropertyChangeListener(this);
        this.updateStateAccordingToApplication();
    }

    public void actionPerformed(ActionEvent e) {
        try {
            ApplicationLogger.logInfo(OpenExistingProjectAction.class, (String)"Opening existing project");
            File theProjectDirectory = VisMinerUI.selectDirectoryForProject();
            if (theProjectDirectory != null) {
                VisMinerApplication.getInstance().initWithDirectory(theProjectDirectory, false);
                ApplicationLogger.logInfo(OpenExistingProjectAction.class, (String)"Rebuilding session from project file");
                XMLSessionBuilderImpl theSessionBuilder = new XMLSessionBuilderImpl();
                theSessionBuilder.rebuildSessionFromProjectFile();
            }
        }
        catch (SessionBuilderException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            ApplicationLogger.logWarning(VisMinerApplication.class, (String)"Error in rebuilding session when opening existing project.");
            VisMinerUI.showBuildingSessionErrorMessage();
        }
        catch (ProjectException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            ApplicationLogger.logWarning(VisMinerApplication.class, (String)"Error in rebuilding session when opening existing project.");
            VisMinerUI.showBuildingSessionErrorMessage();
        }
    }

    private void updateStateAccordingToApplication() {
        if (VisMinerApplication.getInstance().getProjectDirectory() != null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("ProjectDirectoryProperty".equals(evt.getPropertyName())) {
            this.updateStateAccordingToApplication();
        }
    }
}

