/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.actions.visualization;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.visminerapi.visualization.Visualization;

public class MakeVisualizationActiveAction
extends AbstractAction
implements LookupListener,
ContextAwareAction {
    private Lookup context;
    private Lookup.Result<Visualization> lkpInfo;

    public MakeVisualizationActiveAction() {
        this(Utilities.actionsGlobalContext());
    }

    private MakeVisualizationActiveAction(Lookup aContext) {
        this.putValue("Name", NbBundle.getMessage(MakeVisualizationActiveAction.class, (String)"CTL_MakeVisualizationActiveAction"));
        this.context = aContext;
    }

    void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "This shall be called just from AWT thread.";
        if (this.lkpInfo != null) {
            return;
        }
        Lookup.Template tpl = new Lookup.Template(Visualization.class);
        this.lkpInfo = this.context.lookup(tpl);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void resultChanged(LookupEvent arg0) {
        this.setEnabled(this.lkpInfo.allItems().size() != 0);
    }

    public Action createContextAwareInstance(Lookup aContext) {
        return new MakeVisualizationActiveAction(aContext);
    }

    public boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    public void actionPerformed(ActionEvent anEvent) {
        ApplicationLogger.logInfo(MakeVisualizationActiveAction.class, (String)"Action performed.", null);
        this.init();
        Collection theVisualizations = this.lkpInfo.allInstances();
        if (theVisualizations.size() > 0) {
            Visualization theVisualization = (Visualization)theVisualizations.iterator().next();
            theVisualization.makeActive();
        } else {
            ApplicationLogger.logInfo(MakeVisualizationActiveAction.class, (String)"No visualization found in context.", null);
        }
    }
}

