/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.datastorage.session;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.vmd.VMDPinWidget;
import org.openide.nodes.Node;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.datastorage.session.SessionObject;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.datastorage.session.SessionGraphScene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionObject
extends VisMinerObject
implements SessionObject {
    public static String SESSION_OBJECT_XML_NAME = "AbtractSessionOjbect";
    public static String NAME_ATTR_NAME = "Name";
    public static String DESCRIPTION_ATTR_NAME = "Description";
    public static String PROPERTY_NAME_NAME = "name";
    public static String PROPERTY_DESCRIPTION_NAME = "description";
    public static String DESC_NODE_SUFFIX = "descNode";
    public static String DESC_PIN_SUFFIX = "descPin";
    public static final Color DEFAULT_RECORD_COLOR = Color.BLACK;
    private List<SessionObject> children = new ArrayList<SessionObject>();
    private String name;
    private String description;
    private SessionObject parent;
    private String sessionObjectId;
    private String edgeToParentId;
    VMDNodeWidget vdmNode;
    VMDPinWidget vdmPin;
    public PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);

    public AbstractSessionObject() {
        VisMinerApplication.getInstance().getSessionGraphScene();
        this.setSessionObjectId(SessionGraphScene.getNextEdgeId());
        VisMinerApplication.getInstance().getSessionGraphScene();
        this.setEdgeToParentId(SessionGraphScene.getNextNodeId());
    }

    public List<SessionObject> getChildren() {
        return this.children;
    }

    public void addChild(SessionObject aSessionObject) {
        this.logInfo("Adding child: {0}", new Object[]{aSessionObject});
        this.children.add(aSessionObject);
        this.propertyChangeSupport.firePropertyChange("childrenProperty", null, this.children);
    }

    public void removeChild(SessionObject aSessionObject) {
        if (this.children.contains(aSessionObject)) {
            this.logInfo("Removing child: {0}", new Object[]{aSessionObject});
            this.children.remove(aSessionObject);
            this.propertyChangeSupport.firePropertyChange("childrenProperty", null, this.children);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.addPropertyChangeListener(aListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.removePropertyChangeListener(aListener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        String theOldName = this.name;
        this.name = aName;
        if (this.vdmNode != null) {
            this.vdmNode.setNodeName(aName);
        }
        if (this.vdmPin != null) {
            this.vdmPin.setPinName(aName);
        }
        this.rapaintGraph();
        this.propertyChangeSupport.firePropertyChange("dataSetName", theOldName, this.name);
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public void setDescription(String aDescription) {
        String theOldDesc = this.description;
        this.description = aDescription;
        if (this.vdmNode != null) {
            this.vdmNode.setToolTipText(aDescription);
        }
        if (this.vdmPin != null) {
            this.vdmPin.setToolTipText(aDescription);
        }
        this.propertyChangeSupport.firePropertyChange("dataSetDescription", theOldDesc, this.description);
    }

    public SessionObject getParent() {
        return this.parent;
    }

    public void setParent(SessionObject aParent) {
        this.logInfo("Setting parent: {0}", new Object[]{aParent});
        this.parent = aParent;
        if (this.isFilter()) {
            VisMinerApplication.getInstance().getSessionGraphScene();
            this.vdmNode = SessionGraphScene.createNode(VisMinerApplication.getInstance().getSessionGraphScene(), 0, 0, null, this.getSessionObjectId(), "", null, null);
            VisMinerApplication.getInstance().getSessionGraphScene();
            SessionGraphScene.createEdge(VisMinerApplication.getInstance().getSessionGraphScene(), aParent.getSessionObjectId(), this.getSessionObjectId());
        }
        if (this.isDataSet()) {
            VisMinerApplication.getInstance().getSessionGraphScene();
            this.vdmPin = SessionGraphScene.createPin(VisMinerApplication.getInstance().getSessionGraphScene(), aParent.getSessionObjectId(), this.getSessionObjectId(), null, "", "");
        }
        this.updatePinAndNodeProperties();
    }

    public void recomputeData() {
        this.logInfo("Recomputing data");
        for (SessionObject eachSessionObject : this.getChildren()) {
            eachSessionObject.recomputeData();
        }
    }

    public Element getSessionObjectXMLElement() {
        Element theElement = new Element(SESSION_OBJECT_XML_NAME);
        theElement.getAttributeValue("name", this.getName());
        theElement.setContent(this.getChildrenElemnts());
        return theElement;
    }

    protected List<Element> getChildrenElemnts() {
        ArrayList<Element> childrenElements = new ArrayList<Element>();
        for (SessionObject eachSessionObject : this.getChildren()) {
            childrenElements.add(eachSessionObject.getSessionObjectXMLElement());
        }
        return childrenElements;
    }

    public void saveNameToElement(Element anElement) {
        if (this.getName() != null) {
            anElement.setAttribute(NAME_ATTR_NAME, this.getName());
        }
    }

    public void saveDescriptionToElement(Element anElement) {
        if (this.getDescription() != null) {
            anElement.setAttribute(DESCRIPTION_ATTR_NAME, this.getDescription());
        }
    }

    public void loadNameFromElement(Element anElement) {
        this.setName(anElement.getAttributeValue(NAME_ATTR_NAME));
    }

    public void loadDescriptionFromElement(Element anElement) {
        this.setDescription(anElement.getAttributeValue(DESCRIPTION_ATTR_NAME));
    }

    public void saveAttributesToElement(Element anElement) {
        this.saveNameToElement(anElement);
        this.saveDescriptionToElement(anElement);
    }

    public void loadAttributesFromElement(Element anElement) {
        this.loadNameFromElement(anElement);
        this.loadDescriptionFromElement(anElement);
    }

    public String getSessionObjectId() {
        return this.sessionObjectId;
    }

    public void setSessionObjectId(String anId) {
        this.sessionObjectId = anId;
    }

    public void setEdgeToParentId(String anId) {
        this.edgeToParentId = anId;
    }

    public String getEdgeToParentId() {
        return this.edgeToParentId;
    }

    public boolean isDataSet() {
        return SessionObject.SessionObjectType.DATASET.equals((Object)this.getSessionObjecType());
    }

    public boolean isFilter() {
        return SessionObject.SessionObjectType.FILTER.equals((Object)this.getSessionObjecType());
    }

    public void setVdmPin(VMDPinWidget vdmPin) {
        this.vdmPin = vdmPin;
    }

    public void setVdmNode(VMDNodeWidget vdmNode) {
        this.vdmNode = vdmNode;
    }

    public void updatePinAndNodeProperties() {
        if (this.vdmNode != null) {
            this.vdmNode.setNodeName(this.getName());
        }
        if (this.vdmPin != null) {
            this.vdmPin.setPinName(this.getName());
        }
    }

    public List<Node.Property> getEditableProperties() {
        return new ArrayList<Node.Property>();
    }

    public boolean canPerformDelete() {
        for (SessionObject eachSessionObject : this.getChildren()) {
            if (eachSessionObject.canPerformDelete()) continue;
            return false;
        }
        return true;
    }

    public void performDelete() {
        ArrayList<SessionObject> theChildren = new ArrayList<SessionObject>(this.getChildren());
        for (SessionObject eachSessionObject : theChildren) {
            eachSessionObject.performDelete();
        }
        if (this.getParent() != null) {
            this.getParent().removeChild((SessionObject)this);
        }
        if (this.vdmNode != null) {
            VisMinerApplication.getInstance().getSessionGraphScene().removeNodeWithEdges(this.getSessionObjectId());
        }
        if (this.vdmPin != null) {
            VisMinerApplication.getInstance().getSessionGraphScene().removePin(this.getSessionObjectId());
        }
    }

    private void rapaintGraph() {
        JComponent theView = VisMinerApplication.getInstance().getSessionGraphScene().getView();
        if (theView != null) {
            theView.repaint();
        }
    }
}

