/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.selection;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.jdom.Element;
import org.openide.util.NbBundle;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerapi.datastorage.data.DataValue;
import org.tpo.visminerapi.datastorage.data.Filter;
import org.tpo.visminerapi.datastorage.session.SessionObject;
import org.tpo.visminerapi.exceptions.SessionBuilderException;
import org.tpo.visminerapi.selection.DataSelection;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.XMLSessionBuilderImpl;
import org.tpo.visminerbase.datastorage.session.AbstractSessionObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectangularDataSelection
extends AbstractSessionObject
implements DataSelection {
    public static String RECTANGULAR_SELECTION_XML_NAME = "RectangularDataSelection";
    public static String RECTANGLE_AREA_XML_NAME = "RectangleArea";
    public static String X_POS_ATTR_NAME = "xPosition";
    public static String Y_POS_ATTR_NAME = "yPosition";
    public static String WIDTH_ATTR_NAME = "Width";
    public static String HEIGHT_ATTR_NAME = "Height";
    public static String OPERATOR_ATTR_NAME = "AreaOperator";
    public static String X_DATA_DIMENSION_NAME_ATTR_NAME = "xDataDimension";
    public static String Y_DATA_DIMENSION_NAME_ATTR_NAME = "yDataDimension";
    public static final Color DEFAULT_POINT_IN_SELECTION_COLOR = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final String PROPERTY_RECT_AREA_COUNT = "RectAreaCount";
    private Boolean[] selectionCache;
    DataDimension xDataDimension;
    DataDimension yDataDimension;
    List<Rectangle2D.Double> areaRectangles = new ArrayList<Rectangle2D.Double>();
    List<DataSelection.SelectionOperator> selectionOperators = new ArrayList<DataSelection.SelectionOperator>();
    Integer selectedRecordCount;

    public RectangularDataSelection(SessionObject aPerentObject, Element anElement, XMLSessionBuilderImpl aSessionBuilder) throws SessionBuilderException {
        this.logInfo("Building rectangular selection from XML element.");
        DataSet logicalDataSet = VisMinerApplication.getInstance().createLogicalDataSet((DataSet)aPerentObject, this);
        this.initPropertiesFromElement(anElement);
        this.selectionCache = new Boolean[this.xDataDimension.getValues().size()];
        this.loadAreasFromElement(anElement);
        this.propertyChangeSupport.firePropertyChange("selectedRecordCount", null, (Object)this.getSelectedRecordCount());
        Element theLogicalDataElement = anElement.getChild("LogicalDataSet");
        if (theLogicalDataElement == null) {
            new SessionBuilderException("No elemnt for logical data of rectangular selection found.");
        }
        if (logicalDataSet instanceof AbstractSessionObject) {
            ((AbstractSessionObject)logicalDataSet).loadNameFromElement(theLogicalDataElement);
            ((AbstractSessionObject)logicalDataSet).loadDescriptionFromElement(theLogicalDataElement);
        }
        this.logInfo("Attaching child session objects from child elements of logical data set.");
        aSessionBuilder.attachFilerObjectsFromElements((SessionObject)logicalDataSet, theLogicalDataElement.getChildren());
    }

    public RectangularDataSelection(DataDimension aXDataDimension, DataDimension aYDataDimension) {
        this.xDataDimension = aXDataDimension;
        this.yDataDimension = aYDataDimension;
        this.selectionCache = new Boolean[this.xDataDimension.getValues().size()];
        this.setName(NbBundle.getMessage(RectangularDataSelection.class, (String)"DefaultRectangularSelectionName"));
    }

    public boolean isDataValueInFilter(DataValue aDataValue) {
        return this.isDataValueInSelection(aDataValue);
    }

    private void initPropertiesFromElement(Element anElement) throws SessionBuilderException {
        this.loadNameFromElement(anElement);
        this.loadDescriptionFromElement(anElement);
        String xDataDimName = anElement.getAttributeValue(X_DATA_DIMENSION_NAME_ATTR_NAME);
        String yDataDimName = anElement.getAttributeValue(Y_DATA_DIMENSION_NAME_ATTR_NAME);
        if (xDataDimName == null || xDataDimName.trim().equals("")) {
            throw new SessionBuilderException("No x data dimension name specified for rectangular selection.");
        }
        if (yDataDimName == null || yDataDimName.trim().equals("")) {
            throw new SessionBuilderException("No y data dimension name specified for rectangular selection.");
        }
        List theDimensions = VisMinerApplication.getInstance().getPhysicalDataSet().getDimensions();
        for (DataDimension eachDimension : theDimensions) {
            if (xDataDimName.equals(eachDimension.getDimensionName())) {
                this.xDataDimension = eachDimension;
            }
            if (!yDataDimName.equals(eachDimension.getDimensionName())) continue;
            this.yDataDimension = eachDimension;
        }
        if (this.xDataDimension == null) {
            throw new SessionBuilderException("No x data dimension found for name:" + xDataDimName);
        }
        if (this.yDataDimension == null) {
            throw new SessionBuilderException("No y data dimension found for name:" + yDataDimName);
        }
    }

    private synchronized boolean isRecordWithIndexInSelection(int anIndex) {
        if (this.areaRectangles.size() == 0) {
            return false;
        }
        Double theXNormalizedValue = this.xDataDimension.getNormalizedValue(anIndex);
        Double theYNormalizedValue = this.yDataDimension.getNormalizedValue(anIndex);
        Boolean theResult = null;
        for (int theRectIndex = 0; theRectIndex < this.areaRectangles.size(); ++theRectIndex) {
            Boolean theModifier = this.getResultModifierForRectangle(theRectIndex, theXNormalizedValue, theYNormalizedValue);
            if (theModifier == null) continue;
            theResult = theResult == null ? theModifier : Boolean.valueOf(theResult != false && theModifier != false);
        }
        if (theResult == null) {
            return false;
        }
        return theResult;
    }

    private Boolean getResultModifierForRectangle(int aRectIndex, Double aXRecordValue, Double aYRecordValue) {
        boolean theInRectFlag = this.areaRectangles.get(aRectIndex).contains(aXRecordValue, aYRecordValue);
        DataSelection.SelectionOperator theSelectionOperator = this.selectionOperators.get(aRectIndex);
        if (DataSelection.SelectionOperator.ADD_RECORDS.equals((Object)theSelectionOperator)) {
            if (theInRectFlag) {
                return new Boolean(true);
            }
            return null;
        }
        if (DataSelection.SelectionOperator.REMOVE_RECORDS.equals((Object)theSelectionOperator)) {
            if (theInRectFlag) {
                return new Boolean(false);
            }
            return null;
        }
        return null;
    }

    private void clearCache() {
        this.selectionCache = new Boolean[this.xDataDimension.getValues().size()];
        this.selectedRecordCount = null;
    }

    public synchronized void addRectangularAreaToSelection(Rectangle2D.Double aRectangle, DataSelection.SelectionOperator aOperator) {
        assert (aRectangle != null);
        assert (aOperator != null);
        this.logInfo("Adding rectangle {0} to selection with operaotr {1}", new Object[]{aRectangle, aOperator});
        this.areaRectangles.add(aRectangle);
        this.selectionOperators.add(aOperator);
        this.recomputeData();
        this.propertyChangeSupport.firePropertyChange("selectedRecordCount", null, (Object)this.getSelectedRecordCount());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_RECT_AREA_COUNT, null, (Object)this.areaRectangles.size());
    }

    public void removeRectangularArea(int anIndex) {
        this.areaRectangles.remove(anIndex);
        this.selectionOperators.remove(anIndex);
        this.recomputeData();
        this.propertyChangeSupport.firePropertyChange("selectedRecordCount", null, (Object)this.getSelectedRecordCount());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_RECT_AREA_COUNT, null, (Object)this.areaRectangles.size());
    }

    public List<Rectangle2D.Double> getAreaRectangles() {
        return this.areaRectangles;
    }

    public DataDimension getXDataDimension() {
        return this.xDataDimension;
    }

    public DataDimension getYDataDimension() {
        return this.yDataDimension;
    }

    public int getSelectedRecordCount() {
        if (this.selectedRecordCount == null) {
            this.selectedRecordCount = this.countSelectedRecords();
        }
        return this.selectedRecordCount;
    }

    private Integer countSelectedRecords() {
        int theResult = 0;
        Iterator theIt = this.xDataDimension.getValues().iterator();
        while (theIt.hasNext()) {
            if (!this.isDataValueInFilter((DataValue)theIt.next())) continue;
            ++theResult;
        }
        return new Integer(theResult);
    }

    public void updateRectangularArea(int anAreaIndex, Rectangle2D.Double aRect) {
        this.getAreaRectangles().set(anAreaIndex, aRect);
        this.recomputeData();
        this.propertyChangeSupport.firePropertyChange("selectedRecordCount", null, (Object)this.getSelectedRecordCount());
    }

    public boolean isDataValueInSelection(DataValue aDataValue) {
        return this.isDataValueInFilter(aDataValue.getPhysicalDataIndex());
    }

    public boolean isDataValueInFilter(int anIndex) {
        if (this.selectionCache[anIndex] == null) {
            this.selectionCache[anIndex] = this.isRecordWithIndexInSelection(anIndex) ? new Boolean(true) : new Boolean(false);
        }
        return this.selectionCache[anIndex];
    }

    public Filter getFilter() {
        return this;
    }

    @Override
    public void recomputeData() {
        this.clearCache();
        super.recomputeData();
    }

    public Color chooseDataRecordColor(int aDataRecordIndex) {
        if (this.isDataValueInFilter(aDataRecordIndex)) {
            return DEFAULT_POINT_IN_SELECTION_COLOR;
        }
        return this.getParent().chooseDataRecordColor(aDataRecordIndex);
    }

    @Override
    public Element getSessionObjectXMLElement() {
        Element theResult = new Element(RECTANGULAR_SELECTION_XML_NAME);
        this.saveNameToElement(theResult);
        this.saveDescriptionToElement(theResult);
        theResult.setAttribute(X_DATA_DIMENSION_NAME_ATTR_NAME, this.xDataDimension.getDimensionName());
        theResult.setAttribute(Y_DATA_DIMENSION_NAME_ATTR_NAME, this.yDataDimension.getDimensionName());
        theResult.addContent(this.getRectangularAreElements());
        theResult.addContent(this.getChildrenElemnts());
        return theResult;
    }

    private List<Element> getRectangularAreElements() {
        ArrayList<Element> theAreaElements = new ArrayList<Element>();
        for (Rectangle2D.Double theArea : this.areaRectangles) {
            DataSelection.SelectionOperator theOperator = this.selectionOperators.get(this.areaRectangles.indexOf(theArea));
            Element theAreaElement = new Element(RECTANGLE_AREA_XML_NAME);
            theAreaElement.setAttribute(X_POS_ATTR_NAME, Double.toString(theArea.x));
            theAreaElement.setAttribute(Y_POS_ATTR_NAME, Double.toString(theArea.y));
            theAreaElement.setAttribute(WIDTH_ATTR_NAME, Double.toString(theArea.width));
            theAreaElement.setAttribute(HEIGHT_ATTR_NAME, Double.toString(theArea.height));
            theAreaElement.setAttribute(OPERATOR_ATTR_NAME, theOperator.toString());
            theAreaElements.add(theAreaElement);
        }
        return theAreaElements;
    }

    private void loadAreasFromElement(Element anElement) {
        List theAreaElemnts = anElement.getChildren(RECTANGLE_AREA_XML_NAME);
        for (Object eachAreaElement : theAreaElemnts) {
            this.rebuildAreaFromElement((Element)eachAreaElement);
        }
    }

    private void rebuildAreaFromElement(Element anElement) {
        try {
            String theXPosString = anElement.getAttributeValue(X_POS_ATTR_NAME);
            Double theXCoord = new Double(theXPosString);
            String theYPosString = anElement.getAttributeValue(Y_POS_ATTR_NAME);
            Double theYCoord = new Double(theYPosString);
            String theWidthString = anElement.getAttributeValue(WIDTH_ATTR_NAME);
            Double theWidth = new Double(theWidthString);
            String theHeightString = anElement.getAttributeValue(HEIGHT_ATTR_NAME);
            Double theHeight = new Double(theHeightString);
            if (theXCoord == null || theYCoord == null || theWidth == null || theHeight == null) {
                throw new SessionBuilderException("Missing some coordinate for rectangular area.");
            }
            String theSelectionOperatorString = anElement.getAttributeValue(OPERATOR_ATTR_NAME);
            if (theSelectionOperatorString == null) {
                throw new SessionBuilderException("No selection operator specified for rectangular area.");
            }
            DataSelection.SelectionOperator theOperator = DataSelection.SelectionOperator.valueOf((String)theSelectionOperatorString);
            if (theOperator == null) {
                throw new SessionBuilderException("No selection operator found for string: " + theSelectionOperatorString);
            }
            this.addRectangularAreaToSelection(new Rectangle2D.Double(theXCoord, theYCoord, theWidth, theHeight), theOperator);
        }
        catch (Exception ex) {
            new SessionBuilderException("Error during creating of reactangular are in selection", ex);
        }
    }

    public SessionObject.SessionObjectType getSessionObjecType() {
        return SessionObject.SessionObjectType.FILTER;
    }

    public List<Action> getAdditionalAction() {
        return new ArrayList<Action>();
    }

    public DataSelection.SelectionOperator getSelectionOperatorForAre(int anAreaIndex) {
        return this.selectionOperators.get(anAreaIndex);
    }

    public void setAreaOperator(int anAreaIndex, DataSelection.SelectionOperator aOperator) {
        this.selectionOperators.set(anAreaIndex, aOperator);
        this.recomputeData();
        this.propertyChangeSupport.firePropertyChange("selectedRecordCount", null, (Object)this.getSelectedRecordCount());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_RECT_AREA_COUNT, null, (Object)this.areaRectangles.size());
    }
}

