/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.ui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;
import org.tpo.visminerapi.common.VisMinerObject;

public class VisMinerUI
extends VisMinerObject {
    private static JFileChooser dataImportFileChooser;
    private static JFileChooser projectDirectoryFileChooser;

    private VisMinerUI() {
    }

    private static JFileChooser getDataImportFileChooser() {
        if (dataImportFileChooser == null) {
            dataImportFileChooser = new JFileChooser();
            dataImportFileChooser.setApproveButtonText(NbBundle.getMessage(VisMinerUI.class, (String)"DataFileImportChooser_ApproveButtonText"));
        }
        return dataImportFileChooser;
    }

    private static JFileChooser getProjectDirectoryFileChooser() {
        if (projectDirectoryFileChooser == null) {
            projectDirectoryFileChooser = new JFileChooser();
            projectDirectoryFileChooser.setApproveButtonText(NbBundle.getMessage(VisMinerUI.class, (String)"DataFileImportChooser_ApproveButtonText"));
            projectDirectoryFileChooser.setFileSelectionMode(1);
        }
        return projectDirectoryFileChooser;
    }

    public static File selectFileForDataImport() {
        int theChooserResult = VisMinerUI.getDataImportFileChooser().showOpenDialog(null);
        if (theChooserResult == 0) {
            return VisMinerUI.getDataImportFileChooser().getSelectedFile();
        }
        return null;
    }

    public static File selectDirectoryForProject() {
        int theChooserResult = VisMinerUI.getProjectDirectoryFileChooser().showOpenDialog(null);
        if (theChooserResult == 0) {
            return VisMinerUI.getProjectDirectoryFileChooser().getSelectedFile();
        }
        return null;
    }

    public static void showInfoMessageDialog(String aTitle, String aMessage) {
        JOptionPane.showMessageDialog(null, aMessage, aTitle, 1);
    }

    public static void showErrorMessageDialog(String aTitle, String aMessage) {
        JOptionPane.showMessageDialog(null, aMessage, aTitle, 0);
    }

    public static void showPlainMessageDialog(String aTitle, String aMessage) {
        JOptionPane.showMessageDialog(null, aMessage, aTitle, -1);
    }

    public static void showWarningMessageDialog(String aTitle, String aMessage) {
        JOptionPane.showMessageDialog(null, aMessage, aTitle, 2);
    }

    public static void showNoFileImporterFoundMessage() {
        VisMinerUI.showWarningMessageDialog(NbBundle.getMessage(VisMinerUI.class, (String)"Message_NoFileImporterFoundTitle"), NbBundle.getMessage(VisMinerUI.class, (String)"Message_NoFileImporterFoundText"));
    }

    public static void showDataImportErrorMessage() {
        VisMinerUI.showWarningMessageDialog(NbBundle.getMessage(VisMinerUI.class, (String)"Message_DataImportErrorTitle"), NbBundle.getMessage(VisMinerUI.class, (String)"Message_DataImportErrorText"));
    }

    public static void showCreatingPhysicalDataErrorMessage() {
        VisMinerUI.showWarningMessageDialog(NbBundle.getMessage(VisMinerUI.class, (String)"Message_CreatingPhysicalDataErrorTitle"), NbBundle.getMessage(VisMinerUI.class, (String)"Message_CreatingPhysicalDataErrorText"));
    }

    public static void showNoDataStorageFoundMessage() {
        VisMinerUI.showErrorMessageDialog(NbBundle.getMessage(VisMinerUI.class, (String)"Message_NoDataStorageFoundTitle"), NbBundle.getMessage(VisMinerUI.class, (String)"Message_NoDataStorageFoundText"));
    }

    public static void showBuildingSessionErrorMessage() {
        VisMinerUI.showWarningMessageDialog(NbBundle.getMessage(VisMinerUI.class, (String)"Message_BuildingSessionErrorTitle"), NbBundle.getMessage(VisMinerUI.class, (String)"Message_BuildingSessionErrorText"));
    }

    public static void showInitProjectMessage() {
        VisMinerUI.showWarningMessageDialog(NbBundle.getMessage(VisMinerUI.class, (String)"Message_InitProjectWarningTitle"), NbBundle.getMessage(VisMinerUI.class, (String)"Message_InitProjectWarningText"));
    }

    public static int showYesNoQuestionDialog(String aTitle, String aQuestion) {
        return JOptionPane.showConfirmDialog(null, aTitle, aQuestion, 0);
    }

    public static boolean showDeleteSesionObjectConfirmDialog() {
        return VisMinerUI.showYesNoQuestionDialog(NbBundle.getMessage(VisMinerUI.class, (String)"Question_DeleteSessionObjectText"), NbBundle.getMessage(VisMinerUI.class, (String)"Question_DeleteSessionObjectTitle")) == 0;
    }

    public static void showSaveFailedMessage() {
        VisMinerUI.showWarningMessageDialog(NbBundle.getMessage(VisMinerUI.class, (String)"Message_SaveProjectErrorTitle"), NbBundle.getMessage(VisMinerUI.class, (String)"Message_SaveProjectErrorText"));
    }

    public static void showSaveSuccessfullMessage() {
        VisMinerUI.showInfoMessageDialog(NbBundle.getMessage(VisMinerUI.class, (String)"Message_SaveProjectScuccessTitle"), NbBundle.getMessage(VisMinerUI.class, (String)"Message_SaveProjectScuccessText"));
    }
}

