/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.ui.objectexplorer;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.ui.objectexplorer.nodes.NoProjectNode;
import org.tpo.visminerbase.ui.objectexplorer.nodes.ProjectNode;

public final class ObjectExplorerTopComponent
extends TopComponent
implements ExplorerManager.Provider,
PropertyChangeListener {
    private static ObjectExplorerTopComponent instance;
    private static final String PREFERRED_ID = "ObjectExplorerTopComponent";
    private final ExplorerManager explorerManager = new ExplorerManager();
    private BeanTreeView beanTreeView = new BeanTreeView();
    private JScrollPane jScrollPane1;

    private ObjectExplorerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ObjectExplorerTopComponent.class, (String)"CTL_ObjectExplorerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ObjectExplorerTopComponent.class, (String)"HINT_ObjectExplorerTopComponent"));
        VisMinerApplication.getInstance().addPropertyChangeListener(this);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.explorerManager.setRootContext((Node)this.getRootNode());
    }

    private AbstractNode getRootNode() {
        if (VisMinerApplication.getInstance().getProjectDirectory() == null) {
            return new NoProjectNode();
        }
        return new ProjectNode();
    }

    private void initComponents() {
        this.jScrollPane1 = this.beanTreeView;
        this.setLayout(new BorderLayout());
        this.add(this.jScrollPane1, "Center");
    }

    public static synchronized ObjectExplorerTopComponent getDefault() {
        if (instance == null) {
            instance = new ObjectExplorerTopComponent();
        }
        return instance;
    }

    public static synchronized ObjectExplorerTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(ObjectExplorerTopComponent.class.getName()).warning("Cannot find ObjectExplorerTopComponent component. It will not be located properly in the window system.");
            return ObjectExplorerTopComponent.getDefault();
        }
        if (win instanceof ObjectExplorerTopComponent) {
            return (ObjectExplorerTopComponent)win;
        }
        Logger.getLogger(ObjectExplorerTopComponent.class.getName()).warning("There seem to be multiple components with the 'ObjectExplorerTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ObjectExplorerTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == VisMinerApplication.getInstance() && "ProjectDirectoryProperty".equals(evt.getPropertyName())) {
            this.explorerManager.setRootContext((Node)this.getRootNode());
        }
        if (evt.getSource() == this.explorerManager && "selectedNodes".equals(evt.getPropertyName())) {
            this.setActivatedNodes(this.explorerManager.getSelectedNodes());
        }
    }

    public BeanTreeView getBeanTreeView() {
        return this.beanTreeView;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ObjectExplorerTopComponent.getDefault();
        }
    }
}

