/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.ui.objectexplorer.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerapi.datastorage.session.DataSetSessionObject;
import org.tpo.visminerapi.datastorage.session.SessionObject;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.actions.data.ReloadWithPhysicalDataAction;
import org.tpo.visminerbase.ui.objectexplorer.nodes.AbstractSessionObjectNode;
import org.tpo.visminerbase.ui.objectexplorer.nodes.DataSetSessionObjectNodeChildren;

public class DataSetSessionObjectNode
extends AbstractSessionObjectNode
implements PropertyChangeListener {
    private DataSetSessionObject dataSetSessionObject;
    private DataSet dataSet;
    private boolean dataSetSelected;

    public DataSetSessionObjectNode(DataSetSessionObject aDataSetSessionObject) {
        super((SessionObject)aDataSetSessionObject, (Children)new DataSetSessionObjectNodeChildren(aDataSetSessionObject), Lookups.singleton((Object)aDataSetSessionObject.getDataSet()));
        this.dataSetSessionObject = aDataSetSessionObject;
        this.dataSet = this.dataSetSessionObject.getDataSet();
        this.setIconBaseWithExtension("org/tpo/visminerbase/ui/icons/estat_16.png");
        this.setDisplayName(aDataSetSessionObject.getName());
        this.setShortDescription(aDataSetSessionObject.getDescription());
        VisMinerApplication.getInstance().addPropertyChangeListener(this);
    }

    public String getHtmlDisplayName() {
        if (this.isDataSetSelected()) {
            return "<b>" + this.getDisplayName() + "</b>";
        }
        return this.getDisplayName();
    }

    public Action[] getActions(boolean arg0) {
        ArrayList<ReloadWithPhysicalDataAction> theActions = new ArrayList<ReloadWithPhysicalDataAction>();
        if (VisMinerApplication.getInstance().getPhysicalDataSet().equals(this.dataSet)) {
            theActions.add(new ReloadWithPhysicalDataAction());
        }
        theActions.addAll(this.dataSet.getAdditionalAction());
        return theActions.toArray(new Action[0]);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedDataSet".equals(evt.getPropertyName())) {
            ApplicationLogger.logInfo(DataSetSessionObjectNode.class, (String)"DataSet selection property change caught!");
            if (this.dataSet.equals(VisMinerApplication.getInstance().getSelectedDataSet())) {
                this.setDataSetSelected(true);
                this.setIconBaseWithExtension("org/tpo/visminerbase/ui/icons/estat_16_hot.png");
            } else {
                this.setDataSetSelected(false);
                this.setIconBaseWithExtension("org/tpo/visminerbase/ui/icons/estat_16.png");
            }
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }

    public boolean isDataSetSelected() {
        return this.dataSetSelected;
    }

    public void setDataSetSelected(boolean dataSetSelected) {
        this.dataSetSelected = dataSetSelected;
    }
}

