/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.ui.objectexplorer.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.visminerapi.algorithm.Algorithm;
import org.tpo.visminerapi.datastorage.data.Filter;
import org.tpo.visminerapi.datastorage.session.FilterSessionObject;
import org.tpo.visminerapi.datastorage.session.SessionObject;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.actions.algorithm.RunAlgorithmAction;
import org.tpo.visminerbase.actions.session.DeleteSessionObjectAction;
import org.tpo.visminerbase.ui.objectexplorer.nodes.AbstractSessionObjectNode;
import org.tpo.visminerbase.ui.objectexplorer.nodes.FilterSessionObjectNodeChildren;

public class FilterSessionObjectNode
extends AbstractSessionObjectNode
implements PropertyChangeListener {
    private FilterSessionObject filterSessionObject;
    private boolean filtertSelected;
    private Filter filter;
    private Action[] actions;

    public FilterSessionObjectNode(FilterSessionObject aFilterSessionObject) {
        super((SessionObject)aFilterSessionObject, (Children)new FilterSessionObjectNodeChildren(aFilterSessionObject), Lookups.singleton((Object)aFilterSessionObject.getFilter()));
        this.filterSessionObject = aFilterSessionObject;
        this.filter = aFilterSessionObject.getFilter();
        this.setDisplayName(this.filterSessionObject.getName());
        this.setShortDescription(this.filterSessionObject.getDescription());
        this.setIconBaseWithExtension("org/tpo/visminerbase/ui/icons/level_16.png");
        VisMinerApplication.getInstance().addPropertyChangeListener(this);
    }

    public String getHtmlDisplayName() {
        if (this.isFiltertSelected()) {
            return "<b>" + this.getDisplayName() + "</b>";
        }
        return this.getDisplayName();
    }

    public Action[] getActions(boolean arg0) {
        ArrayList<AbstractAction> theActions = new ArrayList<AbstractAction>();
        if (this.filterSessionObject instanceof Algorithm) {
            theActions.add(new RunAlgorithmAction((Algorithm)this.filterSessionObject));
        }
        theActions.add(new DeleteSessionObjectAction((SessionObject)this.filterSessionObject));
        theActions.addAll(this.filter.getAdditionalAction());
        return theActions.toArray(new Action[0]);
    }

    public boolean isFiltertSelected() {
        return this.filtertSelected;
    }

    public void setFiltertSelected(boolean filtertSelected) {
        this.filtertSelected = filtertSelected;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedFilter".equals(evt.getPropertyName())) {
            ApplicationLogger.logInfo(FilterSessionObjectNode.class, (String)"Filter selection property change caught!");
            if (this.filter.equals(VisMinerApplication.getInstance().getSelectedFilter())) {
                this.setFiltertSelected(true);
                this.setIconBaseWithExtension("org/tpo/visminerbase/ui/icons/level_16_hot.png");
            } else {
                this.setFiltertSelected(false);
                this.setIconBaseWithExtension("org/tpo/visminerbase/ui/icons/level_16.png");
            }
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }
}

