/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.ui.objectexplorer.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.actions.file.ImportDataFileAction;
import org.tpo.visminerbase.actions.project.CloseProjectAction;
import org.tpo.visminerbase.actions.project.SaveProjectAction;
import org.tpo.visminerbase.ui.objectexplorer.nodes.ProjectNodeChildren;

public class ProjectNode
extends AbstractNode
implements PropertyChangeListener {
    private VisMinerApplication visMinerApplication = VisMinerApplication.getInstance();

    public ProjectNode() {
        super((Children)new ProjectNodeChildren());
        this.visMinerApplication.addPropertyChangeListener(this);
        this.setDisplayName(this.visMinerApplication.getProjectName());
        this.setShortDescription(this.visMinerApplication.getProjectDirectory().getName());
        this.setIconBaseWithExtension("org/tpo/visminerbase/ui/icons/book.png");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals((Object)this.visMinerApplication) && "projectName".equals(evt.getPropertyName())) {
            this.setDisplayName((String)evt.getNewValue());
        }
        if (evt.getSource().equals((Object)this.visMinerApplication) && "projectDescription".equals(evt.getPropertyName())) {
            this.setShortDescription((String)evt.getNewValue());
        }
        if (evt.getSource().equals((Object)this.visMinerApplication) && "physicalDataSet".equals(evt.getPropertyName())) {
            this.setChildren((Children)new ProjectNodeChildren());
        }
    }

    public Action[] getActions(boolean arg0) {
        return new Action[]{CallableSystemAction.get(ImportDataFileAction.class), new SaveProjectAction(), new CloseProjectAction()};
    }

    protected Sheet createSheet() {
        Sheet theSheet = Sheet.createDefault();
        Sheet.Set theSheetSet = Sheet.createPropertiesSet();
        try {
            PropertySupport.Reflection projectNameProperty = new PropertySupport.Reflection((Object)VisMinerApplication.getInstance(), String.class, "projectName");
            projectNameProperty.setName("projectName");
            projectNameProperty.setDisplayName(NbBundle.getMessage(ProjectNode.class, (String)"PROPERTY_ProjectName"));
            theSheetSet.put((Node.Property)projectNameProperty);
            PropertySupport.Reflection projectDescriptionProperty = new PropertySupport.Reflection((Object)VisMinerApplication.getInstance(), String.class, "projectDescription");
            projectDescriptionProperty.setName("projectDescription");
            projectDescriptionProperty.setDisplayName(NbBundle.getMessage(ProjectNode.class, (String)"PROPERTY_ProjectDesc"));
            theSheetSet.put((Node.Property)projectDescriptionProperty);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        theSheet.put(theSheetSet);
        return theSheet;
    }
}

