/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.visminerbase.ui.selectionpanel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.visminerapi.selection.DataSelection;
import org.tpo.visminerbase.VisMinerApplication;

final class SelectionPanelTopComponent
extends TopComponent
implements PropertyChangeListener {
    private VisMinerApplication visMinerApplication = VisMinerApplication.getInstance();
    private DataSelection dataSelection;
    private static SelectionPanelTopComponent instance;
    private static final String PREFERRED_ID = "SelectionPanelTopComponent";
    private JToggleButton addRecordsToggleButton;
    private JButton cancelSelectionButton;
    private JLabel jLabel1;
    private JLabel recordCountLabel;
    private JToggleButton removeRecordsToggleButton;
    private ButtonGroup selectionStateButtonGroup;

    private SelectionPanelTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SelectionPanelTopComponent.class, (String)"CTL_SelectionPanelTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SelectionPanelTopComponent.class, (String)"HINT_SelectionPanelTopComponent"));
        VisMinerApplication.getInstance().addPropertyChangeListener(this);
        this.updateAccordingToNoSelection();
    }

    private void initComponents() {
        this.selectionStateButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.recordCountLabel = new JLabel();
        this.addRecordsToggleButton = new JToggleButton();
        this.removeRecordsToggleButton = new JToggleButton();
        this.cancelSelectionButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"Po\u010det selektovan\u00fdch d\u00e1t:");
        this.recordCountLabel.setFont(new Font("Tahoma", 1, 11));
        Mnemonics.setLocalizedText((JLabel)this.recordCountLabel, (String)"-");
        this.selectionStateButtonGroup.add(this.addRecordsToggleButton);
        this.addRecordsToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/tpo/visminerbase/ui/icons/supportadd_24.png")));
        this.addRecordsToggleButton.setSelected(true);
        this.addRecordsToggleButton.setToolTipText("Prid\u00e1vanie z\u00e1znamov do selekcie");
        this.addRecordsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectionPanelTopComponent.this.addRecordsToggleButtonActionPerformed(evt);
            }
        });
        this.selectionStateButtonGroup.add(this.removeRecordsToggleButton);
        this.removeRecordsToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/tpo/visminerbase/ui/icons/supportdel_24.png")));
        this.removeRecordsToggleButton.setToolTipText("Odoberanie z\u00e1znamov zo selekcie");
        this.removeRecordsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectionPanelTopComponent.this.removeRecordsToggleButtonActionPerformed(evt);
            }
        });
        this.cancelSelectionButton.setIcon(new ImageIcon(this.getClass().getResource("/org/tpo/visminerbase/ui/icons/supportclose_24.png")));
        this.cancelSelectionButton.setToolTipText("Zru\u0161i\u0165 selekciu");
        this.cancelSelectionButton.setEnabled(false);
        this.cancelSelectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectionPanelTopComponent.this.cancelSelectionButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.addRecordsToggleButton, -2, 38, -2).addPreferredGap(0).add((Component)this.removeRecordsToggleButton, -2, 38, -2).addPreferredGap(0, 71, Short.MAX_VALUE).add((Component)this.cancelSelectionButton, -2, 38, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 64, Short.MAX_VALUE).add((Component)this.recordCountLabel))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.recordCountLabel)).addPreferredGap(0, 25, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.addRecordsToggleButton).add((Component)this.removeRecordsToggleButton).add((Component)this.cancelSelectionButton)).addContainerGap()));
    }

    private void addRecordsToggleButtonActionPerformed(ActionEvent evt) {
        this.visMinerApplication.setCurrentSelectionOperator(DataSelection.SelectionOperator.ADD_RECORDS);
    }

    private void removeRecordsToggleButtonActionPerformed(ActionEvent evt) {
        this.visMinerApplication.setCurrentSelectionOperator(DataSelection.SelectionOperator.REMOVE_RECORDS);
    }

    private void cancelSelectionButtonActionPerformed(ActionEvent evt) {
        this.visMinerApplication.setCurrentDataSelection(null);
    }

    public static synchronized SelectionPanelTopComponent getDefault() {
        if (instance == null) {
            instance = new SelectionPanelTopComponent();
        }
        return instance;
    }

    public static synchronized SelectionPanelTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(SelectionPanelTopComponent.class.getName()).warning("Cannot find SelectionPanelTopComponent component. It will not be located properly in the window system.");
            return SelectionPanelTopComponent.getDefault();
        }
        if (win instanceof SelectionPanelTopComponent) {
            return (SelectionPanelTopComponent)win;
        }
        Logger.getLogger(SelectionPanelTopComponent.class.getName()).warning("There seems to be multiple components with the 'SelectionPanelTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return SelectionPanelTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("InitializedProperty".equals(evt.getPropertyName())) {
            if (VisMinerApplication.getInstance().isInitialized()) {
                this.visMinerApplication.removePropertyChangeListener(this);
                this.visMinerApplication.addPropertyChangeListener(this);
                this.visMinerApplication.setCurrentSelectionOperator(DataSelection.SelectionOperator.ADD_RECORDS);
            } else {
                this.visMinerApplication.removePropertyChangeListener(this);
            }
        }
        if ("currentSelection".equals(evt.getPropertyName())) {
            ApplicationLogger.logInfo(this.getClass(), (String)"CurrentSelection property has changed!", null);
            if (evt.getNewValue() != null) {
                if (this.dataSelection != null) {
                    this.dataSelection.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.dataSelection = this.visMinerApplication.getCurrentDataSelection();
                this.dataSelection.addPropertyChangeListener((PropertyChangeListener)this);
                this.updateAccordingToSelection(this.dataSelection);
                this.cancelSelectionButton.setEnabled(true);
            } else {
                this.updateAccordingToNoSelection();
                this.cancelSelectionButton.setEnabled(false);
            }
        }
        if ("selectedRecordCount".equals(evt.getPropertyName())) {
            ApplicationLogger.logInfo(this.getClass(), (String)"Selected record count property has changed!", null);
            this.updateAccordingToSelection(this.dataSelection);
        }
        if ("currentSelectionOperator".equals(evt.getPropertyName())) {
            if (DataSelection.SelectionOperator.ADD_RECORDS.equals((Object)this.visMinerApplication.getCurrentSelectionOperator())) {
                this.addRecordsToggleButton.setSelected(true);
            }
            if (DataSelection.SelectionOperator.REMOVE_RECORDS.equals((Object)this.visMinerApplication.getCurrentSelectionOperator())) {
                this.removeRecordsToggleButton.setSelected(true);
            }
        }
    }

    private void updateAccordingToNoSelection() {
        this.recordCountLabel.setText("-");
        this.repaint();
    }

    private void updateAccordingToSelection(DataSelection theSelection) {
        this.recordCountLabel.setText(Integer.toString(theSelection.getSelectedRecordCount()));
        this.repaint();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return SelectionPanelTopComponent.getDefault();
        }
    }
}

