/*
 * Copyright (c) 1998 by Sun Microsystems, Inc.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.jimi.core.util;

import com.sun.jimi.core.*;
import com.sun.jimi.core.raster.*;
import java.awt.image.*;

/**
 * Class holding image data for the image used to "stamp" new JimiImages in
 * trial versions of Jimi.
 * @author  Luke Gorrie
 * @version $Revision: 1.2 $ $Date: 1999/01/20 10:50:06 $
 */
public class StampImage
{
	public static final int width = 46;
	public static final int height = 30;

	private static IntRasterImage image;

	public static IntRasterImage getRasterImage()
	{
		try {
			if (image != null) {
				return image;
			}
			image =
				new MemoryJimiImageFactory().createIntRasterImage(width, height, ColorModel.getRGBdefault());
			image.setRectangle(0, 0, width, height, pixels, 0, width);
			image.setFinished();
		}
		catch (Exception e)
		{
			// never happens - memory based image
		}
		return image;
	}

	public static final int[] pixels =
{
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffeffaef,
	0xffbfeabf,
	0xff8fda8f,
	0xff7fd47f,
	0xff40bf40,
	0xff40bf40,
	0xff30ba30,
	0xff00aa00,
	0xff00aa00,
	0xff00aa00,
	0xff00aa00,
	0xff00aa00,
	0xff00aa00,
	0xff00aa00,
	0xff10af10,
	0xff40bf40,
	0xff40bf40,
	0xff70cf70,
	0xff7fd47f,
	0xffbfeabf,
	0xffeffaef,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffbfeabf,
	0xff8fda8f,
	0xff50c550,
	0xff20b520,
	0xff00aa00,
	0xff40bf40,
	0xff60ca60,
	0xff7fd47f,
	0xff9fdf9f,
	0xffbfeabf,
	0xffbfeabf,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffdff4df,
	0xffbfeabf,
	0xffbfeabf,
	0xff7fd47f,
	0xff70cf70,
	0xff40bf40,
	0xff00aa00,
	0xff20b520,
	0xff60ca60,
	0xff9fdf9f,
	0xffeffaef,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffdff4df,
	0xff9fdf9f,
	0xff50c550,
	0xff10af10,
	0xff20b520,
	0xff60ca60,
	0xff9fdf9f,
	0xffcfefcf,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffbfeabf,
	0xff8fda8f,
	0xff40bf40,
	0xff00aa00,
	0xff50c550,
	0xff9fdf9f,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffeffaef,
	0xff9fdf9f,
	0xff30ba30,
	0xff00aa00,
	0xff40bf40,
	0xff8fda8f,
	0xffdff4df,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffeffaef,
	0xff8fda8f,
	0xff30ba30,
	0xff10af10,
	0xff7fd47f,
	0xffeffaef,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffeffaef,
	0xff7fd47f,
	0xff10af10,
	0xff40bf40,
	0xff9fdf9f,
	0xff70cf70,
	0xff60ca60,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffbfeabf,
	0xff40bf40,
	0xff10af10,
	0xffffffff,
	0xffffffff,
	0xffafe4af,
	0xff10af10,
	0xff40bf40,
	0xffbfeabf,
	0xffffffff,
	0xffffffff,
	0xffeffaef,
	0xff10af10,
	0xffdff4df,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff3030ff,
	0xff3030ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffdff4df,
	0xffffffff,
	0xff60ca60,
	0xff10af10,
	0xffbfeabf,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff7fd47f,
	0xff60ca60,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffafafff,
	0xff2020ff,
	0xff6060ff,
	0xff9f9fff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffdfdfff,
	0xff7f7fff,
	0xffcfcfff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff60ca60,
	0xff30ba30,
	0xffeffaef,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffdff4df,
	0xff00aa00,
	0xffeffaef,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff6060ff,
	0xff7070ff,
	0xffafafff,
	0xff4040ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffefefff,
	0xff3030ff,
	0xff4040ff,
	0xff3030ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffdfdfff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffcf6060,
	0xfff1cfcf,
	0xffffffff,
	0xff60ca60,
	0xffeffaef,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff60ca60,
	0xff7fd47f,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff3030ff,
	0xffbfbfff,
	0xffefefff,
	0xff0000ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff7070ff,
	0xff4040ff,
	0xffffffff,
	0xff0000ff,
	0xffffffff,
	0xffffffff,
	0xffefefff,
	0xff4040ff,
	0xff1010ff,
	0xff7070ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xfffaefef,
	0xffc54040,
	0xffe29f9f,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffbfeabf,
	0xff10af10,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffdd8f8f,
	0xfff5dfdf,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff0000ff,
	0xffefefff,
	0xffffffff,
	0xff2020ff,
	0xffbfbfff,
	0xffffffff,
	0xffdfdfff,
	0xff0000ff,
	0xffdfdfff,
	0xffffffff,
	0xff3030ff,
	0xffbfbfff,
	0xffefefff,
	0xff3030ff,
	0xff6060ff,
	0xffefefff,
	0xff4040ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff3030ff,
	0xffbfbfff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff30ba30,
	0xff9fdf9f,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffb20000,
	0xffd87f7f,
	0xffffffff,
	0xffffffff,
	0xffdfdfff,
	0xff2020ff,
	0xffffffff,
	0xffffffff,
	0xff5050ff,
	0xff7f7fff,
	0xffffffff,
	0xff6060ff,
	0xff6060ff,
	0xffffffff,
	0xffffffff,
	0xff4040ff,
	0xffbfbfff,
	0xff7070ff,
	0xff3030ff,
	0xffffffff,
	0xffbfbfff,
	0xff4040ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff6060ff,
	0xff5050ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff8fda8f,
	0xff40bf40,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffafafff,
	0xffbfbfff,
	0xffffffff,
	0xffffffff,
	0xffbfbfff,
	0xff4040ff,
	0xffffffff,
	0xffffffff,
	0xff7f7fff,
	0xff5050ff,
	0xffdfdfff,
	0xff0000ff,
	0xffdfdfff,
	0xffffffff,
	0xffffffff,
	0xff4040ff,
	0xff7f7fff,
	0xff1010ff,
	0xffdfdfff,
	0xffffffff,
	0xff7f7fff,
	0xff6060ff,
	0xffffffff,
	0xffffffff,
	0xff9f9fff,
	0xff2020ff,
	0xffefefff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffeffaef,
	0xff00aa00,
	0xffdff4df,
	0xffffffff,
	0xffffffff,
	0xff7f7fff,
	0xff7070ff,
	0xffffffff,
	0xffffffff,
	0xff8f8fff,
	0xff7070ff,
	0xffffffff,
	0xffffffff,
	0xffbfbfff,
	0xff3030ff,
	0xff7f7fff,
	0xff6060ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff4040ff,
	0xff1010ff,
	0xff7f7fff,
	0xffffffff,
	0xffffffff,
	0xff3030ff,
	0xff9f9fff,
	0xffffffff,
	0xffcfcfff,
	0xff0000ff,
	0xffcfcfff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff50c550,
	0xff8fda8f,
	0xffffffff,
	0xffffffff,
	0xffbfbfff,
	0xff2020ff,
	0xffffffff,
	0xffffffff,
	0xff7f7fff,
	0xff7f7fff,
	0xffffffff,
	0xffffffff,
	0xffefefff,
	0xff0000ff,
	0xff1010ff,
	0xffbfbfff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff4040ff,
	0xff1010ff,
	0xffefefff,
	0xffffffff,
	0xffdfdfff,
	0xff0000ff,
	0xffefefff,
	0xffdfdfff,
	0xff1010ff,
	0xff8f8fff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff9fdf9f,
	0xff30ba30,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff0000ff,
	0xffdfdfff,
	0xffffffff,
	0xff6060ff,
	0xff9f9fff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff2020ff,
	0xff3030ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff3030ff,
	0xff7f7fff,
	0xffffffff,
	0xffffffff,
	0xff7070ff,
	0xff6060ff,
	0xffefefff,
	0xff3030ff,
	0xff6060ff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffeffaef,
	0xff00aa00,
	0xffdff4df,
	0xffffffff,
	0xffffffff,
	0xff5050ff,
	0xff9f9fff,
	0xffffffff,
	0xff4040ff,
	0xffbfbfff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff6060ff,
	0xff8f8fff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff7f7fff,
	0xffdfdfff,
	0xffffffff,
	0xffffffff,
	0xff1010ff,
	0xffcfcfff,
	0xff4040ff,
	0xff3030ff,
	0xffefefff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff50c550,
	0xff8fda8f,
	0xffffffff,
	0xffffffff,
	0xff8f8fff,
	0xff5050ff,
	0xffffffff,
	0xff4040ff,
	0xffbfbfff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff8f8fff,
	0xff4040ff,
	0xff6060ff,
	0xff3030ff,
	0xffefefff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff9fdf9f,
	0xff40bf40,
	0xffffffff,
	0xffffffff,
	0xffdfdfff,
	0xff0000ff,
	0xffefefff,
	0xff1010ff,
	0xffffffff,
	0xffffffff,
	0xffe0e0ff,
	0xff8f8fff,
	0xffffffff,
	0xffffffff,
	0xffa9f3a9,
	0xffffffff,
	0xffafafff,
	0xffafafff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff6060ff,
	0xff1010ff,
	0xff3030ff,
	0xffefefff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffdff4df,
	0xff00aa00,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff4040ff,
	0xff8f8fff,
	0xff0000ff,
	0xffffffff,
	0xffffffff,
	0xffafafff,
	0xffffffff,
	0xffafafff,
	0xffe0ffe0,
	0xffe0ffe0,
	0xffdfdfff,
	0xffe0e0ff,
	0xff9f9fff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffdfdfff,
	0xffafafff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff20b520,
	0xffbfeabf,
	0xffffffff,
	0xffffffff,
	0xffbfbfff,
	0xff1010ff,
	0xff0000ff,
	0xffffffff,
	0xffffffff,
	0xffafafff,
	0xff9f9fff,
	0xffffffff,
	0xffa9f3a9,
	0xffffffff,
	0xffc5c5ff,
	0xffffffff,
	0xffafafff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff50c550,
	0xff8fda8f,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff7f7fff,
	0xff7070ff,
	0xffffffff,
	0xffffffff,
	0xffc5c5ff,
	0xffc5c5ff,
	0xffffffff,
	0xffa9f3a9,
	0xffffffff,
	0xffffffff,
	0xffafafff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff7fd47f,
	0xff7fd47f,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffa9f3a9,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffcfefcf,
	0xffeffaef,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff9fdf9f,
	0xff50c550,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffa9f3a9,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff40bf40,
	0xffbfeabf,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffbfeabf,
	0xff40bf40,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffa9f3a9,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff40bf40,
	0xffafe4af,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffbfeabf,
	0xff40bf40,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffa9f3a9,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff70cf70,
	0xff7fd47f,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff8fda8f,
	0xff7fd47f,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffa9f3a9,
	0xffa9f3a9,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffafe4af,
	0xff20b520,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff60ca60,
	0xff9fdf9f,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xff20b520,
	0xff9fdf9f,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffdff4df,
	0xff10af10,
	0xffeffaef,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xfff7a9a9,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffc5c5,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffbfeabf,
	0xff00aa00,
	0xff8fda8f,
	0xffeffaef,
	0xffffffff,
	0xffafe4af,
	0xff20b520,
	0xffafe4af,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xfff7a9a9,
	0xfff7a9a9,
	0xfff7a9a9,
	0xfff7a9a9,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffcfefcf,
	0xff50c550,
	0xff00aa00,
	0xff00aa00,
	0xff50c550,
	0xffcfefcf,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff
};



	public static byte[] packedPixels;

	static
	{
		try {
			int rowWidth = (width + 7) / 8;
			packedPixels = new byte[rowWidth * height];

			for (int row = 0; row < height; row++) {
				JimiUtil.packPixels(pixels, row * width, packedPixels, row * rowWidth, width);
			}
		}
		catch (Exception e) {
		}
	}

public static byte[] mapPalette(IndexColorModel model)
{
	int modelSize = model.getMapSize();

	byte[] mapping = new byte[palette.length];
	int[] guesses = new int[palette.length];
	int[] modelElements = new int[modelSize];
	for (int i = 0; i < modelSize; i++) {
		modelElements[i] = model.getRGB(i);
	}

	for (int modelIndex = 0; modelIndex < modelSize; modelIndex++) {
		for (int paletteIndex = 0; paletteIndex < mapping.length; paletteIndex++) {
			if (betterMatch(palette[paletteIndex], guesses[paletteIndex], modelElements[modelIndex])) {
				guesses[paletteIndex] = modelElements[modelIndex];
				mapping[paletteIndex] = (byte)modelIndex;
			}
		}
	}
	return mapping;
}

/**
 * Decide which of two approximations of an RGB value is most accurate.
 */
private static boolean betterMatch(int target, int guess1, int guess2)
{
	int a = guess1, b = guess2;

	int targetRed = (target >>> 16) & 0xff;
	int targetGreen = (target >>> 8) & 0xff;
	int targetBlue = target & 0xff;

	int diff1 =
		abs(targetRed   - ((guess1 >>> 16) & 0xff)) +
		abs(targetGreen - ((guess1 >>> 8)  & 0xff)) +
		abs(targetBlue  -   guess1         & 0xff);

	int diff2 =
		abs(targetRed   - ((guess2 >>> 16) & 0xff)) +
		abs(targetGreen - ((guess2 >>> 8)  & 0xff)) +
		abs(targetBlue  -   guess2         & 0xff);

	return diff2 < diff1;
}

private static final int abs(int val)
{
	return val < 0 ? -val : val;
}

public static int palette[] = {
 0xff1919ff,
 0xff5e5eff,
 0xff10af10,
 0xff40bf40,
 0xff68cc68,
 0xffb20000,
 0xffc54040,
 0xffcf6060,
 0xffd87f7f,
 0xffacacff,
 0xffa8e5a8,
 0xffdd8f8f,
 0xffe29f9f,
 0xfff7a9a9,
 0xfffdfdfe
};
public static byte[] bytePixels =
{
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)10,
(byte)4,
(byte)3,
(byte)3,
(byte)2,
(byte)2,
(byte)2,
(byte)2,
(byte)2,
(byte)2,
(byte)2,
(byte)2,
(byte)2,
(byte)3,
(byte)3,
(byte)4,
(byte)4,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)10,
(byte)4,
(byte)2,
(byte)2,
(byte)3,
(byte)4,
(byte)4,
(byte)10,
(byte)10,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)10,
(byte)4,
(byte)4,
(byte)3,
(byte)2,
(byte)2,
(byte)4,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)4,
(byte)2,
(byte)2,
(byte)4,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)10,
(byte)3,
(byte)2,
(byte)4,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)2,
(byte)2,
(byte)3,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)2,
(byte)2,
(byte)4,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)2,
(byte)3,
(byte)10,
(byte)4,
(byte)4,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)3,
(byte)2,
(byte)14,
(byte)14,
(byte)10,
(byte)2,
(byte)3,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)2,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)2,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)4,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)9,
(byte)0,
(byte)1,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)2,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)2,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)9,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)1,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)7,
(byte)14,
(byte)14,
(byte)4,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)4,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)9,
(byte)14,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)14,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)0,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)6,
(byte)12,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)2,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)11,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)14,
(byte)14,
(byte)0,
(byte)9,
(byte)14,
(byte)14,
(byte)0,
(byte)14,
(byte)14,
(byte)0,
(byte)9,
(byte)14,
(byte)0,
(byte)1,
(byte)14,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)2,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)5,
(byte)8,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)14,
(byte)1,
(byte)1,
(byte)14,
(byte)14,
(byte)1,
(byte)9,
(byte)1,
(byte)0,
(byte)14,
(byte)9,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)3,
(byte)14,
(byte)14,
(byte)14,
(byte)9,
(byte)9,
(byte)14,
(byte)14,
(byte)9,
(byte)1,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)14,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)0,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)14,
(byte)14,
(byte)9,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)2,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)14,
(byte)14,
(byte)9,
(byte)1,
(byte)14,
(byte)14,
(byte)9,
(byte)0,
(byte)1,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)0,
(byte)1,
(byte)14,
(byte)14,
(byte)0,
(byte)9,
(byte)14,
(byte)14,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)10,
(byte)14,
(byte)14,
(byte)9,
(byte)0,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)0,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)14,
(byte)14,
(byte)0,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)2,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)14,
(byte)14,
(byte)1,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)1,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)14,
(byte)0,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)2,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)9,
(byte)14,
(byte)1,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)14,
(byte)1,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)10,
(byte)14,
(byte)14,
(byte)9,
(byte)1,
(byte)14,
(byte)1,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)9,
(byte)1,
(byte)1,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)3,
(byte)14,
(byte)14,
(byte)14,
(byte)0,
(byte)14,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)9,
(byte)14,
(byte)14,
(byte)10,
(byte)14,
(byte)9,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)0,
(byte)0,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)2,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)9,
(byte)0,
(byte)14,
(byte)14,
(byte)9,
(byte)14,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)2,
(byte)10,
(byte)14,
(byte)14,
(byte)9,
(byte)0,
(byte)0,
(byte)14,
(byte)14,
(byte)9,
(byte)9,
(byte)14,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)1,
(byte)1,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)14,
(byte)14,
(byte)9,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)4,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)4,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)3,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)3,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)3,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)3,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)4,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)4,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)2,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)2,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)2,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)13,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)10,
(byte)2,
(byte)10,
(byte)14,
(byte)14,
(byte)10,
(byte)2,
(byte)10,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)13,
(byte)13,
(byte)13,
(byte)13,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)4,
(byte)2,
(byte)2,
(byte)4,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14,
(byte)14
};

}

