package histogram;

import java.awt.*;
import java.util.Arrays;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;
import java.awt.datatransfer.*;

import GUI.FileChooser;
import GUI.internalFrame;
import GUI.mainWindow;
import ij.*;
import ij.process.*;
import ij.measure.*;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Filler;
import ij.plugin.filter.PlugInFilter;
import ij.text.TextWindow;
import ij.gui.*;

public class HorizontalHistogram {
	
	ImagePlus imp;
	ImageProcessor ip, nip, nip2;
	ImagePlus imp2;
	public static internalFrame[] intFrameHorizHistogram;
	public int[][] hist;
	int numberResult;
	boolean draw;
	
	final int scale = 20;
	
	public HorizontalHistogram(ImagePlus imp, ImageProcessor ip, boolean hor, int numberResult, boolean draw){
		this.imp = imp;
		this.ip = ip;
		this.numberResult = numberResult;
		this.draw = draw;
		
        ImageStack stack = imp.getStack();
        int slices = imp.getStackSize();
        ip = stack.getProcessor(slices);	
		
		if (hor) drawHistogram();
		else drawHistogram2();
	}
	
	private void drawHistogram(){
		
		ImagePlus imp2 = NewImage.createImage ("Threshold", ip.getWidth(), ip.getHeight(), 5, 8, NewImage.FILL_WHITE);
		nip2 = imp2.getProcessor();
		setHistogram();
		
		if (draw) {		
		
			mainWindow.intFrameArrayList.add(new internalFrame("Horizontal Projection Profile" , FileChooser.number, imp2, ip.getWidth(), ip.getHeight(), hist, numberResult, 1));
			try {
				//mainWindow.intFrame[FileChooser.number].setSelected(true);
				((internalFrame)(mainWindow.intFrameArrayList.get(FileChooser.number))).setSelected(true);
			} catch(Exception e){
				System.out.println("Chyba");
			}	
			++FileChooser.number;
		}
	}
	
	public void setHistogram(){

		hist = new int[1][ip.getHeight()];
		Arrays.fill(hist[0], 0);
		for (int i = 0; i < ip.getHeight(); i++) {
			for (int j = 0; j < ip.getWidth(); j++) {
				if (ip.getPixelValue(j, i) == 0) {
					hist[0][i] = hist[0][i] + 1;
					nip2.putPixelValue(hist[0][i], i, 0);
				}
			}
		}
	}	
	
	//projection profile for chunks
	
	private void drawHistogram2(){
		
		imp2 = NewImage.createImage("Threshold", (ip.getWidth() / scale), ip.getHeight(), 5, 8, NewImage.FILL_WHITE);
		nip = imp2.getProcessor();
		ImagePlus imp3 = NewImage.createImage("Threshold", ip.getWidth(), ip.getHeight(), 5, 8, NewImage.FILL_WHITE);
		nip2 = imp3.getProcessor();
		
		hist = new int[scale][ip.getHeight()];
		for (int j = 0; j < hist.length; j++)
			Arrays.fill(hist[j], 0);
		
		for (int j = 0; j < scale; j++)
			setHistogram2(j);
		
		if (draw) {
		
			mainWindow.intFrameArrayList.add(new internalFrame("Horizontal Projection Profile" , FileChooser.number, imp3, ip.getWidth(), ip.getHeight(), hist, numberResult, 1));
			try {
				//mainWindow.intFrame[FileChooser.number].setSelected(true);
				((internalFrame)(mainWindow.intFrameArrayList.get(FileChooser.number))).setSelected(true);
			} catch(Exception e){
				System.out.println("Chyba");
			}	
			++FileChooser.number;
		}
	}	
	
	public ImagePlus getImg(){
		return imp2;
	}
	
	public ImageProcessor getIp(){
		return nip2;
	}
	
	//chcem detekovat dlhe cierne ciary aby som vysekla pismo 
	public int[] findSeparateLines(){
		int[] max = new int[2];
		for (int i = 0; i < hist.length; i++) {
			for (int j = 0; j < hist[i].length; j++) {
				if (hist[i][j] > 400) {
					if ( (j > 100) && (j < 700) ) {
						max[0] = j;
			//			System.out.println("hist "+hist[i][j]);
			//			System.out.println("hist j "+j);
					} else if (j > 760) {
						max[1] = j;
			//			System.out.println("hist "+hist[i][j]);
			//			System.out.println("hist j "+j);
					}
				}
			}
		}
		
		return max;
	}
	
	public void setHistogram2(int i){

		for (int j = 0; j < ip.getHeight(); j++)
			for (int k = (ip.getWidth() / scale * i); k < ( (ip.getWidth() / scale * i) + nip.getWidth() ); k++) {
					if (ip.getPixelValue(k, j) == 0) {
						hist[i][j] = hist[i][j] + 1;
						nip.putPixelValue(hist[i][j],j, 0);
						nip2.putPixelValue(hist[i][j] + (ip.getWidth() / scale * i),j, 0);		
						//nip.putPixelValue(k, j, 0);//ip.getPixelValue(k, j));
					}
			}
	}
	
	protected void finalize() throws Throwable {
	    try {
	        //close();        // close open files
	    } finally {
	        super.finalize();
	        System.out.println("horiz hist has been finalized.");
	    }
	}		

}
