package GUI;
import histogram.HorizontalHistogram;
import ij.ImagePlus;
import ij.process.ImageProcessor;

import java.awt.*;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.*;

import noise.IsolatedPixelsRemoval_;
import noise.RegionRemoval_;
import representation.Dilatation;
import representation.Moore;
import representation.SlantVertiPro;
import round.Roundness;
import segmentation.BaseLines;
import segmentation.Line4;
import segmentation.Separation;
import sizeNormalization.MyAlgorithm;
import thresholding.Entropy_Threshold;
import thresholding.OtsuThresholding_;
import clustering.Hierarchical;

import comparison.SaveHabitualData;

import filter.Average;
public class JProgressBarAll extends JFrame {
	
protected int m_min = 0;
protected int m_max = 100;
protected int m_counter = 0;
public static JProgressBar m_progress;
protected boolean m_stringPainted = false;

private static ImageProcessor ip;
private static ImagePlus imp, impOtsu;

private static OtsuThresholding_ otsu; 
private static HorizontalHistogram horizHist;
private static Average averageFilter;
private static Entropy_Threshold entropy;
private static Line4 lineSeg4;
private static Dilatation dilatation;
private static IsolatedPixelsRemoval_ ipr;
private static RegionRemoval_ rr;
private static Separation sep;
private static Moore moore;
private static MyAlgorithm norm;
private static SlantVertiPro slant;
private static SaveHabitualData habitData;
private static BaseLines baselines;
private static Hierarchical hierarchical;

static int[] numberRes;
static int[] numberFrame;
static boolean noneOpenImage;
static ArrayList[] habit;
static ArrayList diffHabit;
static int j;
static boolean noDisplay;
static int count;
static String writers;
static boolean notSame;
static String explain;
static Result result;
static int type;
static double[] cluster;
static int[] numberResult;
static double som;
static ArrayList habit1;
static ArrayList habit2;

static boolean skoncil = false;

static int numbOpIm;

public static void runGraphemeSegm(int numberResult, ImagePlus imp){
	
	imp = runSlantDet(numberResult, false, false, false, true, imp);
	ip = imp.getProcessor();
	
	/////words and segments of words and graphemes
	moore = new Moore(imp, imp, ip, numberResult, true);
	moore.run(false);
	moore.saveGraphemes(30, moore.separateGrapheme(moore.separateWords(true, false)));

	//spustim gargabe collector
	System.runFinalization();
	System.gc();
}	


public static void runWordSegm(int numberResult, ImagePlus imp){
	
	imp = runSlantDet(numberResult, false, false, false, true, imp);
	
	ip = imp.getProcessor();
	
	/////words and segments of words and graphemes
	moore = new Moore(imp, imp, ip, numberResult, true);
	moore.run(true);
	moore.separateWords(false, true);
	imp = moore.getImg();
	ip = moore.getIp();	
	
	//spustim gargabe collector
	System.runFinalization();
	System.gc();
}	


public static ImagePlus runSlantDet(int numberResult, boolean otsuThres, boolean lineSegm, boolean lineSep, boolean slantBool, ImagePlus imp){
	
	imp = runLineSegm(numberResult, otsuThres, lineSegm, lineSep, imp);
	
	ip = imp.getProcessor();
	
	//slant correction
	slant = new SlantVertiPro(imp, ip, numberResult, slantBool, false);
	imp = slant.getImg();
	ip = slant.getIp();	

	//spustim gargabe collector
	System.runFinalization();
	System.gc();
	
	return imp;
}

public static ImagePlus runLineSegm(int numberResult, boolean otsuThres, boolean lineSegm, boolean lineSep, ImagePlus imp){
	
	ip = imp.getProcessor();
	
	//otsu algorithm
	otsu = new OtsuThresholding_(imp.getTitle(), numberResult, otsuThres, false); 
	otsu.run(ip.convertToByte(false));
	otsu.setup("about", imp);
	imp = otsu.getImg();
	ip = otsu.getIp();	
	impOtsu = otsu.getImg();
	
	System.runFinalization();
	System.gc();
	
	//dilatation
	dilatation = new Dilatation(imp, ip, numberResult, false);
	dilatation.run();
	imp = dilatation.getImg();
	ip = dilatation.getIp();	
	
	System.runFinalization();
	System.gc();
	
	//projection profile of chunks
	horizHist = new HorizontalHistogram(imp, ip, false, numberResult, false);
	imp = horizHist.getImg();
	ip = horizHist.getIp();
	
	System.runFinalization();
	System.gc();
	
	//average filter
	averageFilter = new Average(imp, ip, numberResult, false);
	averageFilter.run3();
	imp = averageFilter.getImg();
	ip = averageFilter.getIp();
	
	System.runFinalization();
	System.gc();
	
	///entropy
	entropy = new Entropy_Threshold(imp.getTitle(), numberResult, false); 
	entropy.setup("assa", imp);
	entropy.run(ip.convertToByte(false));
	imp = entropy.getImg();
	ip = entropy.getIp();
	
	System.runFinalization();
	System.gc();
	
	//Region removal
	rr = new RegionRemoval_(imp, ip, numberResult, false);
	rr.run();
	imp = rr.getImg();
	ip = rr.getIp();
	
	System.runFinalization();
	System.gc();
	
	//Isolated Pixels Removal
	ipr = new IsolatedPixelsRemoval_(imp, ip, numberResult, false);
	ipr.run();
	imp = ipr.getImg();
	ip = ipr.getIp();
	
	System.runFinalization();
	System.gc();
	
	//line segmentation
	lineSeg4 = new Line4(imp, ip, impOtsu, numberResult, lineSegm, false);
	lineSeg4.run();
	imp = lineSeg4.getImg();
	ip = lineSeg4.getIp();
	
	System.runFinalization();
	System.gc();
	
	//line separation
	sep = new Separation(imp, ip, impOtsu, numberResult, lineSep, false);
	sep.run();
	imp = sep.getImg();
	ip = sep.getIp();	
	
	//spustim gargabe collector
	System.runFinalization();
	System.gc();
	
	return imp;
}


public static void runProces2(int numberResult, boolean image, ImagePlus imp){
					
		imp = runLineSegm(numberResult, false, false, false, imp);
		ImagePlus impSeparLines = imp;
		ip = imp.getProcessor();

		//slant correction
		slant = new SlantVertiPro(imp, ip, numberResult, false, false);
		imp = slant.getImg();
		ip = slant.getIp();	
		impSeparLines = imp;
		
		System.runFinalization();
		System.gc();
		
		/////words and segments of words and graphemes
		moore = new Moore(impSeparLines, imp, ip, numberResult, false);
		moore.run(false);
		moore.saveGraphemes(30, moore.separateGrapheme(moore.separateWords(true, false)));
		
		
		System.runFinalization();
		System.gc();
		
		//DALSI KROK - BASELINES

		//horizontal projection profile
		horizHist = new HorizontalHistogram(imp, ip, true, numberResult, false);
		imp = horizHist.getImg();
		ip = horizHist.getIp();
		
		System.runFinalization();
		System.gc();	

		//average filter
		averageFilter = new Average(imp, ip, numberResult, false);
		averageFilter.run2();
		imp = averageFilter.getImg();
		ip = averageFilter.getIp();
		
		System.runFinalization();
		System.gc();	

		///entropy
		entropy = new Entropy_Threshold(imp.getTitle(), numberResult, false); 
		entropy.setup("assa", imp);
		entropy.run(ip.convertToByte(false));
		imp = entropy.getImg();
		ip = entropy.getIp();
		
		System.runFinalization();
		System.gc();	

		//Region removal
		rr = new RegionRemoval_(imp, ip, numberResult, false);
		rr.run();
		imp = rr.getImg();
		ip = rr.getIp();
		
		System.runFinalization();
		System.gc();	

		//Isolated Pixels Removal
		ipr = new IsolatedPixelsRemoval_(imp, ip, numberResult, false);
		ipr.run();
		imp = ipr.getImg();
		ip = ipr.getIp();		
		
		System.runFinalization();
		System.gc();	

		///baselines
		baselines = new BaseLines(imp, ip,  impSeparLines, numberResult, image, false);
		baselines.run();
		imp = baselines.getImg();
		ip = baselines.getIp();		
		
		System.runFinalization();
		System.gc();
			
		//SAVE DATA
		habitData = new SaveHabitualData(numberResult);
		habitData.run();
		
		//spustim gargabe collector
		System.runFinalization();
		System.gc();
		
	}

//////////////////////////////////////////////////////////////////////////////////////
public static void runProces(int numberResult, boolean image, ImagePlus imp){

	imp = runLineSegm(numberResult, false, false, false, imp);
	ImagePlus impSeparLines = imp;
	ip = imp.getProcessor();
	
	//slant correction
	//WHILE CYKLUS
	slant = new SlantVertiPro(imp, ip, numberResult, false, false);
	imp = slant.getImg();
	ip = slant.getIp();	
	impSeparLines = imp;
	
	System.runFinalization();
	System.gc();	
	
	/////words and segments of words and graphemes
	//WHILE CYKLUS
	moore = new Moore(impSeparLines, imp, ip, numberResult, false);
	moore.run(false);
	moore.separateWords(true, false);		

	System.runFinalization();
	System.gc();	
	
	
	//DALSI KROK - BASELINES

	//horizontal projection profile
	horizHist = new HorizontalHistogram(imp, ip, true, numberResult, false);
	imp = horizHist.getImg();
	ip = horizHist.getIp();
	
	System.runFinalization();
	System.gc();	

	//average filter
	averageFilter = new Average(imp, ip, numberResult, false);
	averageFilter.run2();
	imp = averageFilter.getImg();
	ip = averageFilter.getIp();
	
	System.runFinalization();
	System.gc();	

	///entropy
	entropy = new Entropy_Threshold(imp.getTitle(), numberResult, false); 
	entropy.setup("assa", imp);
	entropy.run(ip.convertToByte(false));
	imp = entropy.getImg();
	ip = entropy.getIp();
	
	System.runFinalization();
	System.gc();	

	//Region removal
	rr = new RegionRemoval_(imp, ip, numberResult, false);
	rr.run();
	imp = rr.getImg();
	ip = rr.getIp();
	
	System.runFinalization();
	System.gc();	

	//Isolated Pixels Removal
	ipr = new IsolatedPixelsRemoval_(imp, ip, numberResult, false);
	ipr.run();
	imp = ipr.getImg();
	ip = ipr.getIp();	
	
	System.runFinalization();
	System.gc();	

	///baselines
	baselines = new BaseLines(imp, ip,  impSeparLines, numberResult, true, false);
	baselines.run();
	imp = baselines.getImg();
	ip = baselines.getIp();		
	
	//System.out.println("BASELINES prebehol v poriadku");
	System.runFinalization();
	System.gc();	
			
	//SAVE DATA
	habitData = new SaveHabitualData(numberResult);
	habitData.run();
	
	//spustim gargabe collector
	System.runFinalization();
	System.gc();
	
}

//slant correction
public static void action5 (int number) {
	if (number == 1) {
		
	} else if (number == 2) {
		

		
	} else if (number == 3) {

		
	} else if (number == 4) {
		for (int i = 0; i < mainWindow.numberImages; i++) {
			if (((internalFrame)(mainWindow.intFrameArrayList.get(i))).type == 0) {
				runSlantDet(((internalFrame)(mainWindow.intFrameArrayList.get(i))).numberRes, true, false, true, true, ((internalFrame)(mainWindow.intFrameArrayList.get(i))).imp);
			}
		}	
		//spustim gargabe collector
		System.runFinalization();
		System.gc();
	} 
}

//word segmentation
public static void action6 (int number) {
	if (number == 1) {
	} else if (number == 2) {
		

	} else if (number == 3) {
		

		
	} else if (number == 4) {
		for (int i = 0; i < mainWindow.numberImages; i++) {
			if (((internalFrame)(mainWindow.intFrameArrayList.get(i))).type == 0) {
				runWordSegm(((internalFrame)(mainWindow.intFrameArrayList.get(i))).numberRes, ((internalFrame)(mainWindow.intFrameArrayList.get(i))).imp);
			}
		}	
		//spustim gargabe collector
		System.runFinalization();
		System.gc();
	} 
}

//grapheme segm
public static void action7 (int number) {
	if (number == 1) {
	} else if (number == 2) {
		

	} else if (number == 3) {
		
		
	} else if (number == 4) {
		
		for (int i = 0; i < mainWindow.numberImages; i++) {
			if (((internalFrame)(mainWindow.intFrameArrayList.get(i))).type == 0) {
				runGraphemeSegm(((internalFrame)(mainWindow.intFrameArrayList.get(i))).numberRes, ((internalFrame)(mainWindow.intFrameArrayList.get(i))).imp);
			}
		}	
		//spustim gargabe collector
		System.runFinalization();
		System.gc();
		
	} 
}


//line segmentation
public static void action4 (int number) {
	if (number == 1) {
	} else if (number == 2) {
		

	} else if (number == 3) {
	} else if (number == 4) {
		for (int i = 0; i < mainWindow.numberImages; i++) {
			if (((internalFrame)(mainWindow.intFrameArrayList.get(i))).type == 0) {
				runLineSegm(((internalFrame)(mainWindow.intFrameArrayList.get(i))).numberRes, true, true, true, ((internalFrame)(mainWindow.intFrameArrayList.get(i))).imp);
			}
		}	
		//spustim gargabe collector
		System.runFinalization();
		System.gc();
	} 
}

public static void action1 (int number) {
	if (number == 1) {
		
		
		noDisplay = true;
		if (mainWindow.numberOpenImages > 2)
			noDisplay = false;
		
		//numbOpIm = mainWindow.numberImages
		numberRes = new int[mainWindow.numberOpenImages];
		numberFrame = new int[mainWindow.numberOpenImages];
		noneOpenImage = true;
		habit = new ArrayList[mainWindow.numberOpenImages];
		diffHabit = new ArrayList();
		j = 0;
	} else if (number == 2) {
		//System.out.println("mainWindow.numberImages "+mainWindow.numberImages);
		for (int i = 0; i < mainWindow.numberImages; i++) {
			//if (mainWindow.intFrame[i].type == 0) {
			if ( ((internalFrame)(mainWindow.intFrameArrayList.get(i))).type == 0) {
				if (j<2) {
					//run(mainWindow.intFrame[i].numberRes, noDisplay, mainWindow.intFrame[i].imp);
					//habit[j] = readData(mainWindow.intFrame[i].numberRes);
					//System.out.println("IIII "+i);
					runProces(((internalFrame)(mainWindow.intFrameArrayList.get(i))).numberRes, noDisplay, ((internalFrame)(mainWindow.intFrameArrayList.get(i))).imp);
					habit[j] = readData(((internalFrame)(mainWindow.intFrameArrayList.get(i))).numberRes);
				}
				//numberRes[j] = mainWindow.intFrame[i].numberRes;
				numberRes[j] = ((internalFrame)(mainWindow.intFrameArrayList.get(i))).numberRes;
				//System.out.println("numberRes[j] "+ numberRes[j]);
				numberFrame[j] = i;
				noneOpenImage = false;
				j++;
			}
		}
		
	} else if (number == 3) {
		//nebol otvoreny ziaden obrazok
		if (noneOpenImage) {
			JOptionPane.showMessageDialog(null, "First approach can be applied only on image opened from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);
			return;
		}
		
			
			count = 0;
			writers = "SAME";
			notSame = true;
			explain = "";
			
		while ((count < mainWindow.numberOpenImages-1) && (writers.compareTo("SAME") == 0)) {
			//System.out.println("count "+count);
			writers = "SAME";
			notSame = true;
			explain = "";
			diffHabit = new ArrayList();
			///////////
			if (count != 0) {
				//run(numberRes[count+1], noDisplay, mainWindow.intFrame[numberFrame[count+1]].imp);
				runProces(numberRes[count+1], noDisplay, ((internalFrame)(mainWindow.intFrameArrayList.get(numberFrame[count+1]))).imp);
				habit[count+1] = readData(numberRes[count+1]);
			}
			//////
			for (int i = 0; i < habit[count].size(); i++) {
					//	System.out.println("(Double)(habit1.get(i)) "+(Double)(habit[count].get(i)));
					//	System.out.println("(Double)(habit2.get(i)) "+(Double)(habit[count+1].get(i)));
						diffHabit.add(Roundness.roundTwoDecimal( Math.abs((Double)(habit[count].get(i)) - (Double)(habit[count+1].get(i)))));
						//System.out.println("(Double)(diffHabit.get(i)) "+(Double)(diffHabit.get(i)));
						if (i == 0) {
							if ( ((Double)(diffHabit.get(i))) > 0.50) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("Ratio of Lines/Height, ");
							}
						} else if (i == 1){
							if ( ((Double)(diffHabit.get(i))) > 300) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("density of handwriting, ");
							} 				
						} else if (i == 2){
							if ( ((Double)(diffHabit.get(i))) > 10) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("first proportion, ");
							}			
						} else if (i == 3) {
							if ( ((Double)(diffHabit.get(i))) > 10) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("second proportion, ");
							}				
						} else if (i == 4) {
							if ( ((Double)(diffHabit.get(i))) > 10) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("third proportion, ");
							}				
						} else if (i == 5) {
							if ( ((Double)(diffHabit.get(i))) > 0.2) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("slant, ");
							}				
						} else if (i == 6) {
							if ( ((Double)(diffHabit.get(i))) > 0.6) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("block letters, ");
							}					
						}
					}
			//System.out.println(count+" + "+(count+1)+" "+writers);
			count++;
		}
	} else if (number == 4) {
		
		if (mainWindow.numberOpenImages > 1) {
			if (writers.compareTo("DIFF") == 0) {
				explain = explain.substring(0, explain.length()-2);
				//System.out.println("blaaaaaaa");
				JOptionPane.showMessageDialog(null, "Input images are written by different writers because of: "+explain+".", "Message", JOptionPane.INFORMATION_MESSAGE);
			} else
				JOptionPane.showMessageDialog(null, "Input images are written by the same writer.", "Message", JOptionPane.INFORMATION_MESSAGE);
		} else {
		
			String r = result.checkImage();
			int numDif = Integer.parseInt(r.substring(0, 1));
			//System.out.println("numDif "+numDif);
			if (numDif > 1) {
				r = r.substring(2, r.length());
				JOptionPane.showMessageDialog(null, "The whole image is not written by the same writer! "+r, "Message", JOptionPane.INFORMATION_MESSAGE);
			} else
				JOptionPane.showMessageDialog(null, "The whole image is written by the same writer!", "Message", JOptionPane.INFORMATION_MESSAGE);
		}
		
		//spustim gargabe collector
		System.runFinalization();
		System.gc();
		
		skoncil = true;
	} 
}

public static void action2 (int number) {
	if (number == 1) {		
		
		cluster = new double[2];
		numberResult = new int[2];
		
		noDisplay = true;
		if (mainWindow.numberOpenImages > 2)
			noDisplay = false;
		
		numberRes = new int[mainWindow.numberOpenImages];
		numberFrame = new int[mainWindow.numberOpenImages];
		noneOpenImage = true;
		habit = new ArrayList[mainWindow.numberOpenImages];
		diffHabit = new ArrayList();
		j = 0;
		
	} else if (number == 2) {		

		for (int i = 0; i < mainWindow.numberImages; i++) {
			if (((internalFrame)(mainWindow.intFrameArrayList.get(i))).type == 0) {
				if (j<2) {
					numberResult[j] = ((internalFrame)(mainWindow.intFrameArrayList.get(i))).numberRes;
					runProces2(((internalFrame)(mainWindow.intFrameArrayList.get(i))).numberRes, noDisplay, ((internalFrame)(mainWindow.intFrameArrayList.get(i))).imp);
					habit[j] = readData(numberResult[j]);
				}
				numberRes[j] = ((internalFrame)(mainWindow.intFrameArrayList.get(i))).number;
				numberFrame[j] = i;
				noneOpenImage = false;
				j++;
			}
		}
	} else if (number == 3) {

		//nebol otvoreny ziaden obrazok
		if (noneOpenImage) {
			JOptionPane.showMessageDialog(null, "First approach can be applied only on image opened from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);
			return;
		}	
		
		System.out.println("numberResult[0] "+numberResult[0]);
		System.out.println("numberResult[1] "+numberResult[1]);					
		//hierarchicke clustrovanie
		hierarchical = new Hierarchical(2, numberResult);
		cluster = hierarchical.obtainFeatures();	
		
		//spustim gargabe collector
		System.runFinalization();
		System.gc();
		
	} else if (number == 4) {

		count = 0;
		writers = "SAME";
		notSame = true;
		explain = "";
		while ((count < mainWindow.numberOpenImages-1) && (writers.compareTo("SAME") == 0)) {
			System.out.println("count "+count);
			writers = "SAME";
			notSame = true;
			explain = "";
			diffHabit = new ArrayList();
			///////////
			if (count != 0) {
				runProces2(numberRes[count+1], noDisplay, ((internalFrame)(mainWindow.intFrameArrayList.get(numberFrame[count+1]))).imp);
				habit[count+1] = readData(numberRes[count+1]);
				numberResult[0] = numberResult[1];
				numberResult[1] = numberRes[count+1];
				//hierarchicke clustrovanie
				System.out.println("numberResult[0] "+numberResult[0]);
				System.out.println("numberResult[1] "+numberResult[1]);
				hierarchical = new Hierarchical(2, numberResult);
				cluster = hierarchical.obtainFeatures();	
			}
			//////
			for (int i = 0; i < habit[count].size(); i++) {
					//	System.out.println("(Double)(habit1.get(i)) "+(Double)(habit[count].get(i)));
					//	System.out.println("(Double)(habit2.get(i)) "+(Double)(habit[count+1].get(i)));
						diffHabit.add(Roundness.roundTwoDecimal( Math.abs((Double)(habit[count].get(i)) - (Double)(habit[count+1].get(i)))));
						System.out.println("(Double)(diffHabit.get(i)) "+(Double)(diffHabit.get(i)));
						if (i == 0) {
							if ( ((Double)(diffHabit.get(i))) > 0.50) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("Ratio of Lines/Height, ");
							}
						} else if (i == 1){
							if ( ((Double)(diffHabit.get(i))) > 300) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("density of handwriting, ");
							} 				
						} else if (i == 2){
							if ( ((Double)(diffHabit.get(i))) > 10) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("first proportion, ");
							}			
						} else if (i == 3) {
							if ( ((Double)(diffHabit.get(i))) > 10) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("second proportion, ");
							}				
						} else if (i == 4) {
							if ( ((Double)(diffHabit.get(i))) > 10) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("third proportion, ");
							}				
						} else if (i == 5) {
							if ( ((Double)(diffHabit.get(i))) > 0.2) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("slant, ");
							}				
						} else if (i == 6) {
							if ( ((Double)(diffHabit.get(i))) > 0.6) {
								writers = "DIFF";
								notSame = true;
								explain = explain.concat("block letters, ");
							}					
						}
					}
			
			//cluster moze zrusit povodny vysledok
			if (cluster[0] < 55) {
				writers = "SAME";
				explain = explain.concat("clustering, ");
			} else if (cluster[0] > 65) {
				writers = "DIFF";
				explain = explain.concat("clustering, ");
			} else {
				if (cluster[1] < 20) {
					writers = "SAME";
					explain = explain.concat(explain = "clustering, ");
				} else if (cluster[1] > 30) {
					writers = "DIFF";
					explain = explain.concat("clustering, ");
				}
			}
			
			System.out.println(count+" + "+(count+1)+" "+writers);
			count++;
		}

							
		if (writers.compareTo("DIFF") == 0) {
			explain = explain.substring(0, explain.length()-2);
			JOptionPane.showMessageDialog(null, "Input images are written by different writers because of: "+explain+".", "Message", JOptionPane.INFORMATION_MESSAGE);
		} else
			JOptionPane.showMessageDialog(null, "Input images are written by the same writer.", "Message", JOptionPane.INFORMATION_MESSAGE);
		
		//spustim gargabe collector
		System.runFinalization();
		System.gc();
	}
}



public static void action3 (int number) {
	if (number == 1) {
/*		Date date = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss:SSS");
		System.out.println("SOMKA uplny zac "+ sdf.format(date));*/

	} else if (number == 2) {	
			
		
		for (int i = 0; i < mainWindow.numberImages; i++) {
			if (((internalFrame)(mainWindow.intFrameArrayList.get(i))).type == 0) {
				System.out.println("IIII "+i);
				runProces2(((internalFrame)(mainWindow.intFrameArrayList.get(i))).numberRes, false, ((internalFrame)(mainWindow.intFrameArrayList.get(i))).imp);
			}
		}
			
		//bude fungovat len pre 2
		//runProces(0, false, ((internalFrame)(mainWindow.intFrameArrayList.get(0))).imp);
		//runProces(1, false, ((internalFrame)(mainWindow.intFrameArrayList.get(1))).imp);	
		///spusti porovnavanie SOOMKA
		
/*		Date date = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss:SSS");
		System.out.println("SOMKA zac "+ sdf.format(date));*/
		
		norm = new MyAlgorithm(imp, ip, 1, true);
		//norm.run(50);
		som = norm.run3(30, false);
		
/*		date = new Date();
		sdf = new SimpleDateFormat("HH:mm:ss:SSS");
		System.out.println("SOMKA koniec "+ sdf.format(date));*/
		
		System.runFinalization();
		System.gc();		
		
	} else if (number == 3) {

		///spusti porovnavanie
		habit1 = new ArrayList();
		habit2 = new ArrayList();
		diffHabit = new ArrayList();
	
		readData(0, habit1);
		readData(1, habit2);
		writers = "SAME";
		notSame = true;
		explain = "";
		for (int i = 0; i < habit1.size(); i++) {
	//		System.out.println("(Double)(habit1.get(i)) "+(Double)(habit1.get(i)));
	//		System.out.println("(Double)(habit2.get(i)) "+(Double)(habit2.get(i)));
			diffHabit.add(Roundness.roundTwoDecimal( Math.abs((Double)(habit1.get(i)) - (Double)(habit2.get(i)))));
			//System.out.println("(Double)(diffHabit.get(i)) "+(Double)(diffHabit.get(i)));
			if (i == 0) {
				if ( ((Double)(diffHabit.get(i))) > 0.50) {
					writers = "DIFF";
					notSame = true;
					explain = explain.concat("Ratio of Lines/Height, ");
				}
			} else if (i == 1){
				if ( ((Double)(diffHabit.get(i))) > 300) {
					writers = "DIFF";
					notSame = true;
					explain = explain.concat("density of handwriting, ");
				} 				
			} else if (i == 2){
				if ( ((Double)(diffHabit.get(i))) > 10) {
					writers = "DIFF";
					notSame = true;
					explain = explain.concat("first proportion, ");
				}			
			} else if (i == 3) {
				if ( ((Double)(diffHabit.get(i))) > 10) {
					writers = "DIFF";
					notSame = true;
					explain = explain.concat("second proportion, ");
				}				
			} else if (i == 4) {
				if ( ((Double)(diffHabit.get(i))) > 10) {
					writers = "DIFF";
					notSame = true;
					explain = explain.concat("third proportion, ");
				}				
			} else if (i == 5) {
				if ( ((Double)(diffHabit.get(i))) > 0.2) {
					writers = "DIFF";
					notSame = true;
					explain = explain.concat("slant, ");
				}				
			} else if (i == 6) {
				if ( ((Double)(diffHabit.get(i))) > 0.6) {
					writers = "DIFF";
					notSame = true;
					explain = explain.concat("block letters, ");
				}					
			}
		}
	} else if (number == 4) {
		
		//SOMka
			if (som < 55) {
				writers = "DIFF";
				explain = explain.concat("som, ");			
			} else if (som > 70) {
				writers = "SAME";
				explain = explain.concat("som, ");			
			}		
		System.out.println("SOM "+som);	
			
		
		if (writers.compareTo("DIFF") == 0) {
			explain = explain.substring(0, explain.length()-2);
			JOptionPane.showMessageDialog(null, "Input images are written by different writers because of: "+explain+".", "Message", JOptionPane.INFORMATION_MESSAGE);
		} else
			JOptionPane.showMessageDialog(null, "Input images are written by the same writer.", "Message", JOptionPane.INFORMATION_MESSAGE);

		
		Date date = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss:SSS");
		System.out.println("SOMKA uplny koniec "+ sdf.format(date));
		
		//spustim gargabe collector
		System.runFinalization();
		System.gc();
	 }	
}


public static int returnType(){
	return type;
}


public JProgressBarAll(int type) {
	super("Progress Bar");
	setSize(300,50);
	UIManager.put("ProgressBar.selectionBackground", Color.black);
	UIManager.put("ProgressBar.selectionForeground", Color.white);
	UIManager.put("ProgressBar.foreground", new Color(8,32,128));
	UIManager.put("ProgressBar.cellLength", new Integer(5));
	UIManager.put("ProgressBar.cellSpacing", new Integer(1));
	
	this.type = type;

	m_progress = new JProgressBar();
	m_progress.setMinimum(m_min);
	m_progress.setMaximum(m_max);
	m_progress.setStringPainted(m_stringPainted);
	

	m_stringPainted = !m_stringPainted;
	m_progress.setStringPainted(m_stringPainted);
	
	
	Thread runner = new Thread() {
		int m_counter;
		int m_counter2 = 1;
		
		public void run() {

			//m_progress.setIndeterminate(false);
			// Pretend we're doing phase 2
			for (m_counter = 1; m_counter <= 4; m_counter++) {
				Runnable runme = new Runnable() {
					public void run() {
						m_progress.setValue(m_counter*25);
						setVisible(true);
						
						if (returnType() == 1)
							action1(m_counter2);
						
						if (returnType() == 2)
							action2(m_counter2);

						if (returnType() == 3)
							action3(m_counter2);
						
						if (returnType() == 4)
							action4(m_counter2);	
						
						if (returnType() == 5)
							action5(m_counter2);
						
						if (returnType() == 6)
							action6(m_counter2);						

						if (returnType() == 7)
							action7(m_counter2);						
						
						System.out.println("M_COUNTER2 "+m_counter2);
						
						if ( m_counter2 == 4 ) {
							JProgressBarAll.this.dispose();
							System.out.println("DISPOSE");
						}
						
						m_counter2++;
					}
				};
				
				SwingUtilities.invokeLater(runme);
				try {
					Thread.sleep(100);
				}
				catch (InterruptedException ex) {}
				
			}
		}

	};	
			
	runner.start();
	
	getContentPane().setLayout(new BorderLayout(10,10));
	getContentPane().add(m_progress, BorderLayout.CENTER);
	//getContentPane().add(m_start, BorderLayout.WEST);

}


/*protected void finalize() throws Throwable {
    try {
        //close();        // close open files
    } finally {
        super.finalize();
        JProgressBarDemo.this.dispose();
        System.out.println("progressbar1 has been finalized.");
    }
}*/	

/////////////////////////////////////////////////////////////////////////////////////////////
public static ArrayList readData(int numberResult) {
	//open first file 
	ArrayList habit = new ArrayList();
	try{
		//System.out.println("numberResult "+numberResult);
		FileReader fr = new FileReader("pics\\graphemes\\"+numberResult+"\\habitData.txt");
		BufferedReader br = new BufferedReader(fr);
		
		String line;
		while ((line = br.readLine()) != null) {
			String name = line.substring(0, line.indexOf(' '));
			//System.out.println("name "+name);
			line = line.substring(line.indexOf(' ')+1, line.length());
			String percento = line.substring(0, line.indexOf(' '));
			line = line.substring(line.indexOf(' ')+1, line.length());
			String number = line;
			//System.out.println("number "+number);
			habit.add(Double.parseDouble(number));
		}
					
		br.close();
		fr.close();
		
	} catch (Exception e) {
		System.out.println("nieco zlyhalo so suborom");
	}
	return habit;
}


///////////////////
public static void readData(int numberResult, ArrayList habit) {
	//open first file 
	try{
		FileReader fr = new FileReader("pics\\graphemes\\"+numberResult+"\\habitData.txt");
		BufferedReader br = new BufferedReader(fr);
		
		String line;
		while ((line = br.readLine()) != null) {
			String name = line.substring(0, line.indexOf(' '));
			//System.out.println("name "+name);
			line = line.substring(line.indexOf(' ')+1, line.length());
			String percento = line.substring(0, line.indexOf(' '));
			line = line.substring(line.indexOf(' ')+1, line.length());
			String number = line;
			//System.out.println("number "+number);
			habit.add(Double.parseDouble(number));
		}
					
		br.close();
		fr.close();
		
	} catch (Exception e) {
		System.out.println("nieco zlyhalo so suborom");
	}			
}

}