package GUI;

import java.awt.event.ActionListener;

import javax.swing.*;
import ij.*;
import ij.process.*;
import ij.gui.*;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.*;
import ij.plugin.filter.Binary;
import java.util.*;
//import Transform.TJ_Rotate;
//import Transform.TJ_Scale;
import representation.ChainCode;
//import ij.plugin.Tool_Demo;
import filter.Average;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.filters.Gray;
import com.sun.jimi.core.*; 
import com.sun.jimi.core.filters.*; 
import com.sun.jimi.core.raster.*;
import javax.swing.event.InternalFrameEvent;

import noise.*;

import representation.Dilatation;
import representation.HorizontalRunLength;
//import representation.Slant;
import representation.SlantVertiPro;
import representation.Moore;
import representation.Moore2;

import segmentation.*;

import comparison.SaveHabitualData;
import IAMdatabase.*;
import segmentation.Line4;
//import segmentation.WordSegmentation;
import sizeNormalization.MyAlgorithm;
import sizeNormalization.ResizeImage;

import GUI.FileChooser;
import GUI.internalFrame;
import GUI.mainWindow;

import thresholding.*;
import histogram.*;

public class menu extends JMenuBar {

	public JMenuBar jmenuBar;
	FileChooser fileChooser = new FileChooser();
	
	private OtsuThresholding_ otsu; 
	private Entropy_Threshold entropy;
	private Histogram hist;
	private HorizontalHistogram horizHist;
	private VerticalHistogram vertHist;
	private Average averageFilter;
	private IsolatedPixelsRemoval_ ipr;
	private RegionRemoval_ rr;
	private Dilatation dilatation;
	private Separation sep;
	private HorizontalRunLength hrl;
	private Moore moore;
	private Moore2 moore2;
	private ImagePlus impOtsu;
	
	
	public menu(){
		
		jmenuBar = new JMenuBar();
		//first
		JMenu mFile = new JMenu("File");
		//mFile.setMnemonic('f');
		
		JMenuItem item = new JMenuItem("Open..");
	//	item.setIcon(new ImageIcon("New16.gif"));
	//	item.setMnemonic('n');
	//	item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, InputEvent.CTRL_MASK));
		item.addActionListener(new openFileListener());
		mFile.add(item);	

		item = new JMenuItem("Save as..");
		item.addActionListener(new saveAsListener());		
		mFile.add(item);		
		
		item = new JMenuItem("Close all windows");
		item.addActionListener(new closeWindowsListener());		
		mFile.add(item);	
		
		item = new JMenuItem("Exit");
		item.addActionListener(new closeListener());		
		mFile.add(item);		
		
		jmenuBar.add(mFile);
		
		//second
		mFile = new JMenu("Operations");
		
		//submenu
		JMenu submenu=new JMenu("Binarization");			

		item=new JMenuItem("Otsu's thresholding");	
		item.addActionListener(new otsuListener());		
		submenu.add(item);
		
		
		item=new JMenuItem("Entropy thresholding");	
		item.addActionListener(new entropyListener());			
		submenu.add(item);		
		mFile.add(submenu);		
		
		//submenu
		submenu=new JMenu("Histogram");			

		item = new JMenuItem("Classic");
		item.addActionListener(new histogramListener());			
		submenu.add(item);
		
		item = new JMenuItem("Horizontal Projection Profile");
		item.addActionListener(new hppListener());			
		submenu.add(item);
		
		item = new JMenuItem("Vertical Projection Profile");
		item.addActionListener(new vppListener());			
		submenu.add(item);
		
		item = new JMenuItem("Projection profile of chunks");
		item.addActionListener(new proProChunksListener());			
		submenu.add(item);
		mFile.add(submenu);	
		
		//submenu
		submenu=new JMenu("Average filter");	
		
		item = new JMenuItem("3x3");
		item.addActionListener(new averageFilter1Listener());			
		submenu.add(item);
		
		item = new JMenuItem("5x5");
		item.addActionListener(new averageFilter2Listener());			
		submenu.add(item);
		
		item = new JMenuItem("7x7");
		item.addActionListener(new averageFilter3Listener());			
		submenu.add(item);
		mFile.add(submenu);
		
		
		//submenu
		submenu=new JMenu("Noise reduction");	
		
		item = new JMenuItem("Isolated Pixels Removal");
		item.addActionListener(new isolPixelRemListener());			
		submenu.add(item);
		
		item = new JMenuItem("Region Removal");
		item.addActionListener(new regionRemovalListener());					
		submenu.add(item);
		mFile.add(submenu);	
		
		item = new JMenuItem("Dilatation");
		item.addActionListener(new dilatationListener());			
		mFile.add(item);	
		
/*		item = new JMenuItem("Horizontal Run Length");
		item.addActionListener(new hrlListener());			
		mFile.add(item);		
		
		item = new JMenuItem("Slant");
		item.addActionListener(new slantListener());			
		mFile.add(item);	*/
		
/*		item = new JMenuItem("Slant Verti Pro");
		item.addActionListener(new slantVPListener());			
		mFile.add(item);	*/		
			
		item = new JMenuItem("Moore's Algorithm");
		item.addActionListener(new mooreListener());			
		mFile.add(item);
		
/*		item = new JMenuItem("Chain Code");
		item.addActionListener(new chainCodeListener());			
		mFile.add(item);*/		
		
/*		item = new JMenuItem("Moore's Algorithm2");
		item.addActionListener(new moore2Listener());			
		mFile.add(item);*/	
		
		
/*		item = new JMenuItem("Baselines detection");
		item.addActionListener(new baselineListener());			
		mFile.add(item);	*/
					
		
		jmenuBar.add(mFile);			
		
		//third
		mFile = new JMenu("Application");
		
		//submenu
		submenu=new JMenu("Preprocessing");	
		
		item = new JMenuItem("Line segmentation");
		item.addActionListener(new lineSegmentationAlgListener());					
		submenu.add(item);
		
		item = new JMenuItem("Slant correction");
		item.addActionListener(new slantCorrectionListener());					
		submenu.add(item);
		
		item = new JMenuItem("Word segmentation");
		item.addActionListener(new wordSegmentationListener());					
		submenu.add(item);		
	
		item = new JMenuItem("Grapheme segmentation and normalization");
		item.addActionListener(new graphemeSegmentationListener());					
		submenu.add(item);	
		mFile.add(submenu);	
		
		
		item = new JMenuItem("The first approach");
		item.addActionListener(new firstSystemListener());			
		mFile.add(item);
		
		item = new JMenuItem("The second approach");
		item.addActionListener(new secondSystemListener());			
		mFile.add(item);
		
		item = new JMenuItem("The third approach");
		item.addActionListener(new thirdSystemListener());			
		mFile.add(item);		
		
		
		jmenuBar.add(mFile);		
			
	}
	
	private class openFileListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			//fileChooser.openFile(mainWindow.intFrame);
			fileChooser.openFile();
		}
		
	}	
	
	private class saveAsListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			try{
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				fileChooser.saveFile((internalFrame)mainWindow.desktop.getSelectedFrame(), imp);
			} catch (Exception je){
				//je.printStackTrace();
			}
		}
		
	}		
	
	private class closeWindowsListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			//System.out.println("mainWindow.intFrameArrayList.size() "+mainWindow.intFrameArrayList.size());
			int number = mainWindow.intFrameArrayList.size();
			
			//for (int i = 0; i < number; i++) {
/*				System.out.println("number "+((internalFrame)(mainWindow.intFrameArrayList.get(0))).number);
				System.out.println("type "+((internalFrame)(mainWindow.intFrameArrayList.get(0))).type);
				System.out.println("numberRes "+((internalFrame)(mainWindow.intFrameArrayList.get(0))).numberRes);
				System.out.println("0 "+0);*/
				//((internalFrame)(mainWindow.intFrameArrayList.get(0))).dispose();
				//((internalFrame)(mainWindow.intFrameArrayList.get(0))).close();
				//System.out.println("mainWindow.intFrameArrayList.size() "+mainWindow.intFrameArrayList.size());
			//}
			
			for (int i = 0; i < number; i++) {
				System.out.println("number "+((internalFrame)(mainWindow.intFrameArrayList.get(mainWindow.intFrameArrayList.size()-1))).number);
				System.out.println("type "+((internalFrame)(mainWindow.intFrameArrayList.get(mainWindow.intFrameArrayList.size()-1))).type);
				System.out.println("numberRes "+((internalFrame)(mainWindow.intFrameArrayList.get(mainWindow.intFrameArrayList.size()-1))).numberRes);
				System.out.println("i "+i);
				try{
					((internalFrame)(mainWindow.intFrameArrayList.get(mainWindow.intFrameArrayList.size()-1))).setClosed(true);
				} catch (Exception exp) {
					// TODO: handle exception
				}
			
			}
			mainWindow.intFrameArrayList = new ArrayList();
			mainWindow.numberImages = 0;
			mainWindow.numberOpenImages = 0;
			fileChooser.number = 0;
			fileChooser.numberResult = 0;
			
			//spustim gargabe collector
			System.runFinalization();
			System.gc();
		}
		
	}	
	
	private class closeListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			System.exit(0);
		}
		
	}	
	
	
	private class otsuListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {
				int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				otsu = new OtsuThresholding_(imp.getTitle(), numberResult, true, true); 
				otsu.run(imageProcessor.convertToByte(false));
				otsu.setup("about", imp);
				impOtsu = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
		}
		
	}		
			
	
	private class entropyListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {
				int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				entropy = new Entropy_Threshold(imp.getTitle(), numberResult, true); 
				entropy.setup("assa", imp);
				entropy.run(imageProcessor.convertToByte(false));
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
			
		}
		
	}	
	
	private class histogramListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {
				int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				hist = new Histogram(imp);
				hist.run("");
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
			
		}
		
	}	
	
	
	private class hppListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {
			//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				horizHist = new HorizontalHistogram(imp, imageProcessor, true, numberResult, true);
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
			
		}
		
	}			
	
	private class vppListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {			
				int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				vertHist = new VerticalHistogram(imp, imageProcessor, number, numberResult);
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
			
		}
		
	}							
			
	
/*	private class chainCodeListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberOpenImages > 0) {			
				int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				chainCode = new ChainCode(imp, imageProcessor, numberResult); 
				chainCode.run();
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);

		}
		
	}*/	
	
	
	private class proProChunksListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {
				//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				horizHist = new HorizontalHistogram(imp, imageProcessor, false, numberResult, true);
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
				
		}
		
	}	
	
	private class lineSegmentationAlgListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			
			if (mainWindow.numberOpenImages == 1) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					JProgressBarAll frame = new JProgressBarAll(4);
				}
			} else 
				JOptionPane.showMessageDialog(null, "Line segmentation works only on ONE image open from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);								

			
			
/*			if (mainWindow.numberImages > 0) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					
					
					int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
					int type = ((internalFrame)mainWindow.desktop.getSelectedFrame()).type;
					if (type == 0) {
						ImageProcessor imageProcessor;		
				
						ImagePlus imp = new ImagePlus();
						imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
						
						if(imp.getRoi()!=null){
							//IJ.write("image has ROI");
							imageProcessor = imp.getProcessor().crop();
						}else{
							//IJ.write("image does not have ROI");
							imageProcessor = imp.getProcessor();
						}
						lineSegmentation = new LineSegmentation(imp, imageProcessor, numberResult, impOtsu); 
						lineSegmentation.run();
						
						//spustim gargabe collector
						System.runFinalization();
						System.gc();
						
					} else 
						JOptionPane.showMessageDialog(null, "Line segmentation can be applied only on image opened from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);
				} 
					
			} else 
				JOptionPane.showMessageDialog(null, "None image is open!", "Message", JOptionPane.INFORMATION_MESSAGE);
*/
		}
		
	}		
	
	private class slantCorrectionListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			
			if (mainWindow.numberOpenImages == 1) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					JProgressBarAll frame = new JProgressBarAll(5);
				}
			} else 
				JOptionPane.showMessageDialog(null, "Slant correction works only on ONE image open from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);								

			
			
/*			if (mainWindow.numberImages > 0) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
					int type = ((internalFrame)mainWindow.desktop.getSelectedFrame()).type;
					if (type == 0) {
						ImageProcessor imageProcessor;		
				
						ImagePlus imp = new ImagePlus();
						imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
						
						if(imp.getRoi()!=null){
							//IJ.write("image has ROI");
							imageProcessor = imp.getProcessor().crop();
						}else{
							//IJ.write("image does not have ROI");
							imageProcessor = imp.getProcessor();
						}
						slantCorrection = new SlantCorrection(imp, imageProcessor, numberResult, impOtsu); 
						slantCorrection.run();
						
						//spustim gargabe collector
						System.runFinalization();
						System.gc();
					} else 
						JOptionPane.showMessageDialog(null, "Slant correction can be applied only on image opened from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);
				}
			} else 
				JOptionPane.showMessageDialog(null, "None image is open!", "Message", JOptionPane.INFORMATION_MESSAGE);
*/				
		}
		
	}	
	
	private class wordSegmentationListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			
			if (mainWindow.numberOpenImages == 1) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					JProgressBarAll frame = new JProgressBarAll(6);
				}
			} else 
				JOptionPane.showMessageDialog(null, "Word segmentation works only on ONE image open from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);								

			
			
/*			if (mainWindow.numberImages > 0) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {				
					int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
					int type = ((internalFrame)mainWindow.desktop.getSelectedFrame()).type;
					if (type == 0) {
						ImageProcessor imageProcessor;		
				
						ImagePlus imp = new ImagePlus();
						imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
						
						if(imp.getRoi()!=null){
							//IJ.write("image has ROI");
							imageProcessor = imp.getProcessor().crop();
						}else{
							//IJ.write("image does not have ROI");
							imageProcessor = imp.getProcessor();
						}
						//impSepLines= ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
						wordSegmentation = new WordSegmentation(imp, imageProcessor, numberResult, impOtsu); 
						wordSegmentation.run();
						
						//spustim gargabe collector
						System.runFinalization();
						System.gc();
					} else 
						JOptionPane.showMessageDialog(null, "Word segmentation can be applied only on image opened from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);
				}
			} else 
				JOptionPane.showMessageDialog(null, "None image is open!", "Message", JOptionPane.INFORMATION_MESSAGE);				
*/		}
		
	}	
	
	private class graphemeSegmentationListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			
			if (mainWindow.numberOpenImages == 1) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					JProgressBarAll frame = new JProgressBarAll(7);
				}
			} else 
				JOptionPane.showMessageDialog(null, "Grapheme segmentation works only on ONE image open from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);								
			
			
			
/*			if (mainWindow.numberImages > 0) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
					int type = ((internalFrame)mainWindow.desktop.getSelectedFrame()).type;
					if (type == 0) {
						ImageProcessor imageProcessor;		
				
						ImagePlus imp = new ImagePlus();
						imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
						
						if(imp.getRoi()!=null){
							//IJ.write("image has ROI");
							imageProcessor = imp.getProcessor().crop();
						}else{
							//IJ.write("image does not have ROI");
							imageProcessor = imp.getProcessor();
						}
						graphemeSegmentation = new GraphemeSegmentation(imp, imageProcessor, numberResult, impOtsu); 
						graphemeSegmentation.run();
						
						
						//spustim gargabe collector
						System.runFinalization();
						System.gc();
					} else 
						JOptionPane.showMessageDialog(null, "Grapheme segmentation can be applied only on image opened from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);
				}
			} else 
				JOptionPane.showMessageDialog(null, "None image is open!", "Message", JOptionPane.INFORMATION_MESSAGE);				
				
*/		}
		
	}	
	
	private class firstSystemListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberOpenImages > 0) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					JProgressBarAll frame = new JProgressBarAll(1);
				}
			} else 
				JOptionPane.showMessageDialog(null, "None image (from directory 'pics') is open!", "Message", JOptionPane.INFORMATION_MESSAGE);								
		}
		
	}	
	
	//SOMKY
	private class secondSystemListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			
			if (mainWindow.numberOpenImages == 2) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					JProgressBarAll frame = new JProgressBarAll(3);
				}
			} else 
				JOptionPane.showMessageDialog(null, "Second approach (SOM) works only on TWO images open from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);								
				
		}
		
	}	
	
	//hierarchicke klastrovanie
	private class thirdSystemListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberOpenImages > 1) {
				if (mainWindow.numberImages > 5) {
					JOptionPane.showMessageDialog(null, "You have too many open windows. Please close some of them!.", "Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					JProgressBarAll frame = new JProgressBarAll(2);
					
				}
			} else 
				JOptionPane.showMessageDialog(null, "Third approach works only on two and more input images open from directory 'pics'!", "Message", JOptionPane.INFORMATION_MESSAGE);								
			
		}
		
	}	
		
	
	private class averageFilter1Listener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {			
				//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				averageFilter = new Average(imp, imageProcessor, numberResult, true);
				averageFilter.run1();
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
			
		}
		
	}
	
	private class averageFilter2Listener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {
				//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				averageFilter = new Average(imp, imageProcessor, numberResult, true);
				averageFilter.run2();
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
				
		}
		
	}	
	
	private class averageFilter3Listener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {
				//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				averageFilter = new Average(imp, imageProcessor, numberResult, true);
				averageFilter.run3();
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
				
		}
		
	}			
		
	
	private class isolPixelRemListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {			
				//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				ipr = new IsolatedPixelsRemoval_(imp, imageProcessor, numberResult, true);
				ipr.run();
				impOtsu = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				//averageFilter.run2();
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
				
		}
		
	}	
	
	
	private class regionRemovalListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {			
				//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				rr = new RegionRemoval_(imp, imageProcessor, numberResult, true);
				rr.run();
				impOtsu = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				//averageFilter.run2();
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
				
		}
		
	}		
		
	
	private class dilatationListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {			
				//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				dilatation = new Dilatation(imp, imageProcessor, numberResult, true);
				dilatation.run();
			//	fm.setup("about", imp);
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
			
		}
		
	}	
	
/*	private class sepListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			
			//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
			int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
			ImageProcessor imageProcessor;		
	
			ImagePlus imp = new ImagePlus();
			imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
			
			if(imp.getRoi()!=null){
				//IJ.write("image has ROI");
				imageProcessor = imp.getProcessor().crop();
			}else{
				//IJ.write("image does not have ROI");
				imageProcessor = imp.getProcessor();
			}
			
			sep = new Separation(imp, imageProcessor, impOtsu, numberResult, true, true);
			sep.run();
		//	fm.setup("about", imp);
			impSepLines= ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
		}
		
	}*/	
	
	private class hrlListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			
			//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
			int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
			ImageProcessor imageProcessor;		
	
			ImagePlus imp = new ImagePlus();
			imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
			
			if(imp.getRoi()!=null){
				//IJ.write("image has ROI");
				imageProcessor = imp.getProcessor().crop();
			}else{
				//IJ.write("image does not have ROI");
				imageProcessor = imp.getProcessor();
			}
			
			hrl = new HorizontalRunLength(imp, imageProcessor, numberResult);
			//hrl.ru
		//	fm.setup("about", imp);
			
		}
		
	}	
	
/*	private class slantVPListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			
			//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
			int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
			ImageProcessor imageProcessor;		
	
			ImagePlus imp = new ImagePlus();
			imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
			
			if(imp.getRoi()!=null){
				//IJ.write("image has ROI");
				imageProcessor = imp.getProcessor().crop();
			}else{
				//IJ.write("image does not have ROI");
				imageProcessor = imp.getProcessor();
			}
			
			slantVP = new SlantVertiPro(imp, imageProcessor, numberResult, true, true);
			//hrl.ru
		//	fm.setup("about", imp);
			
		}
		
	}*/	
	
	private class mooreListener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberImages > 0) {			
				//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				moore = new Moore(impOtsu, imp, imageProcessor, numberResult, true);
				moore.run(true);
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);

			
		}
		
	}
	
	private class moore2Listener implements ActionListener{
		
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (mainWindow.numberOpenImages > 0) {
				//	int number = ((internalFrame)mainWindow.desktop.getSelectedFrame()).number;
				int numberResult = ((internalFrame)mainWindow.desktop.getSelectedFrame()).numberRes;
				ImageProcessor imageProcessor;		
		
				ImagePlus imp = new ImagePlus();
				imp = ((internalFrame)mainWindow.desktop.getSelectedFrame()).imp;
				
				if(imp.getRoi()!=null){
					//IJ.write("image has ROI");
					imageProcessor = imp.getProcessor().crop();
				}else{
					//IJ.write("image does not have ROI");
					imageProcessor = imp.getProcessor();
				}
				
				moore2 = new Moore2(impOtsu, imp, imageProcessor, numberResult, true);
				moore2.algoritm();
			} else 
				JOptionPane.showMessageDialog(null, "None image is opened!", "Message", JOptionPane.INFORMATION_MESSAGE);
			
		}
		
	}	
		
	
}