package noise;

import ij.ImagePlus;
import ij.gui.NewImage;
import ij.process.ImageProcessor;

import GUI.FileChooser;
import GUI.internalFrame;
import GUI.mainWindow;
	
public class IsolatedPixelsRemoval_ {
		
	ImagePlus imp, imp2;
	ImageProcessor ip, nip;
	int numberResult;
	boolean draw;
		
	public IsolatedPixelsRemoval_(ImagePlus imp, ImageProcessor ip, int numberResult, boolean draw) {
		this.imp = imp;
		this.ip = ip;
		this.numberResult = numberResult;
		this.draw = draw;
	}	

	public void run(){
		
		imp2 = NewImage.createImage ("Threshold", ip.getWidth(), ip.getHeight(), 1, 8, NewImage.FILL_WHITE);
		nip = imp2.getProcessor();
		
		for (int i = 0; i < ip.getWidth(); i++) {
			for (int j = 0; j < ip.getHeight(); j++) {
				if (ip.getPixelValue(i, j) == 0)
					if (!( (ip.getPixelValue(i-1, j-1) !=0) && (ip.getPixelValue(i-1, j) !=0) && (ip.getPixelValue(i-1, j+1) !=0) &&
							(ip.getPixelValue(i, j-1) !=0) && (ip.getPixelValue(i, j+1) !=0) &&
							(ip.getPixelValue(i+1, j-1) !=0) && (ip.getPixelValue(i+1, j) !=0) && (ip.getPixelValue(i+1, j+1) !=0)) )
						nip.putPixelValue(i, j, 0);
			}
		}
		
		if (draw) {
			
			mainWindow.intFrameArrayList.add(new internalFrame("Isolated Pixels Removal", imp2, FileChooser.number, numberResult, 1, true));
			try {
				//mainWindow.intFrame[FileChooser.number].setSelected(true);
				((internalFrame)(mainWindow.intFrameArrayList.get(FileChooser.number))).setSelected(true);
			} catch(Exception e){
				System.out.println("Chyba");
			}	
			++FileChooser.number;
		}
	}
	
	public ImagePlus getImg(){
		return imp2;
	}
	
	public ImageProcessor getIp(){
		return nip;
	}	
	
	protected void finalize() throws Throwable {
	    try {
	        //close();        // close open files
	    } finally {
	        super.finalize();
	        System.out.println("isol has been finalized.");
	    }
	}	

}
