package sizeNormalization;

import ij.ImagePlus;
import ij.gui.NewImage;
import ij.process.ImageProcessor;

import java.awt.Image;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.ReplicateScaleFilter;
import java.awt.image.RescaleOp;

import GUI.FileChooser;
import GUI.internalFrame;
import GUI.mainWindow;

public class ResizeImage {
	
	private ImagePlus imp;
	private ImagePlus imp2, imp3, impLast;
	private ImageProcessor ip, nipLast;
	private ImageProcessor nip, nip2;
	private AreaAveragingScaleFilter scale;
	private ReplicateScaleFilter repScale;
	private RescaleOp opScale;
	private int numberResult;
	
	public ResizeImage(int numberResult) {
		this.numberResult = numberResult;
	}
		
	
///////////resize obrazku, tak aby bol mensi ako 1000 x dopocitane////////////////
	public void runScale(ImagePlus imp, boolean draw){
		ip = imp.getProcessor();
		
		if ((ip.getHeight() > 1000) || (ip.getWidth() > 1000)) {
		
			int scaleX;
			int scaleY;
			
			if (ip.getHeight() > ip.getWidth()) {
				// ip.getHeight() ... 100%
				double onePerc = ip.getHeight() / 100; //1%
				double numberMinusPerc = (ip.getHeight() - 1000) / onePerc; // pocet percent o kolke sme zmensili
				
				// ip.getWidth() ... 100%
				double onePerc2 = ip.getWidth() / 100; //1%
				scaleX = (int)(ip.getWidth() - (numberMinusPerc * onePerc2));
				scaleY = 1000;
			} else {
				// ip.getWidth() ... 100%
				double onePerc = ip.getWidth() / 100; //1%
				double numberMinusPerc = (ip.getWidth() - 1000) / onePerc; // pocet percent o kolke sme zmensili
				
				// ip.getWidth() ... 100%
				double onePerc2 = ip.getHeight() / 100; //1%
				scaleY = (int)(ip.getHeight() - (numberMinusPerc * onePerc2));
				scaleX = 1000;
			}
	
			impLast = NewImage.createImage ("Normalization", scaleX, scaleY, 1, 8, NewImage.FILL_WHITE);
			nipLast = impLast.getProcessor();
	
			//scale = new AreaAveragingScaleFilter(38,38);
			repScale = new ReplicateScaleFilter(scaleX,scaleY);
			//	opScale = new RescaleOp(38,38);
			ImageProducer filteredImageSource = new FilteredImageSource(imp.getImage().getSource(), repScale); 
			Image averimg;
			averimg = java.awt.Toolkit.getDefaultToolkit().createImage(filteredImageSource); 
										
			imp3 = new ImagePlus();
			imp3.setImage(averimg);
			nip2 = imp3.getProcessor();
										
			for (int k = 0; k < nip2.getWidth(); k++) {
				for (int index = 0; index < nip2.getHeight(); index++) {
					nipLast.putPixel(k, index, nip2.getPixel(k, index));
				}
			}					
	
			if (draw) {
				mainWindow.intFrameArrayList.add(new internalFrame("Words Separation", impLast, FileChooser.number, numberResult, 1, true));
				try {
					//mainWindow.intFrame[FileChooser.number].setSelected(true);
					((internalFrame)(mainWindow.intFrameArrayList.get(FileChooser.number))).setSelected(true);
				} catch(Exception e){
					System.out.println("Chyba");
				}	
				++FileChooser.number;
			}
		
		} else {
			impLast = imp;
			nipLast = ip;
			
		}
	}
	
	public ImagePlus getImg(){
		String a = impLast.getTitle();
		return impLast;
	}
	
	public ImageProcessor getIp(){
		return nipLast;
	}
}

