/// unit zobrazujuci Log okno
unit logframe;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ImgList, ComCtrls, ToolWin, constants;

type
  /// trieda zobrazujuca Log okno
  TLogForm = class(TForm)
    Memo1: TMemo;
    ToolBar1: TToolBar;
    NewTB: TToolButton;
    OpenTB: TToolButton;
    SaveTB: TToolButton;
    ImageList1: TImageList;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure SaveTBClick(Sender: TObject);
    procedure OpenTBClick(Sender: TObject);
    procedure NewTBClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    FLoadedPath: xString;
    procedure AddLine(S: xString);
    procedure Add(S: xString);
    function write(const args: array of const): xString;
    function writeln(const args: array of const): xString;
    { Public declarations }
  end;

var
  LogForm: TLogForm;

implementation

{$R *.dfm}

uses StrUtils;

/// procedura inicializujuca Log okno
procedure TLogForm.FormCreate(Sender: TObject);
begin
  DoubleBuffered := true;
  Memo1.DoubleBuffered := true;
end;

/// procedura vymaze obsah Log okna
procedure TLogForm.NewTBClick(Sender: TObject);
begin
  FLoadedPath := '';
  Memo1.Clear;
//  Memo1.Text := Memo1.Text + self.writeln([5,'temp',7.5]);
end;

/// procedura nacita subor a zobrazi ho v Log okne
procedure TLogForm.OpenTBClick(Sender: TObject);
begin
  OpenDialog1.Title := 'Load Log File';
//  OpenDialog1.DefaultExt := 'txt';
  OpenDialog1.Filter := 'Text Files (*.*)|*.*';
  if OpenDialog1.Execute then begin
    try
      Memo1.Lines.LoadFromFile(OpenDialog1.FileName);
    except
    end;
  end;
end;

/// procedura ukladajuca obsah Log okna do suboru
procedure TLogForm.SaveTBClick(Sender: TObject);
begin
  SaveDialog1.FileName := FLoadedPath;
  SaveDialog1.Title := 'Save Input File';
//  SaveDialog1.DefaultExt := 'txt';
  SaveDialog1.Filter := 'Text Files (*.*)|*.*';
  if SaveDialog1.Execute then begin
    try
      Memo1.Lines.SaveToFile(SaveDialog1.FileName);
      FLoadedPath := SaveDialog1.FileName;
      Caption := FLoadedPath;
    except
    end;
  end;
end;

/// procedura pridavajuca string S do Log okna + ukonci momentalny riadok
procedure TLogForm.AddLine(S: xString);
begin
  Memo1.Lines.Add(S);
end;

/// procedura pridavajuca string do Log okna
procedure TLogForm.Add(S: xString);
begin
  Memo1.Lines[Memo1.Lines.Count - 1] :=  Memo1.Lines[Memo1.Lines.Count - 1] + S;
end;

const
  TypeNames : array [vtInteger..vtClass] of PChar  =
   ('Integer', 'Boolean', 'Char', 'Extended', 'String',
    'Pointer', 'PChar', 'Object', 'Class');

/// funkcia v variabilnym poctom parametrov simulujuca writeln, zobrazujuca ho
/// do Log okna
function TLogForm.writeln(const args: array of const): xString;
var ArgsTyped: array [0..$fff0 div sizeof(TVarRec)] of TVarRec absolute Args;
    i: Integer;
    S: xString;
begin
  S := '';
  if Memo1 <> nil then begin
    for i := Low(Args) to High(Args) do begin
      with ArgsTyped[i] do begin
        case VType of
          vtInteger: S := S + IntToStr(VInteger);
          vtBoolean: ;
          vtChar: ;
          vtExtended: ;
          vtString: S := S + PChar(VString);
          vtPointer: ;
          vtPChar: S := S + VPChar;
          vtObject: ;
          vtClass: ;
          vtAnsiString: S := S + PChar(VAnsiString);
        end;
      end;
    end;
    Memo1.Lines.Add(S);
  end;
  result := S;
end;

/// funkcia v variabilnym poctom parametrov simulujuca write, zobrazujuca ho
/// do Log okna
function TLogForm.write(const args: array of const): xString;
var ArgsTyped: array [0..$fff0 div sizeof(TVarRec)] of TVarRec absolute Args;
    i: Integer;
    S: xString;
begin
  S := '';
  if Memo1 <> nil then begin
    for i := Low(Args) to High(Args) do begin
      with ArgsTyped[i] do begin
        case VType of
          vtInteger: S := S + IntToStr(VInteger);
          vtBoolean: ;
          vtChar: ;
          vtExtended: ;
          vtString: S := S + PChar(VString);
          vtPointer: ;
          vtPChar: S := S + VPChar;
          vtObject: ;
          vtClass: ;
          vtAnsiString: S := S + PChar(VAnsiString);
        end;
      end;
    end;
    Memo1.Lines[Memo1.Lines.Count-1] := Memo1.Lines[Memo1.Lines.Count-1] + S;
  end;
  result := S;
end;

end.
