/// unit obsahujuci a obsluhujuci hlavne MDI okno
{$I main.inc}
unit mainframe;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ToolWin, ComCtrls, ImgList, grammaredit;

type
  /// trieda zobrazujuca hlavne okno a hlavne menu
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    N2: TMenuItem;
    About1: TMenuItem;
    Window1: TMenuItem;
    StatusBar1: TStatusBar;
    ToolBar1: TToolBar;
    TileHorizontaly1: TMenuItem;
    TileVerticaly1: TMenuItem;
    Cascade1: TMenuItem;
    ArrangeIcons1: TMenuItem;
    N3: TMenuItem;
    RestoreAll1: TMenuItem;
    MinimizeAll1: TMenuItem;
    CloseAll1: TMenuItem;
    NextWindow1: TMenuItem;
    PreviousWindow1: TMenuItem;
    ShowFolderDiffTB: TToolButton;
    ShowFileDiffTB: TToolButton;
    ShowTestTB: TToolButton;
    ShowGrammarEditTB: TToolButton;
    ShowLFormTB: TToolButton;
    ShowRFormTB: TToolButton;
    ImageList1: TImageList;
    Help2: TMenuItem;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    Options1: TMenuItem;
    FileDiff1: TMenuItem;
    Close1: TMenuItem;
    FolderDiff1: TMenuItem;
    Editor1: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    Close2: TMenuItem;
    N7: TMenuItem;
    Close3: TMenuItem;
    OpenDirectory11: TMenuItem;
    OpenDirectory21: TMenuItem;
    RecursiveSubfolders1: TMenuItem;
    N8: TMenuItem;
    QuickCompare1: TMenuItem;
    Compare1: TMenuItem;
    N9: TMenuItem;
    N10: TMenuItem;
    Refresh1: TMenuItem;
    Stop1: TMenuItem;
    SynchronizedScrollBars1: TMenuItem;
    N11: TMenuItem;
    N12: TMenuItem;
    N13: TMenuItem;
    OpenFile11: TMenuItem;
    OpenFile21: TMenuItem;
    CompareID1: TMenuItem;
    CompareIDU1: TMenuItem;
    NextDifference1: TMenuItem;
    PrevDifference1: TMenuItem;
    Refresh2: TMenuItem;
    Stop2: TMenuItem;
    N14: TMenuItem;
    SynchronizedScrollbars2: TMenuItem;
    N15: TMenuItem;
    SaveDiffsToFile1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    N16: TMenuItem;
    Find1: TMenuItem;
    Replace1: TMenuItem;
    N17: TMenuItem;
    Undo1: TMenuItem;
    Redo1: TMenuItem;
    N18: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N19: TMenuItem;
    EnterGrammar1: TMenuItem;
    BuildParser1: TMenuItem;
    ShowTokenTableTB: TToolButton;
    ShowRuleTableTB: TToolButton;
    ShowLALRTablesTB: TToolButton;
    ShowDFATableTB: TToolButton;
    ToolButton4: TToolButton;
    ShowLogFormTB: TToolButton;
    ToolButton3: TToolButton;
    GlobalHaltTB: TToolButton;
    BuildParseTree1: TMenuItem;
    SaveFile11: TMenuItem;
    SaveFile21: TMenuItem;
    ShowFiles1: TMenuItem;
    EquivalenceStructuralDifference1: TMenuItem;
    QuickerStructuralDifference1: TMenuItem;
    Formatting1: TMenuItem;
    N20: TMenuItem;
    QuickStart1: TMenuItem;
    GrammarCreationWizard1: TMenuItem;
    View1: TMenuItem;
    N4: TMenuItem;
    FolderDifference1: TMenuItem;
    FileDiffernce1: TMenuItem;
    N21: TMenuItem;
    N22: TMenuItem;
    GrammarEditor1: TMenuItem;
    File1Editor1: TMenuItem;
    File2Editor1: TMenuItem;
    okenTable1: TMenuItem;
    RuleTable1: TMenuItem;
    DFATable1: TMenuItem;
    LALRTabe1: TMenuItem;
    ViewLog1: TMenuItem;
    N23: TMenuItem;
    ResetLayout1: TMenuItem;
    N24: TMenuItem;
    Halt1: TMenuItem;
    HelpOpenDialog1: TOpenDialog;
    ShowParseTrees1: TMenuItem;
    N25: TMenuItem;
    ShowOptionsTB: TToolButton;
    ShowHelpTB: TToolButton;
    procedure QuickStart1Click(Sender: TObject);
    procedure ShowHelpTBClick(Sender: TObject);
    procedure ShowOptionsTBClick(Sender: TObject);
    procedure ShowParseTrees1Click(Sender: TObject);
    procedure ResetLayout1Click(Sender: TObject);
    procedure SaveFile21Click(Sender: TObject);
    procedure SaveFile11Click(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure Formatting1Click(Sender: TObject);
    procedure QuickerStructuralDifference1Click(Sender: TObject);
    procedure EquivalenceStructuralDifference1Click(Sender: TObject);
    procedure ShowFiles1Click(Sender: TObject);
    procedure BuildParseTree1Click(Sender: TObject);
    procedure GlobalHaltTBClick(Sender: TObject);
    procedure ShowLogFormTBClick(Sender: TObject);
    procedure ShowDFATableTBClick(Sender: TObject);
    procedure ShowLALRTablesTBClick(Sender: TObject);
    procedure ShowRuleTableTBClick(Sender: TObject);
    procedure ShowTokenTableTBClick(Sender: TObject);
    procedure BuildParser1Click(Sender: TObject);
    procedure EnterGrammar1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Redo1Click(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure Replace1Click(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure SaveDiffsToFile1Click(Sender: TObject);
    procedure NextDifference1Click(Sender: TObject);
    procedure PrevDifference1Click(Sender: TObject);
    procedure Stop2Click(Sender: TObject);
    procedure Refresh2Click(Sender: TObject);
    procedure CompareIDU1Click(Sender: TObject);
    procedure CompareID1Click(Sender: TObject);
    procedure OpenFile21Click(Sender: TObject);
    procedure OpenFile11Click(Sender: TObject);
    procedure SynchronizedScrollbars2Click(Sender: TObject);
    procedure Stop1Click(Sender: TObject);
    procedure Refresh1Click(Sender: TObject);
    procedure Compare1Click(Sender: TObject);
    procedure SynchronizedScrollBars1Click(Sender: TObject);
    procedure QuickCompare1Click(Sender: TObject);
    procedure RecursiveSubfolders1Click(Sender: TObject);
    procedure OpenDirectory21Click(Sender: TObject);
    procedure OpenDirectory11Click(Sender: TObject);
    procedure Close3Click(Sender: TObject);
    procedure Close2Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Options1Click(Sender: TObject);
    procedure ShowRFormTBClick(Sender: TObject);
    procedure ShowLFormTBClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    procedure ShowGrammarEditTBClick(Sender: TObject);
    procedure ShowTestTBClick(Sender: TObject);
    procedure ShowFileDiffTBClick(Sender: TObject);
    procedure ShowFolderDiffTBClick(Sender: TObject);
    procedure PreviousWindow1Click(Sender: TObject);
    procedure NextWindow1Click(Sender: TObject);
    procedure CloseAll1Click(Sender: TObject);
    procedure MinimizeAll1Click(Sender: TObject);
    procedure RestoreAll1Click(Sender: TObject);
    procedure ArrangeIcons1Click(Sender: TObject);
    procedure Cascade1Click(Sender: TObject);
    procedure TileVerticaly1Click(Sender: TObject);
    procedure TileHorizontaly1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Main(var Msg: TMessage); message WM_USER;
  private
    FStart: Boolean;
    procedure LoadOptions;
    procedure SaveOptions;
    procedure MyShowChildForm(Form: TForm);
    procedure MyExceptionHandler(Sender: TObject; E: Exception);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  GlobalStop: Boolean;
  LForm: TGrammarEditForm;
  RForm: TGrammarEditForm;

implementation

uses IniFiles,about, filediff, folderdiff, options, constants, tableframe, LALRtable,
  DFAtable, logframe, WinHelpViewer;

{$R *.dfm}

/// procedura obsluhujuca stlacenie tlacidla About v hlavnom menu
procedure TMainForm.About1Click(Sender: TObject);
begin
  AboutBox := TAboutBox.Create(self);
  AboutBox.ShowModal;
  AboutBox.Free;
end;

/// procedura obsluhujuca stlacenie tlacidla Exit v hlavnom menu
procedure TMainForm.Exit1Click(Sender: TObject);
begin
  MainForm.Close;
end;

/// procedura nacitavajuca nastavenia z .ini suboru pri starte programu
procedure TMainForm.LoadOptions;
var l,t,w,h: integer;
    S: xString;
begin
  with TIniFile.create(changefileext(paramstr(0),'.ini')) do begin
    try
      l := ReadInteger('Positions','Left', 0);
      t := ReadInteger('Positions','Top', 0);
      w := ReadInteger('Positions','Width', -1);
      h := ReadInteger('Positions','Height', -1);

      COLOR_TEXTBACKGROUND := StrToIntDef(ReadString('Colors','TextBackGroundColor',''),COLOR_TEXTBACKGROUND);
      COLOR_GUTTER := StrToIntDef(ReadString('Colors','GutterColor',''),COLOR_GUTTER);
      COLOR_NEWGUTTER := StrToIntDef(ReadString('Colors','NewGutterColor',''),COLOR_NEWGUTTER);
      COLOR_INSERT := StrToIntDef(ReadString('Colors','InsertColor',''),COLOR_INSERT);
      COLOR_DELETE := StrToIntDef(ReadString('Colors','DeleteColor',''),COLOR_DELETE);
      COLOR_CHANGE := StrToIntDef(ReadString('Colors','ChangeColor',''),COLOR_CHANGE);
      COLOR_MATCH := StrToIntDef(ReadString('Colors','MatchColor',''),COLOR_MATCH);
      COLOR_NOT_COMPARED := StrToIntDef(ReadString('Colors','NotComparedColor',''),COLOR_NOT_COMPARED);

      FAlwaysConvertToDFA := ReadBool('Options','AlwaysConvertToDFA',FAlwaysConvertToDFA);

      FSelectedLineLCS := ReadBool('Options','SelectedLineLCS',FSelectedLineLCS);

      FListBoxLogsEnabled := ReadBool('Options','ListBoxLogsEnabled',FListBoxLogsEnabled);
      FListBoxShowErrors := ReadBool('Options','ListBoxShowErrors',FListBoxShowErrors);
      FListBoxShowWarnings := ReadBool('Options','ListBoxShowWarnings',FListBoxShowWarnings);
      FListBoxShowMiscs := ReadBool('Options','ListBoxShowMiscs',FListBoxShowMiscs);

      Application.HelpFile := ReadString('Paths','HelpFilePath',changefileext(ParamStr(0),'.hlp'));
      if not FileExists(Application.HelpFile) then
        Application.HelpFile := changefileext(ParamStr(0),'.hlp');

      S := ReadString('Paths','LastGrammarPath','');
      if FileExists(S) then
        LastGrammarPath := S;
      S := ReadString('Paths','LastLeftPath','');
      if FileExists(S) then
        LastLeftPath := S;
      S := ReadString('Paths','LastRightPath','');
      if FileExists(S) then
        LastRightPath := S;
      S := ReadString('Paths','LastFolderDir1Path','');
      if DirectoryExists(S) then
        LastFolderDir1Path := S;
      S := ReadString('Paths','LastFolderDir2Path','');
      if DirectoryExists(S) then
        LastFolderDir2Path := S;
      S := ReadString('Paths','LastFile1Path','');
      if FileExists(S) then
        LastFile1Path := S;
      S := ReadString('Paths','LastFile2Path','');
      if FileExists(S) then
        LastFile2Path := S;

      DEFAULT_CASE_SENSITIVITY := ReadBool('Options','DEFAULT_CASE_SENSITIVITY',DEFAULT_CASE_SENSITIVITY);
      DEFAULT_PARSE_COMMENTS := ReadBool('Options','DEFAULT_PARSE_COMMENTS',DEFAULT_PARSE_COMMENTS);
      MULTI_LINE_COMMENTS_IND := ReadBool('Options','MULTI_LINE_COMMENTS_IND',MULTI_LINE_COMMENTS_IND);
      TREE_FORMATTING := ReadBool('Options','TREE_FORMATTING',TREE_FORMATTING);

      SANE_ARRAY_SIZE_LIMIT := ReadInteger('Options','SANE_ARRAY_SIZE_LIMIT',SANE_ARRAY_SIZE_LIMIT);
      CYCLE_THRESHOLD := ReadInteger('Options','CYCLE_THRESHOLD',CYCLE_THRESHOLD);
      TAB_SPACES := ReadInteger('Options','TAB_SPACES',TAB_SPACES);
      MAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS := ReadInteger('Options','MAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS',MAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS);
      MAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE := ReadInteger('Options','MAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE',MAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE);
      PARSE_ERRORS_THRESHOLD := ReadInteger('Options','PARSE_ERRORS_THRESHOLD',PARSE_ERRORS_THRESHOLD);
      LEX_ERRORS_THRESHOLD := ReadInteger('Options','LEX_ERRORS_THRESHOLD',LEX_ERRORS_THRESHOLD);

      DIFF_CASE_SENSITIVE := ReadBool('Options','DIFF_CASE_SENSITIVE',DIFF_CASE_SENSITIVE);
      DIFF_WS_FILTERING := ReadBool('Options','DIFF_WS_FILTERING',DIFF_WS_FILTERING);

      S := ReadString('Options','DIFF_WS','');
      if S <> '' then
        DIFF_WS := resolveSimpleSeq(S);

      DEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE := ReadInteger('Options','DEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE',DEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE);
      DEFAULT_EQ_SCORE := ReadInteger('Options','DEFAULT_EQ_SCORE',DEFAULT_EQ_SCORE);
      DEFAULT_SIM_SCORE := ReadInteger('Options','DEFAULT_SIM_SCORE',DEFAULT_SIM_SCORE);

      FXSynchronizedScrollBars := ReadBool('Options','FolderViewSynchronizedScrollBars',FXSynchronizedScrollBars);
      FYSynchronizedScrollBars := ReadBool('Options','FileViewSynchronizedScrollBars',FYSynchronizedScrollBars);
      FXRecursiveFolders := ReadBool('Options','RecursiveFolders',FXRecursiveFolders);
      FEnabledFormatting := ReadBool('Options','EnabledFormatting',FEnabledFormatting);
      FFormattingWithBkColor := ReadBool('Options','FormattingWithBkColor',FFormattingWithBkColor);
      FDisableWSDiffsColoring := ReadBool('Options','DisableWSDiffsColoring',FDisableWSDiffsColoring);

      TSTYLE_DEFAULT_INT := ReadInteger('Options','TSTYLE_DEFAULT_INT',TSTYLE_DEFAULT_INT);

      TCOLOR_DEFAULT := StrToIntDef(ReadString('Colors','TCOLOR_DEFAULT',''),TCOLOR_DEFAULT);
      COLOR_COMBINED := StrToIntDef(ReadString('Colors','COLOR_COMBINED',''),COLOR_COMBINED);
      COLOR_PB_SCROLLBAR_OUTLINE := StrToIntDef(ReadString('Colors','COLOR_PB_SCROLLBAR_OUTLINE',''),COLOR_PB_SCROLLBAR_OUTLINE);
      TCOLOR_GUTTER := StrToIntDef(ReadString('Colors','TCOLOR_GUTTER',''),TCOLOR_GUTTER);
      TCOLOR_NEWGUTTER := StrToIntDef(ReadString('Colors','TCOLOR_NEWGUTTER',''),TCOLOR_NEWGUTTER);
      TCOLOR_COMBINED := StrToIntDef(ReadString('Colors','TCOLOR_COMBINED',''),TCOLOR_COMBINED);

      TCOLOR_INSERT := StrToIntDef(ReadString('Colors','TCOLOR_INSERT',''),TCOLOR_INSERT);
      TCOLOR_DELETE := StrToIntDef(ReadString('Colors','TCOLOR_DELETE',''),TCOLOR_DELETE);
      TCOLOR_CHANGE := StrToIntDef(ReadString('Colors','TCOLOR_CHANGE',''),TCOLOR_CHANGE);
      TCOLOR_MATCH := StrToIntDef(ReadString('Colors','TCOLOR_MATCH',''),TCOLOR_MATCH);
      TCOLOR_NOT_COMPARED := StrToIntDef(ReadString('Colors','TCOLOR_NOT_COMPARED',''),TCOLOR_NOT_COMPARED);

      NEW_LINE_PREV_LINE_TOKEN_ASPACES := ReadBool('Options','NEW_LINE_PREV_LINE_TOKEN_ASPACES',NEW_LINE_PREV_LINE_TOKEN_ASPACES);

    except
      Position := poScreenCenter;

      RecursiveSubfolders1.Checked := FXRecursiveFolders;
      SynchronizedScrollBars1.Checked := FXSynchronizedScrollBars;
      SynchronizedScrollBars2.Checked := FYSynchronizedScrollBars;
      Formatting1.Checked := FEnabledFormatting;

      Free;
      exit;
    end;
  end;
//  COLOR_TEXTBACKGROUND := BRIGHTER_COLOR(COLOR_TEXTBACKGROUND);
//  COLOR_GUTTER := BRIGHTER_COLOR(COLOR_GUTTER);
//  COLOR_NEWGUTTER := BRIGHTER_COLOR(COLOR_NEWGUTTER);
(*  COLOR_INSERT := BRIGHTER_COLOR(COLOR_INSERT);
  COLOR_DELETE := BRIGHTER_COLOR(COLOR_DELETE);
  COLOR_CHANGE := BRIGHTER_COLOR(COLOR_CHANGE);
  COLOR_MATCH := BRIGHTER_COLOR(COLOR_MATCH);
  COLOR_NOT_COMPARED := BRIGHTER_COLOR(COLOR_NOT_COMPARED);*)

  if (w > 0) and (h > 0) and (l < screen.Width) and (t < screen.Height) and (l+w > 0) and (t+h > 0) then
    setbounds(l,t,w,h)
  else
    Position := poScreenCenter;

  RecursiveSubfolders1.Checked := FXRecursiveFolders;
  SynchronizedScrollBars1.Checked := FXSynchronizedScrollBars;
  SynchronizedScrollBars2.Checked := FYSynchronizedScrollBars;
  Formatting1.Checked := FEnabledFormatting;

end;
//---------------------------------------------------------------------

/// procedura ukladajuca nastavenia do .ini suboru pri ukonceni programu
procedure TMainForm.SaveOptions;
var S: xString;
    i: Integer;
begin
  with TIniFile.create(changefileext(paramstr(0),'.ini')) do begin
    try
      if WindowState = wsNormal then
      begin
        WriteInteger('Positions','Left', self.Left);
        WriteInteger('Positions','Top', self.Top);
        WriteInteger('Positions','Width', self.Width);
        WriteInteger('Positions','Height', self.Height);
      end;

      WriteString('Colors','TextBackGroundColor', IntToStr(COLOR_TEXTBACKGROUND));
      WriteString('Colors','GutterColor', IntToStr(COLOR_GUTTER));
      WriteString('Colors','NewGutterColor', IntToStr(COLOR_NEWGUTTER));
      WriteString('Colors','InsertColor', IntToStr(COLOR_INSERT));
      WriteString('Colors','DeleteColor', IntToStr(COLOR_DELETE));
      WriteString('Colors','ChangeColor', IntToStr(COLOR_CHANGE));
      WriteString('Colors','MatchColor', IntToStr(COLOR_MATCH));
      WriteString('Colors','NotComparedColor', IntToStr(COLOR_NOT_COMPARED));

      WriteBool('Options','AlwaysConvertToDFA',FAlwaysConvertToDFA);

      WriteBool('Options','SelectedLineLCS',FSelectedLineLCS);

      WriteBool('Options','ListBoxLogsEnabled',FListBoxLogsEnabled);
      WriteBool('Options','ListBoxShowErrors',FListBoxShowErrors);
      WriteBool('Options','ListBoxShowWarnings',FListBoxShowWarnings);
      WriteBool('Options','ListBoxShowMiscs',FListBoxShowMiscs);

      WriteString('Paths','HelpFilePath',Application.HelpFile);
      WriteString('Paths','LastGrammarPath',GrammarEditForm.FLoadedPath);
      WriteString('Paths','LastLeftPath',LForm.FLoadedPath);
      WriteString('Paths','LastRightPath',RForm.FLoadedPath);
      WriteString('Paths','LastFolderDir1Path',FolderDiffForm.FBaseDir1);
      WriteString('Paths','LastFolderDir2Path',FolderDiffForm.FBaseDir2);
      WriteString('Paths','LastFile1Path',FileDiffForm.MyEdit1.FPath);
      WriteString('Paths','LastFile2Path',FileDiffForm.MyEdit2.FPath);

      WriteBool('Options','DEFAULT_CASE_SENSITIVITY',DEFAULT_CASE_SENSITIVITY);
      WriteBool('Options','DEFAULT_PARSE_COMMENTS',DEFAULT_PARSE_COMMENTS);
      WriteBool('Options','MULTI_LINE_COMMENTS_IND',MULTI_LINE_COMMENTS_IND);
      WriteBool('Options','TREE_FORMATTING',TREE_FORMATTING);

      WriteInteger('Options','SANE_ARRAY_SIZE_LIMIT',SANE_ARRAY_SIZE_LIMIT);
      WriteInteger('Options','CYCLE_THRESHOLD',CYCLE_THRESHOLD);
      WriteInteger('Options','TAB_SPACES',TAB_SPACES);
      WriteInteger('Options','MAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS',MAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS);
      WriteInteger('Options','MAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE',MAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE);
      WriteInteger('Options','PARSE_ERRORS_THRESHOLD',PARSE_ERRORS_THRESHOLD);
      WriteInteger('Options','LEX_ERRORS_THRESHOLD',LEX_ERRORS_THRESHOLD);

      WriteBool('Options','DIFF_CASE_SENSITIVE',DIFF_CASE_SENSITIVE);
      WriteBool('Options','DIFF_WS_FILTERING',DIFF_WS_FILTERING);

      S := makeSimpleSeq(DIFF_WS);
      WriteString('Options','DIFF_WS',S);

      WriteInteger('Options','DEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE',DEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE);
      WriteInteger('Options','DEFAULT_EQ_SCORE',DEFAULT_EQ_SCORE);
      WriteInteger('Options','DEFAULT_SIM_SCORE',DEFAULT_SIM_SCORE);

      WriteBool('Options','FolderViewSynchronizedScrollBars',FXSynchronizedScrollBars);
      WriteBool('Options','FileViewSynchronizedScrollBars',FYSynchronizedScrollBars);
      WriteBool('Options','RecursiveFolders',FXRecursiveFolders);
      WriteBool('Options','EnabledFormatting',FEnabledFormatting);
      WriteBool('Options','FormattingWithBkColor',FFormattingWithBkColor);
      WriteBool('Options','DisableWSDiffsColoring',FDisableWSDiffsColoring);

      WriteInteger('Options','TSTYLE_DEFAULT_INT',TSTYLE_DEFAULT_INT);

      WriteString('Colors','TCOLOR_DEFAULT',IntToStr(TCOLOR_DEFAULT));
      WriteString('Colors','COLOR_COMBINED',IntToStr(COLOR_COMBINED));
      WriteString('Colors','COLOR_PB_SCROLLBAR_OUTLINE',IntToStr(COLOR_PB_SCROLLBAR_OUTLINE));
      WriteString('Colors','TCOLOR_GUTTER',IntToStr(TCOLOR_GUTTER));
      WriteString('Colors','TCOLOR_NEWGUTTER',IntToStr(TCOLOR_NEWGUTTER));
      WriteString('Colors','TCOLOR_COMBINED',IntToStr(TCOLOR_COMBINED));

      WriteString('Colors','TCOLOR_INSERT',IntToStr(TCOLOR_INSERT));
      WriteString('Colors','TCOLOR_DELETE',IntToStr(TCOLOR_DELETE));
      WriteString('Colors','TCOLOR_CHANGE',IntToStr(TCOLOR_CHANGE));
      WriteString('Colors','TCOLOR_MATCH',IntToStr(TCOLOR_MATCH));
      WriteString('Colors','TCOLOR_NOT_COMPARED',IntToStr(TCOLOR_NOT_COMPARED));

      WriteBool('Options','NEW_LINE_PREV_LINE_TOKEN_ASPACES',NEW_LINE_PREV_LINE_TOKEN_ASPACES);

    except
      Free;
      exit;
    end;
    Free;
  end;
end;

/// procedura spracuvajuca globalne vynimky v aplikacii, zobrazi ich v Log okne a odblokuje disablovane tlacidla
procedure TMainForm.MyExceptionHandler(Sender: TObject; E: Exception);
begin
  if LogForm <> nil then
    LogForm.AddLine('GLOBAL EXCEPTION: ' + E.Message);
  if FDisableCount > 0 then begin
    FDisableCount := 1;
    if FileDiffForm <> nil then
      FileDiffForm.EnableAll;
  end;
end;

/// procedura pustajuca sa tesne po vytvoreni hlavneho okna, inicializuje a nacitava nastavenia zo suboru
procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnException := MyExceptionHandler;

  FStart := true;
  Caption := Application.Title;
  FCurrentDirectory := ExtractFilePath(Application.EXEName);
  LastGrammarPath := FCurrentDirectory + LastGrammarPath;
  LastLeftPath := FCurrentDirectory + LastLeftPath;
  LastRightPath := FCurrentDirectory + LastRightPath;
  LastFolderDir1Path := FCurrentDirectory + LastFolderDir1Path;
  LastFolderDir2Path := FCurrentDirectory + LastFolderDir2Path;
  LastFile1Path := FCurrentDirectory + LastFile1Path;
  LastFile2Path := FCurrentDirectory + LastFile2Path;

  LoadOptions;
{$IFDEF TESTFORM}
  ShowTestTB.Visible := true;
{$ENDIF}
end;

/// procedura volajuca proceduru main cez spravu v hlavnom message stacku aplikacie
procedure TMainForm.FormShow(Sender: TObject);
begin
  if FStart then begin
    PostMessage(handle,WM_USER,0,0);
    FStart := false;
  end;
end;

/// procedura vytvarajuca a inicializujuca MDI okna v aplikacii
procedure TMainForm.Main(var Msg: TMessage);
var i,x: Integer;
begin
(*  Application.CreateForm(TTestForm, TestForm);
  Application.CreateForm(TFileDiffForm, FileDiffForm);
  Application.CreateForm(TFolderDiffForm, FolderDiffForm);*)
//  DFATableForm.windowstate := wsmaximized;

//  FolderDiffForm := TFolderDiffForm.Create(self);
//  FileDiffForm := TFileDiffForm.Create(self);

  GrammarEditForm := TGrammarEditForm.CreateNamed(self,'Grammar File Editor',true);
  LForm := TGrammarEditForm.CreateNamed(self,'Left File Editor',false);
  RForm := TGrammarEditForm.CreateNamed(self,'Right File Editor',false);

  TokenTableForm := TTableForm.CreateNamed(self,'Token Table');
  RuleTableForm := TTableForm.CreateNamed(self,'Rule Table');

//  LALRTableForm := TLALRTableForm.Create(self);

//  TestForm := TTestForm.Create(self);



  FolderDiffForm.WindowState := wsNormal;
  ArrangeIcons1Click(self);
//  FileDiffForm.WindowState := wsMaximized;
end;


/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.TileHorizontaly1Click(Sender: TObject);
begin
  TileMode :=  tbHorizontal;
  Tile;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.TileVerticaly1Click(Sender: TObject);
begin
  TileMode :=  tbVertical;
  Tile;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Cascade1Click(Sender: TObject);
begin
  Cascade;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.ArrangeIcons1Click(Sender: TObject);
begin
  ArrangeIcons;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.RestoreAll1Click(Sender: TObject);
var I: Integer;
    last: Integer;
begin
  last := Pred(MDIChildCount);
  for I := 0 to last do begin
//    ActiveMDIChild.WindowState := wsNormal;
//    Next;
    MDIChildren[I].WindowState := wsNormal;
//    MDIChildren[I].Caption := IntToStr(i) + 'Normal';
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.MinimizeAll1Click(Sender: TObject);
var I: Integer;
begin
  for I := Pred(MDIChildCount) downto 0 do begin
    MDIChildren[I].WindowState := wsMinimized;
//    MDIChildren[I].Caption := IntToStr(i) + 'Minimized';
  end;
  Caption := MDIChildren[0].Caption;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.CloseAll1Click(Sender: TObject);
var I: Integer;
begin
  for I := Pred(MDIChildCount) downto 0 do begin
    MDIChildren[I].Close;  //WindowState := wsMinimized;
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.NextWindow1Click(Sender: TObject);
begin
  Next;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.PreviousWindow1Click(Sender: TObject);
begin
  Previous;
end;

/// procedura na zobrazenie urciteho MDI okna (podla vstupneho parametra - Form)
procedure TMainForm.MyShowChildForm(Form: TForm);
var state: TWindowState;
begin
  state := wsNormal;
  if Form = nil then
    Exit;
  if (ActiveMDIChild <> nil) then begin
    if (ActiveMDIChild <> Form) then begin
      if ActiveMDIChild.WindowState = wsMaximized then begin
         Form.WindowState := wsNormal;  //toto je tu treba - inak problemy - skoda
         Form.BringToFront;
         Form.SetFocus;
      end
      else begin
         Form.WindowState := wsNormal;
         Form.BringToFront;
         Form.SetFocus;
      end;
    end
    else begin
      if ActiveMDIChild.WindowState = wsMinimized then begin
        Form.WindowState := wsNormal;
      end
    end;
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowFolderDiffTBClick(Sender: TObject);
begin
  MyShowChildForm(FolderDiffForm);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowFileDiffTBClick(Sender: TObject);
begin
  MyShowChildForm(FileDiffForm);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowTestTBClick(Sender: TObject);
begin
//  MyShowChildForm(TestForm);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowGrammarEditTBClick(Sender: TObject);
begin
  MyShowChildForm(GrammarEditForm);
end;

/// procedura pustajuca sa tesne pred ukoncenim aplikacie, dava moznost ulozit zmenene subory, pripadne zrusit ukoncenie aplikacie
/// v pripade skutocneho ukoncenia uklada zmeny do suboru s nastaveniami (.ini subor)
procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var b: Boolean;
    stopwatch: Integer;
begin
  CanClose := false;
  if FDisableCount <> 0 then begin
    FGlobalHalt := true;
    Exit;
  end;

  if GrammarEditForm.RichEdit1.Modified <> false then begin
    MyShowChildForm(GrammarEditForm);
    if not GrammarEditForm.LooseChangesConfirm(Sender) then
      Exit;
  end;

  if LForm.RichEdit1.Modified <> false then begin
    MyShowChildForm(LForm);
    if not LForm.LooseChangesConfirm(Sender) then
      Exit;
  end;

  if RForm.RichEdit1.Modified <> false then begin
    MyShowChildForm(RForm);
    if not RForm.LooseChangesConfirm(Sender) then
      Exit;
  end;

  SaveOptions;
  Application.HelpCommand(HELP_QUIT, 0);

  GrammarEditForm.Free;
  LForm.Free;
  RForm.Free;

  FolderDiffForm.Free;
  FileDiffForm.Free;

{$IFDEF TESTFORM}
  TestForm.Free;
{$ENDIF}

  TokenTableForm.Free;
  RuleTableForm.Free;

  LALRTableForm.Free;
  DFATableForm.Free;

  LogForm.Free;

  CanClose := true;
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowLFormTBClick(Sender: TObject);
begin
  MyShowChildForm(LForm);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowRFormTBClick(Sender: TObject);
begin
  MyShowChildForm(RForm);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Options1Click(Sender: TObject);
begin
  OptionsForm.ShowModal;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Close1Click(Sender: TObject);
begin
//  FileDiffForm.Close;
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Close2Click(Sender: TObject);
begin
//  FolderDiffForm.Close;
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Close3Click(Sender: TObject);
begin
  //GrammarEditForm.Close;
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.OpenDirectory11Click(Sender: TObject);
begin
  FolderDiffForm.OpenDir1TBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.OpenDirectory21Click(Sender: TObject);
begin
  FolderDiffForm.OpenDir2TBClick(Sender);
end;


/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.RecursiveSubfolders1Click(Sender: TObject);
begin
  FXRecursiveFolders := RecursiveSubfolders1.checked;
  FolderDiffForm.RecursiveFoldersTB.down := RecursiveSubfolders1.checked;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.QuickCompare1Click(Sender: TObject);
begin
  FolderDiffForm.CompareDirsTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.SynchronizedScrollBars1Click(Sender: TObject);
begin
  FXSynchronizedScrollBars := SynchronizedScrollBars1.checked;
  FolderDiffForm.SynchronizedScrollBarsTB.down := SynchronizedScrollBars1.checked;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Compare1Click(Sender: TObject);
begin
  FolderDiffForm.DiffCompareDirsTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Refresh1Click(Sender: TObject);
begin
  FolderDiffForm.ResetLayoutTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Stop1Click(Sender: TObject);
begin
  FolderDiffForm.HaltTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.SynchronizedScrollbars2Click(Sender: TObject);
begin
  FileDiffForm.SynchronizedScrollBarsTB.down := SynchronizedScrollBars2.checked;
  FYSynchronizedScrollBars := FileDiffForm.SynchronizedScrollBarsTB.down;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.OpenFile11Click(Sender: TObject);
begin
  FileDiffForm.Open1TBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.OpenFile21Click(Sender: TObject);
begin
  FileDiffForm.Open2TBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.CompareID1Click(Sender: TObject);
begin
  FileDiffForm.CompareFilesTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.CompareIDU1Click(Sender: TObject);
begin
  FileDiffForm.AdvCompareFilesTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Refresh2Click(Sender: TObject);
begin
  FileDiffForm.ResetLayoutTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Stop2Click(Sender: TObject);
begin
  FileDiffForm.HaltTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.PrevDifference1Click(Sender: TObject);
begin
  FileDiffForm.PrevDiffTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.NextDifference1Click(Sender: TObject);
begin
  FileDiffForm.NextDiffTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.SaveDiffsToFile1Click(Sender: TObject);
begin
  FileDiffForm.SaveDiffTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.New1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.NewTBClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Open1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.OpenTBClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Save1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.SaveTBClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Find1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.FindTBClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Replace1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.RedoTBClick(Sender);
  end;
end;


/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Undo1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.UndoTBClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Redo1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.RedoTBClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Cut1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.CutTBClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Copy1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.CopyTBClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Paste1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.PasteTBClick(Sender);
  end;
end;


/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.EnterGrammar1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.EnterGrammarButton.OnClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.BuildParser1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.ExtraButton.OnClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowTokenTableTBClick(Sender: TObject);
begin
  MyShowChildForm(TokenTableForm);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowRuleTableTBClick(Sender: TObject);
begin
  MyShowChildForm(RuleTableForm);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowLALRTablesTBClick(Sender: TObject);
begin
  MyShowChildForm(LALRTableForm);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowDFATableTBClick(Sender: TObject);
begin
  MyShowChildForm(DFATableForm);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowLogFormTBClick(Sender: TObject);
begin
  MyShowChildForm(LogForm);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.GlobalHaltTBClick(Sender: TObject);
begin
  FGlobalHalt := true;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.BuildParseTree1Click(Sender: TObject);
var editor: TGrammarEditForm;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TGrammarEditForm) then begin
    editor := TGrammarEditForm(ActiveMDIChild);
    editor.EnterGrammarButton.OnClick(Sender);
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.ShowFiles1Click(Sender: TObject);
begin
  FileDiffForm.HLFMTTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.EquivalenceStructuralDifference1Click(Sender: TObject);
begin
  FileDiffForm.BasicStructCompareTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.QuickerStructuralDifference1Click(Sender: TObject);
begin
  FileDiffForm.BasicStructCompareTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.Formatting1Click(Sender: TObject);
begin
  FileDiffForm.FormattingTB.down := Formatting1.checked;
  FEnabledFormatting := FileDiffForm.FormattingTB.down;
end;

/// procedura obsluhujuca stlacenie tlacidla Help->Contents v hlavnom menu
procedure TMainForm.Help2Click(Sender: TObject);
begin
  if not (FileExists(Application.HelpFile)) then begin
      HelpOpenDialog1.Title := 'Load Help File';
      HelpOpenDialog1.DefaultExt := 'hlp';
      HelpOpenDialog1.Filter := 'Help Files (*.hlp)|*.hlp';
//      HelpOpenDialog1.Filter := 'Help Files (*.hlp)|*.*';

      if HelpOpenDialog1.Execute then begin
        Application.HelpFile := HelpOpenDialog1.FileName;
        Application.HelpCommand(HELP_CONTENTS,0);
      end
      else begin
        LogForm.AddLine('Help file: Impossible to load');
      end;
  end
  else begin
    Application.HelpCommand(HELP_CONTENTS,0);
  end;

//  try
//  except
//    try
(*      Application.HelpFile := changefileext(ParamStr(0),'.hlp');
      Application.HelpCommand(HELP_CONTENTS,0);
    except
      HelpOpenDialog1.Title := 'Load Help File';
      HelpOpenDialog1.Filter := 'Help Files (*.hlp)|*.*';

      if HelpOpenDialog1.Execute then begin
        Application.HelpFile := HelpOpenDialog1.FileName;
        Application.HelpCommand(HELP_CONTENTS,0);
      end
      else begin
        LogForm.AddLine('Help file <exec path>.hlp: Impossible to load');
      end;*)
//    end;
//  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.SaveFile11Click(Sender: TObject);
begin
  FileDiffForm.Save1TBClick(FileDiffForm.MyEdit1);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.SaveFile21Click(Sender: TObject);
begin
  FileDiffForm.Save2TBClick(FileDiffForm.MyEdit2);
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.ResetLayout1Click(Sender: TObject);
begin
  MinimizeAll1Click(Sender);
  ArrangeIcons;
  if FolderDiffForm <> nil then begin
    MyShowChildForm(FolderDiffForm);
    Cascade;

//    FolderDiffForm.Position := poDefault;

//    FolderDiffForm.Position := poDesigned;
//    FolderDiffForm.Position := poDefaultSizeOnly;
//    FolderDiffForm.Position := poMainFormCenter;
    //Point(ClientWidth shr 1,ClientHeight shr 1);
//    FolderDiffForm.Position := poOwnerFormCenter;
  end;
end;

/// procedura obsluhujuca stlacenie tlacidla v hlavnom menu
procedure TMainForm.ShowParseTrees1Click(Sender: TObject);
begin
  FileDiffForm.ShowParseTreesTBClick(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowOptionsTBClick(Sender: TObject);
begin
  Options1Click(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla v toolbare
procedure TMainForm.ShowHelpTBClick(Sender: TObject);
begin
  Help2Click(Sender);
end;

/// procedura obsluhujuca stlacenie tlacidla File->Quick Start v hlavnom menu
procedure TMainForm.QuickStart1Click(Sender: TObject);
begin
  //opens files recently used in the last run of this program
  if FileExists(LastGrammarPath) then
    GrammarEditForm.InternalOpen(Sender,LastGrammarPath);

  if FileExists(LastLeftPath) then
    LForm.InternalOpen(Sender,LastLeftPath);
  if FileExists(LastRightPath) then
    RForm.InternalOpen(Sender,LastRightPath);

  if DirectoryExists(LastFolderDir1Path) then
    FolderDiffForm.LoadDirectory(LastFolderDir1Path,true,FXRecursiveFolders,FolderDiffForm.StringGrid1,true);
  if DirectoryExists(LastFolderDir2Path) then
    FolderDiffForm.LoadDirectory(LastFolderDir2Path,false,FXRecursiveFolders,FolderDiffForm.StringGrid2,true);

  if FileExists(LastFile1Path) then
    FileDiffForm.MyEdit1.LoadFromFile(LastFile1Path);
  if FileExists(LastFile2Path) then
    FileDiffForm.MyEdit2.LoadFromFile(LastFile2Path);
end;

end.
