/* ************************************************************************** */
/* ****************************** variables ********************************* */
/* ************************************************************************** */

#if !defined(_MPSSERVER_VARS_H_INCLUDED_)
#define _MPSSERVER_VARS_H_INCLUDED_

#include "MPSServer_defs.h"
#include "process_list.h"
#include "message_list.h"
#include "operation_list.h"

#if defined(DEFINE_VARIABLES)
	#define EXTERNAL_VARIABLE
#else
	#define EXTERNAL_VARIABLE extern
#endif

EXTERNAL_VARIABLE unsigned short int listening_port;
EXTERNAL_VARIABLE int tcp_socket, exit_server, accepted_socket, num_threads, exit_semaphore_waiting, num_clients, listen_return;
EXTERNAL_VARIABLE socklen_t accepted_socket_size;
EXTERNAL_VARIABLE u_long wanted_pid, accepted_pid, pid_conn_sequencer, pid_sequencer, mid_sequencer, oid_sequencer;

EXTERNAL_VARIABLE fd_set sockets;
EXTERNAL_VARIABLE struct sockaddr accepted_name;
EXTERNAL_VARIABLE thread_data *first_thread_data;
EXTERNAL_VARIABLE pthread_mutex_t thread_mutex;
EXTERNAL_VARIABLE sem_t exit_semaphore;
EXTERNAL_VARIABLE struct timeval listen_timeout;

EXTERNAL_VARIABLE process_list_Block_List *process_list;
EXTERNAL_VARIABLE operation_list_Block_List *operation_send_list, *operation_recv_list;

#if defined(CREATE_LOG)
	#if defined(DEFINE_VARIABLES)
		char *log_name="MPSServer.log";
	#else
		EXTERNAL_VARIABLE char *log_name;
	#endif
	EXTERNAL_VARIABLE FILE *log_file;
	EXTERNAL_VARIABLE pthread_mutex_t log_mutex;

	void write_log_initialization();
	void write_log_deinitialization();
	void write_log_server_startup(int resultid, char *reason);
	void write_log_server_shutdown();
	void write_log_client_connect(int resultid, long pid, char *reason);
	void write_log_client_disconnect(long pid, char *reason);
	void write_log_operation_start(int resultid, long pid, int async, long newpid, long mid, long mlength, int errorid, char *reason);
	void write_log_operation_end(int resultid, long pid, int async, int errorid, char *reason);
	void write_log_operation_create(int resultid, long pid, int async, u_long mlength, char *mtext, long mid, int errorid, char *reason);
	void write_log_operation_destroy(int resultid, long pid, int async, long mid, int errorid, char *reason);
	void write_log_operation_send(int resultid, long pid, int async, long mid, u_long num_recv_pids, u_long *recv_pids, long recv_pid, long new_mid, int errorid, char *reason);
	void write_log_operation_recv(int resultid, long pid, int async, u_long num_send_pids, u_long *send_pids, char *fname, long send_pid, long mid, long old_mid, int mlength, int errorid, char *reason);
	void write_log_sendrecv_exec(int resultid, long recv_pid, long send_pid, long recv_mid, long send_mid, int mlength, int errorid, char *reason);
#else
	#define write_log_initialization()
	#define write_log_deinitialization()
	#define write_log_server_startup(resultid, reason)
	#define write_log_server_shutdown()
	#define write_log_client_connect(resultid, pid, reason)
	#define write_log_client_disconnect(pid, reason)
	#define write_log_operation_start(resultid, pid, async, newpid, mid, mlength, errorid, reason)
	#define write_log_operation_end(resultid, pid, async, errorid, reason)
	#define write_log_operation_create(resultid, pid, async, mlength, mtext, mid, errorid, reason)
	#define write_log_operation_destroy(resultid, pid, async, mid, errorid, reason)
	#define write_log_operation_send(resultid, pid, async, mid, num_recv_pids, recv_pids, recv_pid, new_mid, errorid, reason)
	#define write_log_operation_recv(resultid, pid, async, num_send_pids, send_pids, fname, send_pid, mid, old_mid, mlength, errorid, reason)
	#define write_log_sendrecv_exec(resultid, recv_pid, send_pid, recv_mid, send_mid, mlength, errorid, reason)
#endif

#if !defined(DEFINE_VARIABLES)
EXTERNAL_VARIABLE function_data functions[];
#endif

#if defined(__MINGW32__)
EXTERNAL_VARIABLE WORD wVersionRequested;
EXTERNAL_VARIABLE WSADATA wsaData;
#endif

#endif
