/*
 * Decompiled with CFR 0.152.
 */
package lp.parse;

import java.util.List;
import java.util.Set;
import lp.parse.LpLexer;
import lp.parse.LpParser;
import lp.parse.LpTokenType;
import lp.struct.LpAbstractStructureUnit;
import lp.struct.LpAtom;
import lp.struct.LpCompoundTerm;
import lp.struct.LpConstant;
import lp.struct.LpFunction;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpTerm;
import lp.struct.LpVariable;
import lp.unit.EvolpProgram;
import lp.unit.GeneralizedLogicProgram;

public class EvolpParser
extends LpParser {
    public static final LpRule SEP_RULE;

    public EvolpParser() {
    }

    public EvolpParser(LpLexer lexer) {
        super(lexer);
    }

    public EvolpProgram parseEvolp() {
        EvolpProgram result = new EvolpProgram();
        GeneralizedLogicProgram p = new GeneralizedLogicProgram();
        int i = 0;
        while (this.hasMoreTokens()) {
            LpRule r = this.parseRule();
            if (SEP_RULE.equals(r)) {
                if (i == 0) {
                    result.setBaseProgram(p);
                } else {
                    result.addEvent(p);
                }
                p = new GeneralizedLogicProgram();
                ++i;
                continue;
            }
            p.add(r);
        }
        if (i == 0) {
            result.setBaseProgram(p);
        } else {
            result.addEvent(p);
        }
        return result;
    }

    public LpTerm parseTerm() {
        LpAbstractStructureUnit result;
        int parenCount = 0;
        while (this.getLexer().getTokenType() == LpTokenType.LEFT_PAREN) {
            this.match(LpTokenType.LEFT_PAREN);
            ++parenCount;
        }
        if (this.getLexer().getTokenType() == LpTokenType.UPPERCASE_WORD) {
            result = LpVariable.getInstance(this.getLexer().getLexem());
            this.nextToken();
        } else {
            LpTokenType type = this.getLexer().getTokenType();
            if (type == LpTokenType.LOWERCASE_WORD) {
                String name = this.getLexer().getLexem();
                this.nextToken();
                boolean positive = true;
                if (this.getLexer().getTokenType() == LpTokenType.LOWERCASE_WORD && "not".equals(name)) {
                    positive = false;
                    name = this.getLexer().getLexem();
                    this.nextToken();
                }
                List<LpTerm> arguments = this.parseArguments();
                if (!positive) {
                    this.expect(LpTokenType.RULE_ARROW);
                }
                if (this.getLexer().getTokenType() == LpTokenType.RULE_ARROW) {
                    Set<LpLiteral> body = this.parseRuleBody(false);
                    if (this.getLexer().getTokenType() == LpTokenType.DOT) {
                        this.match(LpTokenType.DOT);
                    }
                    LpLiteral head = LpAtom.getInstance(LpPredicate.getInstance(name, arguments), arguments).getLiteral(positive);
                    result = new LpRule(head, body);
                } else {
                    result = arguments == null ? LpConstant.getInstance(name) : LpCompoundTerm.getInstance(LpFunction.getInstance(name, arguments), arguments);
                }
            } else {
                result = this.parseOnlyRule();
                if (this.getLexer().getTokenType() == LpTokenType.DOT) {
                    this.match(LpTokenType.DOT);
                }
            }
        }
        for (int i = 0; i < parenCount; ++i) {
            this.match(LpTokenType.RIGHT_PAREN);
        }
        return result;
    }

    static {
        LpAtom sepAtom = LpAtom.getInstance(LpPredicate.getInstance("newEvents", 0), null);
        LpLiteral sepLit = sepAtom.getPositiveLiteral();
        SEP_RULE = new LpRule(sepLit, null);
    }
}

