/*
 * Decompiled with CFR 0.152.
 */
package lp.parse;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import lp.parse.LpToken;
import lp.parse.LpTokenType;
import lp.util.ExceptionAdapter;

public class LpLexer
implements Closeable {
    private Reader reader = null;
    private int la = 0;
    private LpTokenType type = null;
    private final StringBuilder lexem = new StringBuilder();
    private int lineNumber = 1;
    private int position = 0;

    public void setInput(CharSequence input) {
        if (input == null) {
            throw new IllegalArgumentException("The source string cannot be null!");
        }
        this.setInput(new StringReader(((Object)input).toString()));
    }

    public void setInput(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The source file cannot be null!");
        }
        try {
            this.setInput(new BufferedReader(new FileReader(file)));
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
    }

    public void setInput(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("The source Reader cannot be null!");
        }
        this.reader = reader;
        this.initialize();
    }

    protected void initialize() {
        this.type = null;
        this.lineNumber = 1;
        this.position = 0;
        this.lexem.setLength(0);
        this.la = 0;
        this.readNewLA();
    }

    public void close() {
        this.type = null;
        this.lexem.setLength(0);
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
    }

    public void nextToken() {
        while (Character.isWhitespace(this.la)) {
            this.readNewLA();
        }
        while (this.la == 37) {
            while (this.la != -1 && this.la != 13 && this.la != 10) {
                this.readNewLA();
            }
            while (Character.isWhitespace(this.la)) {
                this.readNewLA();
            }
        }
        this.lexem.setLength(0);
        switch (this.la) {
            case 40: {
                this.appendOne();
                this.type = LpTokenType.LEFT_PAREN;
                break;
            }
            case 41: {
                this.appendOne();
                this.type = LpTokenType.RIGHT_PAREN;
                break;
            }
            case 44: {
                this.appendOne();
                this.type = LpTokenType.COMMA;
                break;
            }
            case 46: {
                this.appendOne();
                this.type = LpTokenType.DOT;
                break;
            }
            case 58: 
            case 60: {
                this.appendOne();
                if (this.la == 45) {
                    this.appendOne();
                    this.type = LpTokenType.RULE_ARROW;
                    break;
                }
                this.type = LpTokenType.UNKNOWN_CHAR;
                break;
            }
            case -1: {
                this.type = LpTokenType.EOF;
                break;
            }
            default: {
                if (this.isWordLetter((char)this.la)) {
                    boolean upperCase = Character.isUpperCase(this.la);
                    while (this.isWordLetter((char)this.la)) {
                        this.appendOne();
                    }
                    this.type = upperCase ? LpTokenType.UPPERCASE_WORD : LpTokenType.LOWERCASE_WORD;
                    break;
                }
                this.appendOne();
                this.type = LpTokenType.UNKNOWN_CHAR;
            }
        }
        assert (this.type != null);
    }

    public LpTokenType getTokenType() {
        return this.type;
    }

    public String getLexem() {
        if (this.type != null) {
            String result = this.lexem.toString();
            assert (this.type == LpTokenType.EOF || this.lexem.length() > 0);
            switch (this.type) {
                case LEFT_PAREN: {
                    assert ("(".equals(result));
                    break;
                }
                case RIGHT_PAREN: {
                    assert (")".equals(result));
                    break;
                }
                case COMMA: {
                    assert (",".equals(result));
                    break;
                }
                case DOT: {
                    assert (".".equals(result));
                    break;
                }
                case RULE_ARROW: {
                    assert ("<-".equals(result) || ":-".equals(result));
                    break;
                }
                case LOWERCASE_WORD: {
                    for (int i = 0; i < result.length(); ++i) {
                        assert (this.isWordLetter(result.charAt(i)));
                    }
                    assert (!Character.isUpperCase(result.charAt(0)));
                    break;
                }
                case UPPERCASE_WORD: {
                    for (int i = 0; i < result.length(); ++i) {
                        assert (this.isWordLetter(result.charAt(i)));
                    }
                    assert (Character.isUpperCase(result.charAt(0)));
                    break;
                }
                case EOF: {
                    assert ("".equals(result));
                    break;
                }
                case UNKNOWN_CHAR: {
                    assert (result.length() == 1);
                    break;
                }
            }
            return result;
        }
        return null;
    }

    public int getLineNumber() {
        if (this.type != null) {
            assert (this.lineNumber > 0);
            return this.lineNumber;
        }
        return -1;
    }

    public int getPosition() {
        if (this.type != null) {
            assert (this.position > 0);
            return this.position - this.lexem.length();
        }
        return -1;
    }

    public LpToken getToken() {
        if (this.type != null) {
            return new LpToken(this.getTokenType(), this.getLexem(), this.getLineNumber(), this.getPosition());
        }
        return null;
    }

    private void readNewLA() {
        try {
            if (this.la != -1) {
                if (this.la == 13) {
                    ++this.lineNumber;
                    this.position = 1;
                    this.la = this.reader.read();
                    if (this.la == 10) {
                        this.la = this.reader.read();
                    }
                } else if (this.la == 10) {
                    ++this.lineNumber;
                    this.position = 1;
                    this.la = this.reader.read();
                } else {
                    ++this.position;
                    this.la = this.reader.read();
                }
            }
        }
        catch (IOException e) {
            new ExceptionAdapter(e);
        }
    }

    private void appendOne() {
        this.lexem.append((char)this.la);
        this.readNewLA();
    }

    private boolean isWordLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }
}

