/*
 * Decompiled with CFR 0.152.
 */
package lp.parse;

import java.util.LinkedList;
import lp.parse.LpLexer;
import lp.parse.LpToken;
import lp.parse.LpTokenType;
import lp.util.ExceptionAdapter;

public class LpLookaheadLexer
extends LpLexer {
    private static final String NEGATIVE_STEPS_MESSAGE = "The number of steps must be non-negative.";
    private final LinkedList<LpToken> buffer = new LinkedList();

    public void close() {
        this.buffer.clear();
        super.close();
    }

    protected void initialize() {
        super.initialize();
        this.buffer.clear();
    }

    public void nextToken() {
        if (!this.buffer.isEmpty()) {
            this.buffer.removeFirst();
        }
        if (this.buffer.isEmpty()) {
            this.load(1);
        }
    }

    public LpTokenType getTokenType() {
        LpTokenType result;
        block2: {
            result = null;
            try {
                result = this.getTokenType(0);
            }
            catch (ExceptionAdapter e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    public String getLexem() {
        String result;
        block2: {
            result = null;
            try {
                result = this.getLexem(0);
            }
            catch (ExceptionAdapter e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    public int getLineNumber() {
        int result;
        block2: {
            result = 0;
            try {
                result = this.getLineNumber(0);
            }
            catch (ExceptionAdapter e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    public int getPosition() {
        int result;
        block2: {
            result = 0;
            try {
                result = this.getPosition(0);
            }
            catch (ExceptionAdapter e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    public LpToken getToken() {
        LpToken result;
        block2: {
            result = null;
            try {
                result = this.getToken(0);
            }
            catch (ExceptionAdapter e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    public LpTokenType getTokenType(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(NEGATIVE_STEPS_MESSAGE);
        }
        return this.buffer.isEmpty() ? super.getTokenType() : this.getToken(n).getType();
    }

    public String getLexem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(NEGATIVE_STEPS_MESSAGE);
        }
        return this.buffer.isEmpty() ? super.getLexem() : this.getToken(n).getLexem();
    }

    public int getLineNumber(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(NEGATIVE_STEPS_MESSAGE);
        }
        return this.buffer.isEmpty() ? super.getLineNumber() : this.getToken(n).getLineNumber();
    }

    public int getPosition(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(NEGATIVE_STEPS_MESSAGE);
        }
        return this.buffer.isEmpty() ? super.getPosition() : this.getToken(n).getPosition();
    }

    public LpToken getToken(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(NEGATIVE_STEPS_MESSAGE);
        }
        if (this.buffer.isEmpty()) {
            return super.getToken();
        }
        if (this.buffer.size() <= n) {
            this.load(n - this.buffer.size() + 1);
        }
        return this.buffer.get(n);
    }

    private void load(int count) {
        for (int i = 0; i < count; ++i) {
            super.nextToken();
            this.buffer.add(new LpToken(super.getTokenType(), super.getLexem(), super.getLineNumber(), super.getPosition()));
        }
    }
}

