/*
 * Decompiled with CFR 0.152.
 */
package lp.parse;

import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lp.parse.LpLexer;
import lp.parse.LpParserException;
import lp.parse.LpTokenType;
import lp.struct.LpAtom;
import lp.struct.LpCompoundTerm;
import lp.struct.LpConstant;
import lp.struct.LpFunction;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpTerm;
import lp.struct.LpVariable;
import lp.unit.GeneralizedLogicProgram;
import lp.unit.LogicProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LpParser
implements Closeable {
    private final LpLexer lexer;

    public LpParser() {
        this(new LpLexer());
    }

    public LpParser(LpLexer lexer) {
        this.lexer = lexer;
    }

    public void setInput(CharSequence input) {
        this.lexer.setInput(input);
        this.nextToken();
    }

    public void setInput(File input) {
        this.lexer.setInput(input);
        this.nextToken();
    }

    public void setInput(Reader input) {
        this.lexer.setInput(input);
        this.nextToken();
    }

    @Override
    public void close() {
        this.getLexer().close();
    }

    public boolean hasMoreTokens() {
        LpTokenType type = this.getLexer().getTokenType();
        return type != null && type != LpTokenType.EOF;
    }

    public LogicProgram parseAllRules() {
        return this.parseAllRules(new GeneralizedLogicProgram());
    }

    public LogicProgram parseAllRules(LogicProgram program) {
        while (this.hasMoreTokens()) {
            program.add(this.parseRule());
        }
        return program;
    }

    public LpRule parseRule() {
        LpRule result = this.parseOnlyRule();
        this.match(LpTokenType.DOT);
        return result;
    }

    protected LpRule parseOnlyRule() {
        LpLiteral head = this.getLexer().getTokenType() == LpTokenType.RULE_ARROW ? null : this.parseLiteral();
        Set<LpLiteral> body = this.parseRuleBody(head == null);
        return new LpRule(head, body);
    }

    protected Set<LpLiteral> parseRuleBody(boolean constraint) {
        LinkedHashSet<LpLiteral> result = null;
        if (this.getLexer().getTokenType() == LpTokenType.RULE_ARROW) {
            this.nextToken();
            if (constraint) {
                this.expect(LpTokenType.LOWERCASE_WORD);
            }
            if (this.getLexer().getTokenType() == LpTokenType.LOWERCASE_WORD) {
                result = new LinkedHashSet<LpLiteral>();
                result.add(this.parseLiteral());
                while (this.getLexer().getTokenType() == LpTokenType.COMMA) {
                    this.nextToken();
                    result.add(this.parseLiteral());
                }
            }
        }
        return result;
    }

    public LpLiteral parseLiteral() {
        boolean positive = true;
        if (this.getLexer().getTokenType() == LpTokenType.LOWERCASE_WORD && this.getLexer().getLexem().equals("not")) {
            positive = false;
            this.nextToken();
        }
        return this.parseAtom().getLiteral(positive);
    }

    public LpAtom parseAtom() {
        this.expect(LpTokenType.LOWERCASE_WORD);
        String name = this.getLexer().getLexem();
        this.nextToken();
        List<LpTerm> arguments = this.parseArguments();
        LpPredicate pred = LpPredicate.getInstance(name, arguments);
        return LpAtom.getInstance(pred, arguments);
    }

    public LpTerm parseTerm() {
        if (this.getLexer().getTokenType() == LpTokenType.UPPERCASE_WORD) {
            LpVariable result = LpVariable.getInstance(this.getLexer().getLexem());
            this.nextToken();
            return result;
        }
        this.expect(LpTokenType.LOWERCASE_WORD);
        String name = this.getLexer().getLexem();
        this.nextToken();
        List<LpTerm> arguments = this.parseArguments();
        if (arguments == null) {
            return LpConstant.getInstance(name);
        }
        return LpCompoundTerm.getInstance(LpFunction.getInstance(name, arguments), arguments);
    }

    protected List<LpTerm> parseArguments() {
        ArrayList<LpTerm> arguments = null;
        if (this.getLexer().getTokenType() == LpTokenType.LEFT_PAREN) {
            this.match(LpTokenType.LEFT_PAREN);
            arguments = new ArrayList<LpTerm>();
            arguments.add(this.parseTerm());
            while (this.getLexer().getTokenType() == LpTokenType.COMMA) {
                this.match(LpTokenType.COMMA);
                arguments.add(this.parseTerm());
            }
            this.match(LpTokenType.RIGHT_PAREN);
        }
        return arguments;
    }

    protected void match(LpTokenType token) {
        this.expect(token);
        this.nextToken();
    }

    protected void expect(LpTokenType token) {
        if (this.getLexer().getTokenType() != token) {
            throw new LpParserException(token, this.getLexer());
        }
    }

    protected final void nextToken() {
        if (this.getLexer().getTokenType() != LpTokenType.EOF) {
            this.getLexer().nextToken();
        }
    }

    protected LpLexer getLexer() {
        return this.lexer;
    }
}

