/*
 * Decompiled with CFR 0.152.
 */
package lp.parse;

import lp.parse.LpLexer;
import lp.parse.LpTokenType;

public class LpParserException
extends RuntimeException {
    private final LpTokenType expected;
    private final String found;
    private final int position;
    private final int lineNumber;

    public LpParserException(LpTokenType expected, LpLexer lexer) {
        this(expected, lexer.getLexem(), lexer.getLineNumber(), lexer.getPosition());
    }

    public LpParserException(LpTokenType expected, String found, int lineNumber, int position) {
        this.expected = expected;
        this.found = found;
        this.lineNumber = lineNumber;
        this.position = position;
    }

    public LpTokenType getExpected() {
        return this.expected;
    }

    public String getFound() {
        return this.found;
    }

    public int getPosition() {
        return this.position;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        if ("".equals(this.found)) {
            return "line " + this.lineNumber + ", position " + this.position + ": Unexpected end of input, " + this.expected.getDescription() + " expected";
        }
        return "line " + this.lineNumber + ", position " + this.position + ": Syntax error on token \"" + this.found + "\", " + this.expected.getDescription() + " expected.";
    }
}

