/*
 * Decompiled with CFR 0.152.
 */
package lp.struct;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import lp.struct.LpStructureUnit;
import lp.struct.util.EvolpPrettyPrinter;
import lp.struct.util.LpBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LpAbstractStructureUnit
implements LpStructureUnit {
    protected static final LpBuffer TO_STRING_BUFFER = EvolpPrettyPrinter.getBuffer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        LpBuffer lpBuffer = TO_STRING_BUFFER;
        synchronized (lpBuffer) {
            return TO_STRING_BUFFER.asString(this);
        }
    }

    protected static <T> List<T> toUnmodifiableList(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        boolean modifiable = true;
        try {
            List empty = Collections.emptyList();
            list.addAll(empty);
        }
        catch (UnsupportedOperationException e) {
            modifiable = false;
        }
        return modifiable ? Collections.unmodifiableList(list) : list;
    }

    protected static <T> Set<T> toUnmodifiableSet(Set<T> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        boolean modifiable = true;
        try {
            Set empty = Collections.emptySet();
            set.addAll(empty);
        }
        catch (UnsupportedOperationException e) {
            modifiable = false;
        }
        return modifiable ? Collections.unmodifiableSet(set) : set;
    }
}

