/*
 * Decompiled with CFR 0.152.
 */
package lp.struct;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lp.struct.LpAbstractStructureUnit;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpStructureUnitVisitor;
import lp.struct.LpTerm;
import lp.struct.util.LpBuffer;
import lp.struct.util.LpPrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LpAtom
extends LpAbstractStructureUnit {
    private static final Map<String, LpAtom> pool = new HashMap<String, LpAtom>(100);
    private static final LpBuffer keyBuilder = LpPrettyPrinter.getBuffer();
    private final LpPredicate predicate;
    private final List<LpTerm> arguments;
    private LpLiteral posLit;
    private LpLiteral negLit;

    public static synchronized LpAtom getInstance(LpPredicate predicate, List<LpTerm> arguments) {
        String key;
        LpAtom result;
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate is null!");
        }
        List<LpTerm> args = LpAtom.toUnmodifiableList(arguments);
        assert (args != null);
        LpAtom.checkArity(predicate, args);
        assert (args.size() == predicate.getArity());
        keyBuilder.reset();
        keyBuilder.append(predicate);
        keyBuilder.append('/').append(Integer.toString(predicate.getArity()));
        if (args != null && !args.isEmpty()) {
            keyBuilder.append('(');
            Iterator<LpTerm> argIter = args.iterator();
            keyBuilder.append(argIter.next());
            while (argIter.hasNext()) {
                keyBuilder.append(',');
                keyBuilder.append(argIter.next());
            }
            keyBuilder.append(')');
        }
        if ((result = pool.get(key = keyBuilder.toString())) == null) {
            result = new LpAtom(predicate, args);
            pool.put(key, result);
        }
        return result;
    }

    private static void checkArity(LpPredicate predicate, List<LpTerm> arguments) {
        if (predicate.getArity() != arguments.size()) {
            throw new IllegalArgumentException("Number of arguments (" + arguments.size() + ") doesn't match the function's arity (" + predicate.getArity() + ")!");
        }
    }

    private LpAtom(LpPredicate predicate, List<LpTerm> arguments) {
        this.predicate = predicate;
        this.arguments = arguments;
        this.posLit = null;
        this.negLit = null;
    }

    public LpPredicate getPredicate() {
        return this.predicate;
    }

    public List<LpTerm> getArguments() {
        return this.arguments;
    }

    public synchronized LpLiteral getPositiveLiteral() {
        if (this.posLit == null) {
            this.posLit = new LpLiteral(true, this);
        }
        return this.posLit;
    }

    public synchronized LpLiteral getNegativeLiteral() {
        if (this.negLit == null) {
            this.negLit = new LpLiteral(false, this);
        }
        return this.negLit;
    }

    public LpLiteral getLiteral(boolean positive) {
        return positive ? this.getPositiveLiteral() : this.getNegativeLiteral();
    }

    @Override
    public void accept(LpStructureUnitVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LpAtom)) {
            return false;
        }
        LpAtom l = (LpAtom)obj;
        if (!this.getPredicate().equals(l.getPredicate())) {
            return false;
        }
        return ((Object)this.getArguments()).equals(l.getArguments());
    }

    public int hashCode() {
        int result = 0;
        result += this.getPredicate().hashCode();
        return result += ((Object)this.getArguments()).hashCode();
    }
}

