/*
 * Decompiled with CFR 0.152.
 */
package lp.struct;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lp.struct.LpAbstractStructureUnit;
import lp.struct.LpFunction;
import lp.struct.LpStructureUnitVisitor;
import lp.struct.LpTerm;
import lp.struct.util.LpBuffer;
import lp.struct.util.LpPrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LpCompoundTerm
extends LpAbstractStructureUnit
implements LpTerm {
    private static final Map<String, LpCompoundTerm> pool = new HashMap<String, LpCompoundTerm>(100);
    private static final LpBuffer keyBuilder = LpPrettyPrinter.getBuffer();
    private final LpFunction function;
    private final List<LpTerm> arguments;

    public static synchronized LpCompoundTerm getInstance(LpFunction function, List<LpTerm> arguments) {
        String key;
        LpCompoundTerm result;
        if (function == null) {
            throw new IllegalArgumentException("Function is null!");
        }
        List<LpTerm> args = LpCompoundTerm.toUnmodifiableList(arguments);
        assert (args != null);
        LpCompoundTerm.checkArity(function, args);
        assert (args.size() == function.getArity());
        keyBuilder.reset();
        keyBuilder.append(function);
        keyBuilder.append('/').append(Integer.toString(function.getArity()));
        if (args != null && !args.isEmpty()) {
            keyBuilder.append('(');
            Iterator<LpTerm> argIter = args.iterator();
            keyBuilder.append(argIter.next());
            while (argIter.hasNext()) {
                keyBuilder.append(',');
                keyBuilder.append(argIter.next());
            }
            keyBuilder.append(')');
        }
        if ((result = pool.get(key = keyBuilder.toString())) == null) {
            result = new LpCompoundTerm(function, args);
            pool.put(key, result);
        }
        return result;
    }

    private static void checkArity(LpFunction function, List<LpTerm> arguments) {
        if (function.getArity() != arguments.size()) {
            throw new IllegalArgumentException("Number of arguments (" + arguments.size() + ") doesn't match the function's arity (" + function.getArity() + ")!");
        }
    }

    private LpCompoundTerm(LpFunction function, List<LpTerm> arguments) {
        this.function = function;
        this.arguments = arguments;
    }

    public LpFunction getFunction() {
        return this.function;
    }

    public List<LpTerm> getArguments() {
        return this.arguments;
    }

    @Override
    public void accept(LpStructureUnitVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LpCompoundTerm)) {
            return false;
        }
        LpCompoundTerm t = (LpCompoundTerm)obj;
        if (!this.getFunction().equals(t.getFunction())) {
            return false;
        }
        return ((Object)this.getArguments()).equals(t.getArguments());
    }

    @Override
    public int hashCode() {
        super.hashCode();
        int result = 0;
        result += this.getFunction().hashCode();
        return result += ((Object)this.getArguments()).hashCode();
    }
}

