/*
 * Decompiled with CFR 0.152.
 */
package lp.struct;

import java.util.HashMap;
import java.util.Map;
import lp.struct.LpAbstractStructureUnit;
import lp.struct.LpStructureUnitVisitor;
import lp.struct.LpTerm;

public class LpConstant
extends LpAbstractStructureUnit
implements LpTerm {
    private static final Map<String, LpConstant> pool = new HashMap<String, LpConstant>(100);
    private final String name;

    public static synchronized LpConstant getInstance(String name) {
        LpConstant result = pool.get(name);
        if (result == null) {
            result = new LpConstant(name);
            pool.put(name, result);
        }
        return result;
    }

    protected LpConstant(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The constant's name must not be null!");
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException("The constant's name must not be empty!");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void accept(LpStructureUnitVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LpConstant)) {
            return false;
        }
        LpConstant c = (LpConstant)obj;
        return this.getName().equals(c.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

