/*
 * Decompiled with CFR 0.152.
 */
package lp.struct;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lp.struct.LpAbstractStructureUnit;
import lp.struct.LpStructureUnitVisitor;
import lp.struct.LpTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LpFunction
extends LpAbstractStructureUnit {
    private static final Map<String, LpFunction> pool = new HashMap<String, LpFunction>(100);
    private final String name;
    private final int arity;

    public static synchronized LpFunction getInstance(String name, int arity) {
        String key = name + '/' + arity;
        LpFunction result = pool.get(key);
        if (result == null) {
            result = new LpFunction(name, arity);
            pool.put(key, result);
        }
        return result;
    }

    public static synchronized LpFunction getInstance(String name, List<LpTerm> arguments) {
        return LpFunction.getInstance(name, arguments == null ? 0 : arguments.size());
    }

    protected LpFunction(String name, int arity) {
        if (name == null) {
            throw new IllegalArgumentException("A function's name must not be null!");
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException("A function's name must not be empty!");
        }
        if (arity < 1) {
            throw new IllegalArgumentException("A function's arity must be positive!");
        }
        this.name = name;
        this.arity = arity;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    @Override
    public void accept(LpStructureUnitVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LpFunction)) {
            return false;
        }
        LpFunction f = (LpFunction)obj;
        return this.getName().equals(f.getName()) && this.getArity() == f.getArity();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getArity();
    }

    @Override
    public String toString() {
        return super.toString() + "/" + this.getArity();
    }
}

