/*
 * Decompiled with CFR 0.152.
 */
package lp.struct;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lp.struct.LpAbstractStructureUnit;
import lp.struct.LpStructureUnitVisitor;
import lp.struct.LpTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LpPredicate
extends LpAbstractStructureUnit {
    private static final Map<String, LpPredicate> pool = new HashMap<String, LpPredicate>(100);
    private final String name;
    private final int arity;

    public static synchronized LpPredicate getInstance(String name, int arity) {
        String key = name + '/' + arity;
        LpPredicate result = pool.get(key);
        if (result == null) {
            result = new LpPredicate(name, arity);
            pool.put(key, result);
        }
        return result;
    }

    public static synchronized LpPredicate getInstance(String name, List<LpTerm> arguments) {
        return LpPredicate.getInstance(name, arguments == null ? 0 : arguments.size());
    }

    protected LpPredicate(String name, int arity) {
        if (name == null) {
            throw new IllegalArgumentException("A predicate's name must not be null!");
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException("A predicate's name must not be empty!");
        }
        if (arity < 0) {
            throw new IllegalArgumentException("A predicate's arity must be non-negative!");
        }
        this.name = name;
        this.arity = arity;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    @Override
    public void accept(LpStructureUnitVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LpPredicate)) {
            return false;
        }
        LpPredicate p = (LpPredicate)obj;
        return this.getName().equals(p.getName()) && this.getArity() == p.getArity();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getArity();
    }

    @Override
    public String toString() {
        return super.toString() + "/" + this.getArity();
    }
}

