/*
 * Decompiled with CFR 0.152.
 */
package lp.struct;

import java.util.Set;
import lp.struct.LpAbstractStructureUnit;
import lp.struct.LpLiteral;
import lp.struct.LpStructureUnitVisitor;
import lp.struct.LpTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LpRule
extends LpAbstractStructureUnit
implements LpTerm {
    private final LpLiteral head;
    private final Set<LpLiteral> body;

    public LpRule(LpLiteral ruleHead, Set<LpLiteral> ruleBody) {
        if (ruleHead == null && ruleBody == null) {
            throw new IllegalArgumentException("A rule cannot have both a null head and a null body!");
        }
        this.head = ruleHead;
        this.body = LpRule.toUnmodifiableSet(ruleBody);
    }

    public LpLiteral getHead() {
        return this.head;
    }

    public Set<LpLiteral> getBody() {
        return this.body;
    }

    public int getBodySize() {
        return this.body.size();
    }

    @Override
    public void accept(LpStructureUnitVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LpRule)) {
            return false;
        }
        LpRule r = (LpRule)obj;
        boolean headsEqual = this.getHead() == null ? r.getHead() == null : this.getHead().equals(r.getHead());
        boolean bodiesEqual = ((Object)this.getBody()).equals(r.getBody());
        return headsEqual && bodiesEqual;
    }

    @Override
    public int hashCode() {
        super.hashCode();
        int result = 0;
        result += this.getHead() == null ? 0 : this.getHead().hashCode();
        return result += ((Object)this.getBody()).hashCode();
    }
}

